/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;

public class CombinedChannelDuplexHandler<I extends ChannelInboundHandler, O extends ChannelOutboundHandler>
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CombinedChannelDuplexHandler.class);
    private DelegatingChannelHandlerContext inboundCtx;
    private DelegatingChannelHandlerContext outboundCtx;
    private volatile boolean handlerAdded;
    private I inboundHandler;
    private O outboundHandler;

    protected CombinedChannelDuplexHandler() {
        this.ensureNotSharable();
    }

    /*
     * WARNING - void declaration
     */
    public CombinedChannelDuplexHandler(I inboundHandler, O outboundHandler) {
        void var2_2;
        void var1_1;
        this.ensureNotSharable();
        this.init(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected final void init(I inboundHandler, O outboundHandler) {
        void var2_2;
        void var1_1;
        this.validate(inboundHandler, outboundHandler);
        this.inboundHandler = var1_1;
        this.outboundHandler = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void validate(I inboundHandler, O outboundHandler) {
        void var2_2;
        void var1_1;
        if (this.inboundHandler != null) {
            throw new IllegalStateException("init() can not be invoked if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with non-default constructor.");
        }
        ObjectUtil.checkNotNull(inboundHandler, (String)"inboundHandler");
        ObjectUtil.checkNotNull(outboundHandler, (String)"outboundHandler");
        if (var1_1 instanceof ChannelOutboundHandler) {
            throw new IllegalArgumentException("inboundHandler must not implement " + ChannelOutboundHandler.class.getSimpleName() + " to get combined.");
        }
        if (var2_2 instanceof ChannelInboundHandler) {
            throw new IllegalArgumentException("outboundHandler must not implement " + ChannelInboundHandler.class.getSimpleName() + " to get combined.");
        }
    }

    protected final I inboundHandler() {
        return this.inboundHandler;
    }

    protected final O outboundHandler() {
        return this.outboundHandler;
    }

    private void checkAdded() {
        if (!this.handlerAdded) {
            throw new IllegalStateException("handler not added to pipeline yet");
        }
    }

    public final void removeInboundHandler() {
        this.checkAdded();
        this.inboundCtx.remove();
    }

    public final void removeOutboundHandler() {
        this.checkAdded();
        this.outboundCtx.remove();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.inboundHandler == null) {
            throw new IllegalStateException("init() must be invoked before being added to a " + ChannelPipeline.class.getSimpleName() + " if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with the default constructor.");
        }
        this.outboundCtx = new DelegatingChannelHandlerContext(ctx, (ChannelHandler)this.outboundHandler);
        this.inboundCtx = new DelegatingChannelHandlerContext(this, (ChannelHandlerContext)var1_1, (ChannelHandler)this.inboundHandler){
            final /* synthetic */ CombinedChannelDuplexHandler this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((ChannelHandlerContext)var2_2, (ChannelHandler)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
                if (!((CombinedChannelDuplexHandler)this.this$0).outboundCtx.removed) {
                    try {
                        this.this$0.outboundHandler.exceptionCaught(this.this$0.outboundCtx, cause);
                    }
                    catch (Throwable error) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString((Throwable)error), (Object)cause);
                        } else if (logger.isWarnEnabled()) {
                            void var2_2;
                            logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)var2_2, (Object)cause);
                        }
                    }
                } else {
                    void var1_1;
                    super.fireExceptionCaught((Throwable)var1_1);
                }
                return this;
            }
        };
        this.handlerAdded = true;
        try {
            this.inboundHandler.handlerAdded(this.inboundCtx);
            return;
        }
        finally {
            this.outboundHandler.handlerAdded(this.outboundCtx);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            this.inboundCtx.remove();
            return;
        }
        finally {
            this.outboundCtx.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        assert (var1_1 == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelRegistered(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelRegistered();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        assert (var1_1 == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelUnregistered(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelUnregistered();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        assert (var1_1 == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelActive(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelActive();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        assert (var1_1 == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelInactive(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelInactive();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var2_2;
        void var1_1;
        assert (var1_1 == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.exceptionCaught(this.inboundCtx, cause);
            return;
        }
        this.inboundCtx.fireExceptionCaught((Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        void var2_2;
        void var1_1;
        assert (var1_1 == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.userEventTriggered(this.inboundCtx, evt);
            return;
        }
        this.inboundCtx.fireUserEventTriggered(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        assert (var1_1 == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelRead(this.inboundCtx, msg);
            return;
        }
        this.inboundCtx.fireChannelRead(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        assert (var1_1 == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelReadComplete(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelReadComplete();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        assert (var1_1 == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelWritabilityChanged(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelWritabilityChanged();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (var1_1 == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.bind(this.outboundCtx, localAddress, promise);
            return;
        }
        this.outboundCtx.bind((SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (var1_1 == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.connect(this.outboundCtx, remoteAddress, localAddress, promise);
            return;
        }
        this.outboundCtx.connect((SocketAddress)var2_2, (SocketAddress)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        assert (var1_1 == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.disconnect(this.outboundCtx, promise);
            return;
        }
        this.outboundCtx.disconnect((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        assert (var1_1 == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.close(this.outboundCtx, promise);
            return;
        }
        this.outboundCtx.close((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        assert (var1_1 == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.deregister(this.outboundCtx, promise);
            return;
        }
        this.outboundCtx.deregister((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        assert (var1_1 == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.read(this.outboundCtx);
            return;
        }
        this.outboundCtx.read();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (var1_1 == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.write(this.outboundCtx, msg, promise);
            return;
        }
        this.outboundCtx.write(var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        assert (var1_1 == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.flush(this.outboundCtx);
            return;
        }
        this.outboundCtx.flush();
    }

    private static class DelegatingChannelHandlerContext
    implements ChannelHandlerContext {
        private final ChannelHandlerContext ctx;
        private final ChannelHandler handler;
        boolean removed;

        /*
         * WARNING - void declaration
         */
        DelegatingChannelHandlerContext(ChannelHandlerContext ctx, ChannelHandler handler) {
            void var2_2;
            void var1_1;
            this.ctx = var1_1;
            this.handler = var2_2;
        }

        @Override
        public Channel channel() {
            return this.ctx.channel();
        }

        @Override
        public EventExecutor executor() {
            return this.ctx.executor();
        }

        @Override
        public String name() {
            return this.ctx.name();
        }

        @Override
        public ChannelHandler handler() {
            return this.ctx.handler();
        }

        @Override
        public boolean isRemoved() {
            return this.removed || this.ctx.isRemoved();
        }

        @Override
        public ChannelHandlerContext fireChannelRegistered() {
            this.ctx.fireChannelRegistered();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelUnregistered() {
            this.ctx.fireChannelUnregistered();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelActive() {
            this.ctx.fireChannelActive();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelInactive() {
            this.ctx.fireChannelInactive();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
            void var1_1;
            this.ctx.fireExceptionCaught((Throwable)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelHandlerContext fireUserEventTriggered(Object event) {
            void var1_1;
            this.ctx.fireUserEventTriggered(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelHandlerContext fireChannelRead(Object msg) {
            void var1_1;
            this.ctx.fireChannelRead(var1_1);
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelReadComplete() {
            this.ctx.fireChannelReadComplete();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelWritabilityChanged() {
            this.ctx.fireChannelWritabilityChanged();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture bind(SocketAddress localAddress) {
            void var1_1;
            return this.ctx.bind((SocketAddress)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture connect(SocketAddress remoteAddress) {
            void var1_1;
            return this.ctx.connect((SocketAddress)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
            void var2_2;
            void var1_1;
            return this.ctx.connect((SocketAddress)var1_1, (SocketAddress)var2_2);
        }

        @Override
        public ChannelFuture disconnect() {
            return this.ctx.disconnect();
        }

        @Override
        public ChannelFuture close() {
            return this.ctx.close();
        }

        @Override
        public ChannelFuture deregister() {
            return this.ctx.deregister();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
            void var2_2;
            void var1_1;
            return this.ctx.bind((SocketAddress)var1_1, (ChannelPromise)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
            void var2_2;
            void var1_1;
            return this.ctx.connect((SocketAddress)var1_1, (ChannelPromise)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.ctx.connect((SocketAddress)var1_1, (SocketAddress)var2_2, (ChannelPromise)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture disconnect(ChannelPromise promise) {
            void var1_1;
            return this.ctx.disconnect((ChannelPromise)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture close(ChannelPromise promise) {
            void var1_1;
            return this.ctx.close((ChannelPromise)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture deregister(ChannelPromise promise) {
            void var1_1;
            return this.ctx.deregister((ChannelPromise)var1_1);
        }

        @Override
        public ChannelHandlerContext read() {
            this.ctx.read();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture write(Object msg) {
            void var1_1;
            return this.ctx.write(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture write(Object msg, ChannelPromise promise) {
            void var2_2;
            void var1_1;
            return this.ctx.write(var1_1, (ChannelPromise)var2_2);
        }

        @Override
        public ChannelHandlerContext flush() {
            this.ctx.flush();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
            void var2_2;
            void var1_1;
            return this.ctx.writeAndFlush(var1_1, (ChannelPromise)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture writeAndFlush(Object msg) {
            void var1_1;
            return this.ctx.writeAndFlush(var1_1);
        }

        @Override
        public ChannelPipeline pipeline() {
            return this.ctx.pipeline();
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.ctx.alloc();
        }

        @Override
        public ChannelPromise newPromise() {
            return this.ctx.newPromise();
        }

        @Override
        public ChannelProgressivePromise newProgressivePromise() {
            return this.ctx.newProgressivePromise();
        }

        @Override
        public ChannelFuture newSucceededFuture() {
            return this.ctx.newSucceededFuture();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ChannelFuture newFailedFuture(Throwable cause) {
            void var1_1;
            return this.ctx.newFailedFuture((Throwable)var1_1);
        }

        @Override
        public ChannelPromise voidPromise() {
            return this.ctx.voidPromise();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> Attribute<T> attr(AttributeKey<T> key) {
            void var1_1;
            return this.ctx.channel().attr((AttributeKey)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> boolean hasAttr(AttributeKey<T> key) {
            void var1_1;
            return this.ctx.channel().hasAttr((AttributeKey)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void remove() {
            void var1_1;
            EventExecutor executor = this.executor();
            if (executor.inEventLoop()) {
                this.remove0();
                return;
            }
            var1_1.execute(new Runnable(this){
                final /* synthetic */ DelegatingChannelHandlerContext this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void run() {
                    this.this$0.remove0();
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private void remove0() {
            if (!this.removed) {
                this.removed = true;
                try {
                    this.handler.handlerRemoved(this);
                    return;
                }
                catch (Throwable cause) {
                    void var1_1;
                    this.fireExceptionCaught(new ChannelPipelineException(this.handler.getClass().getName() + ".handlerRemoved() has thrown an exception.", (Throwable)var1_1));
                }
            }
        }
    }
}

