/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ChannelOutboundBuffer {
    static final int CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD = SystemPropertyUtil.getInt((String)"io.netty.transport.outboundBufferEntrySizeOverhead", (int)96);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final FastThreadLocal<ByteBuffer[]> NIO_BUFFERS = new FastThreadLocal<ByteBuffer[]>(){

        protected final ByteBuffer[] initialValue() throws Exception {
            return new ByteBuffer[1024];
        }
    };
    private final Channel channel;
    private Entry flushedEntry;
    private Entry unflushedEntry;
    private Entry tailEntry;
    private int flushed;
    private int nioBufferCount;
    private long nioBufferSize;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "unwritable");
    private volatile int unwritable;
    private volatile Runnable fireChannelWritabilityChangedTask;

    /*
     * WARNING - void declaration
     */
    ChannelOutboundBuffer(AbstractChannel channel) {
        void var1_1;
        this.channel = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void addMessage(Object msg, int size, ChannelPromise promise) {
        void var2_3;
        Entry entry;
        Entry entry2 = Entry.newInstance(msg, size, ChannelOutboundBuffer.total(msg), (ChannelPromise)((Object)entry));
        if (this.tailEntry == null) {
            this.flushedEntry = null;
        } else {
            entry = this.tailEntry;
            this.tailEntry.next = entry2;
        }
        this.tailEntry = entry2;
        if (this.unflushedEntry == null) {
            this.unflushedEntry = entry2;
        }
        if (msg instanceof AbstractReferenceCountedByteBuf) {
            ((AbstractReferenceCountedByteBuf)msg).touch();
        } else {
            void var1_1;
            ReferenceCountUtil.touch((Object)var1_1);
        }
        this.incrementPendingOutboundBytes(var2_3.pendingSize, false);
    }

    /*
     * WARNING - void declaration
     */
    public final void addFlush() {
        Entry entry = this.unflushedEntry;
        if (entry != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = entry;
            }
            do {
                void var2_2;
                ++this.flushed;
                if (entry.promise.setUncancellable()) continue;
                int pending = entry.cancel();
                this.decrementPendingOutboundBytes((long)var2_2, false, true);
            } while ((entry = entry.next) != null);
            this.unflushedEntry = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void incrementPendingOutboundBytes(long size) {
        void var1_1;
        this.incrementPendingOutboundBytes((long)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private void incrementPendingOutboundBytes(long size, boolean invokeLater) {
        void var1_1;
        if (size == 0L) {
            return;
        }
        long l = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, (long)var1_1);
        if (l > (long)this.channel.config().getWriteBufferHighWaterMark()) {
            void var3_2;
            this.setUnwritable((boolean)var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void decrementPendingOutboundBytes(long size) {
        void var1_1;
        this.decrementPendingOutboundBytes((long)var1_1, true, true);
    }

    /*
     * WARNING - void declaration
     */
    private void decrementPendingOutboundBytes(long size, boolean invokeLater, boolean notifyWritability) {
        void var1_1;
        if (size == 0L) {
            return;
        }
        long newWriteBufferSize = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, (long)(-var1_1));
        if (notifyWritability && newWriteBufferSize < (long)this.channel.config().getWriteBufferLowWaterMark()) {
            void var3_2;
            this.setWritable((boolean)var3_2);
        }
    }

    private static long total(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof FileRegion) {
            return ((FileRegion)msg).count();
        }
        if (msg instanceof ByteBufHolder) {
            Object object;
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public final Object current() {
        void var1_1;
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return null;
        }
        return var1_1.msg;
    }

    /*
     * WARNING - void declaration
     */
    public final long currentProgress() {
        void var1_1;
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return 0L;
        }
        return var1_1.progress;
    }

    /*
     * WARNING - void declaration
     */
    public final void progress(long amount) {
        void var1_2;
        long progress;
        Entry e = this.flushedEntry;
        assert (e != null);
        ChannelPromise p = e.promise;
        e.progress = progress = e.progress + amount;
        assert (p != null);
        Class<?> promiseClass = p.getClass();
        if (promiseClass == VoidChannelPromise.class || var1_2 == DefaultChannelPromise.class) {
            return;
        }
        if (p instanceof DefaultChannelProgressivePromise) {
            ((DefaultChannelProgressivePromise)p).tryProgress(progress, e.total);
            return;
        }
        if (p instanceof ChannelProgressivePromise) {
            void var3_3;
            ((ChannelProgressivePromise)p).tryProgress(progress, var3_3.total);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove() {
        void var1_1;
        Entry e = this.flushedEntry;
        if (e == null) {
            this.clearNioBuffers();
            return false;
        }
        Object msg = e.msg;
        ChannelPromise promise = e.promise;
        int size = e.pendingSize;
        this.removeEntry(e);
        if (!e.cancelled) {
            void var3_3;
            if (msg instanceof AbstractReferenceCountedByteBuf) {
                try {
                    ((AbstractReferenceCountedByteBuf)msg).release();
                }
                catch (Throwable t) {
                    logger.warn("Failed to release a ByteBuf: {}", msg, (Object)t);
                }
            } else {
                void var2_2;
                ReferenceCountUtil.safeRelease((Object)var2_2);
            }
            ChannelOutboundBuffer.safeSuccess((ChannelPromise)var3_3);
            this.decrementPendingOutboundBytes(size, false, true);
        }
        var1_1.unguardedRecycle();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(Throwable cause) {
        void var1_1;
        return this.remove0((Throwable)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private boolean remove0(Throwable cause, boolean notifyWritability) {
        void var3_3;
        Entry e = this.flushedEntry;
        if (e == null) {
            this.clearNioBuffers();
            return false;
        }
        Object msg = e.msg;
        ChannelPromise promise = e.promise;
        int size = e.pendingSize;
        this.removeEntry(e);
        if (!e.cancelled) {
            void var2_2;
            void var1_1;
            ReferenceCountUtil.safeRelease((Object)msg);
            ChannelOutboundBuffer.safeFail(promise, (Throwable)var1_1);
            this.decrementPendingOutboundBytes(size, false, (boolean)var2_2);
        }
        var3_3.unguardedRecycle();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void removeEntry(Entry e) {
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (e == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
                return;
            }
        } else {
            void var1_1;
            this.flushedEntry = var1_1.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBytes(long writtenBytes) {
        block5: {
            int readerIndex;
            while (true) {
                Object msg;
                if (!((msg = this.current()) instanceof ByteBuf)) {
                    assert (writtenBytes == 0L);
                    break block5;
                }
                ByteBuf buf = (ByteBuf)msg;
                readerIndex = buf.readerIndex();
                int readableBytes = buf.writerIndex() - readerIndex;
                if ((long)readableBytes > writtenBytes) break;
                if (writtenBytes != 0L) {
                    this.progress(readableBytes);
                    writtenBytes -= (long)readableBytes;
                }
                this.remove();
            }
            if (writtenBytes != 0L) {
                void var1_1;
                void var3_2;
                var3_2.readerIndex(readerIndex + (int)writtenBytes);
                this.progress((long)var1_1);
            }
        }
        this.clearNioBuffers();
    }

    /*
     * WARNING - void declaration
     */
    private void clearNioBuffers() {
        int count = this.nioBufferCount;
        if (count > 0) {
            void var1_1;
            this.nioBufferCount = 0;
            Arrays.fill((Object[])NIO_BUFFERS.get(), 0, (int)var1_1, null);
        }
    }

    public final ByteBuffer[] nioBuffers() {
        return this.nioBuffers(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public final ByteBuffer[] nioBuffers(int maxCount, long maxBytes) {
        assert (maxCount > 0);
        assert (maxBytes > 0L);
        long nioBufferSize = 0L;
        int nioBufferCount = 0;
        InternalThreadLocalMap threadLocalMap = InternalThreadLocalMap.get();
        ByteBuffer[] nioBuffers = (ByteBuffer[])NIO_BUFFERS.get(threadLocalMap);
        Entry entry = this.flushedEntry;
        while (this.isFlushedEntry(entry) && entry.msg instanceof ByteBuf) {
            if (!entry.cancelled) {
                ByteBuf buf = (ByteBuf)entry.msg;
                int readerIndex = buf.readerIndex();
                int readableBytes = buf.writerIndex() - readerIndex;
                if (readableBytes > 0) {
                    int neededSpace;
                    if (maxBytes - (long)readableBytes < nioBufferSize && nioBufferCount != 0) break;
                    nioBufferSize += (long)readableBytes;
                    int count = entry.count;
                    if (count == -1) {
                        entry.count = count = buf.nioBufferCount();
                    }
                    if ((neededSpace = Math.min(maxCount, nioBufferCount + count)) > nioBuffers.length) {
                        nioBuffers = ChannelOutboundBuffer.expandNioBufferArray(nioBuffers, neededSpace, nioBufferCount);
                        NIO_BUFFERS.set(threadLocalMap, (Object)nioBuffers);
                    }
                    if (count == 1) {
                        ByteBuffer nioBuf = entry.buf;
                        if (nioBuf == null) {
                            entry.buf = nioBuf = buf.internalNioBuffer(readerIndex, readableBytes);
                        }
                        nioBuffers[nioBufferCount++] = nioBuf;
                    } else {
                        nioBufferCount = ChannelOutboundBuffer.nioBuffers(entry, buf, nioBuffers, nioBufferCount, maxCount);
                    }
                    if (nioBufferCount >= maxCount) break;
                }
            }
            entry = entry.next;
        }
        this.nioBufferCount = nioBufferCount;
        this.nioBufferSize = nioBufferSize;
        return nioBuffers;
    }

    /*
     * WARNING - void declaration
     */
    private static int nioBuffers(Entry entry, ByteBuf buf, ByteBuffer[] nioBuffers, int nioBufferCount, int maxCount) {
        void var3_4;
        ByteBuffer nioBuf;
        ByteBuffer[] nioBufs = entry.bufs;
        if (entry.bufs == null) {
            entry.bufs = nioBufs = buf.nioBuffers();
        }
        for (int i = 0; i < nioBufs.length && nioBufferCount < maxCount && (nioBuf = nioBufs[i]) != null; ++i) {
            void var1_2;
            if (!nioBuf.hasRemaining()) continue;
            nioBuffers[nioBufferCount++] = var1_2;
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] array, int neededSpace, int size) {
        void var1_2;
        void var2_3;
        ByteBuffer[] byteBufferArray;
        void var3_4;
        int newCapacity = array.length;
        do {
            if ((newCapacity <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (neededSpace > newCapacity);
        ByteBuffer[] newArray = new ByteBuffer[var3_4];
        System.arraycopy(byteBufferArray, 0, newArray, 0, (int)var2_3);
        return var1_2;
    }

    public final int nioBufferCount() {
        return this.nioBufferCount;
    }

    public final long nioBufferSize() {
        return this.nioBufferSize;
    }

    public final boolean isWritable() {
        return this.unwritable == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getUserDefinedWritability(int index) {
        void var1_1;
        return (this.unwritable & ChannelOutboundBuffer.writabilityMask((int)var1_1)) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUserDefinedWritability(int index, boolean writable) {
        void var1_1;
        if (writable) {
            this.setUserDefinedWritability(index);
            return;
        }
        this.clearUserDefinedWritability((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setUserDefinedWritability(int index) {
        void var3_3;
        void var2_2;
        int newValue;
        int oldValue;
        int mask = ~ChannelOutboundBuffer.writabilityMask(index);
        while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue & mask)) {
        }
        if (var2_2 != false && var3_3 == false) {
            this.fireChannelWritabilityChanged(true);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void clearUserDefinedWritability(int index) {
        void var3_3;
        void var2_2;
        int newValue;
        int oldValue;
        int mask = ChannelOutboundBuffer.writabilityMask(index);
        while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue | mask)) {
        }
        if (var2_2 == false && var3_3 != false) {
            this.fireChannelWritabilityChanged(true);
            return;
        }
    }

    private static int writabilityMask(int index) {
        int n;
        if (index <= 0 || index > 31) {
            throw new IllegalArgumentException("index: " + index + " (expected: 1~31)");
        }
        return 1 << n;
    }

    /*
     * WARNING - void declaration
     */
    private void setWritable(boolean invokeLater) {
        void var3_3;
        void var2_2;
        int newValue;
        int oldValue;
        while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue & 0xFFFFFFFE)) {
        }
        if (var2_2 != false && var3_3 == false) {
            this.fireChannelWritabilityChanged(invokeLater);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setUnwritable(boolean invokeLater) {
        void var2_2;
        void var3_3;
        int oldValue;
        do {
            oldValue = this.unwritable;
            int newValue = oldValue | 1;
        } while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue, (int)var3_3));
        if (var2_2 == false) {
            this.fireChannelWritabilityChanged(invokeLater);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fireChannelWritabilityChanged(boolean invokeLater) {
        void var2_3;
        ChannelPipeline pipeline = this.channel.pipeline();
        if (invokeLater) {
            void var1_2;
            Runnable task = this.fireChannelWritabilityChangedTask;
            if (task == null) {
                this.fireChannelWritabilityChangedTask = task = new Runnable(this, pipeline){
                    final /* synthetic */ ChannelPipeline val$pipeline;
                    final /* synthetic */ ChannelOutboundBuffer this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$pipeline = channelPipeline;
                    }

                    @Override
                    public void run() {
                        this.val$pipeline.fireChannelWritabilityChanged();
                    }
                };
            }
            this.channel.eventLoop().execute((Runnable)var1_2);
            return;
        }
        var2_3.fireChannelWritabilityChanged();
    }

    public final int size() {
        return this.flushed;
    }

    public final boolean isEmpty() {
        return this.flushed == 0;
    }

    final void failFlushed(Throwable cause, boolean notify) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove0(cause, notify)) {
            }
            return;
        }
        finally {
            this.inFail = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void close(Throwable cause, boolean allowChannelOpen) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new Runnable(this, cause, allowChannelOpen){
                final /* synthetic */ Throwable val$cause;
                final /* synthetic */ boolean val$allowChannelOpen;
                final /* synthetic */ ChannelOutboundBuffer this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$cause = throwable;
                    this.val$allowChannelOpen = bl;
                }

                @Override
                public void run() {
                    this.this$0.close(this.val$cause, this.val$allowChannelOpen);
                }
            });
            return;
        }
        this.inFail = true;
        if (!allowChannelOpen && this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (Entry e = this.unflushedEntry; e != null; e = e.unguardedRecycleAndGetNext()) {
                void var3_5;
                int size = e.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, (long)(-var3_5));
                if (e.cancelled) continue;
                ReferenceCountUtil.safeRelease((Object)e.msg);
                ChannelOutboundBuffer.safeFail(e.promise, cause);
            }
        }
        finally {
            this.inFail = false;
        }
        this.clearNioBuffers();
    }

    /*
     * WARNING - void declaration
     */
    final void close(ClosedChannelException cause) {
        void var1_1;
        this.close((Throwable)var1_1, false);
    }

    private static void safeSuccess(ChannelPromise promise) {
        ChannelPromise channelPromise;
        PromiseNotificationUtil.trySuccess((Promise)promise, null, (InternalLogger)(channelPromise instanceof VoidChannelPromise ? null : logger));
    }

    /*
     * WARNING - void declaration
     */
    private static void safeFail(ChannelPromise promise, Throwable cause) {
        ChannelPromise channelPromise;
        void var1_1;
        PromiseNotificationUtil.tryFailure((Promise)promise, (Throwable)var1_1, (InternalLogger)(channelPromise instanceof VoidChannelPromise ? null : logger));
    }

    @Deprecated
    public final void recycle() {
    }

    public final long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    /*
     * WARNING - void declaration
     */
    public final long bytesBeforeUnwritable() {
        long bytes = (long)this.channel.config().getWriteBufferHighWaterMark() - this.totalPendingSize + 1L;
        if (bytes > 0L && this.isWritable()) {
            void var1_1;
            return (long)var1_1;
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public final long bytesBeforeWritable() {
        void var1_1;
        long bytes = this.totalPendingSize - (long)this.channel.config().getWriteBufferLowWaterMark() + 1L;
        if (bytes <= 0L || this.isWritable()) {
            return 0L;
        }
        return (long)var1_1;
    }

    public final void forEachFlushedMessage(MessageProcessor processor) throws Exception {
        ObjectUtil.checkNotNull((Object)processor, (String)"processor");
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return;
        }
        do {
            if (entry.cancelled || processor.processMessage(entry.msg)) continue;
            return;
        } while (this.isFlushedEntry(entry = entry.next));
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFlushedEntry(Entry e) {
        void var1_1;
        return e != null && var1_1 != this.unflushedEntry;
    }

    static final class Entry {
        private static final ObjectPool<Entry> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<Entry>(){

            /*
             * WARNING - void declaration
             */
            public final Entry newObject(ObjectPool.Handle<Entry> handle) {
                void var1_1;
                return new Entry((ObjectPool.Handle)var1_1);
            }
        });
        private final Recycler.EnhancedHandle<Entry> handle;
        Entry next;
        Object msg;
        ByteBuffer[] bufs;
        ByteBuffer buf;
        ChannelPromise promise;
        long progress;
        long total;
        int pendingSize;
        int count = -1;
        boolean cancelled;

        /*
         * WARNING - void declaration
         */
        private Entry(ObjectPool.Handle<Entry> handle) {
            void var1_1;
            this.handle = (Recycler.EnhancedHandle)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static Entry newInstance(Object msg, int size, long total, ChannelPromise promise) {
            void var2_2;
            void var1_1;
            Object object;
            Entry entry = (Entry)RECYCLER.get();
            ((Entry)RECYCLER.get()).msg = object;
            entry.pendingSize = var1_1 + CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD;
            entry.total = var2_2;
            entry.promise = promise;
            return entry;
        }

        /*
         * WARNING - void declaration
         */
        final int cancel() {
            if (!this.cancelled) {
                void var1_1;
                this.cancelled = true;
                int pSize = this.pendingSize;
                ReferenceCountUtil.safeRelease((Object)this.msg);
                this.msg = Unpooled.EMPTY_BUFFER;
                this.pendingSize = 0;
                this.total = 0L;
                this.progress = 0L;
                this.bufs = null;
                this.buf = null;
                return (int)var1_1;
            }
            return 0;
        }

        final void unguardedRecycle() {
            this.next = null;
            this.bufs = null;
            this.buf = null;
            this.msg = null;
            this.promise = null;
            this.progress = 0L;
            this.total = 0L;
            this.pendingSize = 0;
            this.count = -1;
            this.cancelled = false;
            this.handle.unguardedRecycle((Object)this);
        }

        /*
         * WARNING - void declaration
         */
        final Entry unguardedRecycleAndGetNext() {
            void var1_1;
            Entry next = this.next;
            this.unguardedRecycle();
            return var1_1;
        }
    }

    public static interface MessageProcessor {
        public boolean processMessage(Object var1) throws Exception;
    }
}

