/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ChannelHandler.Sharable
public abstract class ChannelInitializer<C extends Channel>
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);
    private final Set<ChannelHandlerContext> initMap = Collections.newSetFromMap(new ConcurrentHashMap());

    protected abstract void initChannel(C var1) throws Exception;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.initChannel(ctx)) {
            ctx.pipeline().fireChannelRegistered();
            this.removeState(ctx);
            return;
        }
        var1_1.fireChannelRegistered();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var1_1;
        if (logger.isWarnEnabled()) {
            void var2_2;
            logger.warn("Failed to initialize a channel. Closing: " + ctx.channel(), (Throwable)var2_2);
        }
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isRegistered() && this.initChannel(ctx)) {
            void var1_1;
            this.removeState((ChannelHandlerContext)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.initMap.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean initChannel(ChannelHandlerContext ctx) throws Exception {
        block6: {
            block5: {
                if (!this.initMap.add(ctx)) break block6;
                try {
                    this.initChannel(ctx.channel());
                    if (ctx.isRemoved()) break block5;
                    ctx.pipeline().remove(this);
                }
                catch (Throwable cause) {
                    try {
                        void var2_2;
                        ((ChannelHandlerAdapter)this).exceptionCaught(ctx, (Throwable)var2_2);
                        if (ctx.isRemoved()) break block5;
                        ctx.pipeline().remove(this);
                    }
                    catch (Throwable throwable) {
                        if (!ctx.isRemoved()) {
                            void var1_1;
                            var1_1.pipeline().remove(this);
                        }
                        throw throwable;
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void removeState(ChannelHandlerContext ctx) {
        void var1_1;
        if (ctx.isRemoved()) {
            this.initMap.remove(ctx);
            return;
        }
        ctx.executor().execute(new Runnable(this, (ChannelHandlerContext)var1_1){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ ChannelInitializer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$ctx = channelHandlerContext;
            }

            @Override
            public void run() {
                this.this$0.initMap.remove(this.val$ctx);
            }
        });
    }
}

