/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelPromise;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;

public final class ChannelFlushPromiseNotifier {
    private long writeCounter;
    private final Queue<FlushCheckpoint> flushCheckpoints = new ArrayDeque<FlushCheckpoint>();
    private final boolean tryNotify;

    /*
     * WARNING - void declaration
     */
    public ChannelFlushPromiseNotifier(boolean tryNotify) {
        void var1_1;
        this.tryNotify = var1_1;
    }

    public ChannelFlushPromiseNotifier() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final ChannelFlushPromiseNotifier add(ChannelPromise promise, int pendingDataSize) {
        void var2_2;
        void var1_1;
        return this.add((ChannelPromise)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFlushPromiseNotifier add(ChannelPromise promise, long pendingDataSize) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)promise, (String)"promise");
        ObjectUtil.checkPositiveOrZero((long)pendingDataSize, (String)"pendingDataSize");
        long checkpoint = this.writeCounter + var2_2;
        if (promise instanceof FlushCheckpoint) {
            FlushCheckpoint cp = (FlushCheckpoint)((Object)promise);
            cp.flushCheckpoint(checkpoint);
            this.flushCheckpoints.add((FlushCheckpoint)var1_1);
        } else {
            this.flushCheckpoints.add(new DefaultFlushCheckpoint(checkpoint, (ChannelPromise)var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFlushPromiseNotifier increaseWriteCounter(long delta) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((long)delta, (String)"delta");
        this.writeCounter += var1_1;
        return this;
    }

    public final long writeCounter() {
        return this.writeCounter;
    }

    public final ChannelFlushPromiseNotifier notifyPromises() {
        this.notifyPromises0(null);
        return this;
    }

    @Deprecated
    public final ChannelFlushPromiseNotifier notifyFlushFutures() {
        return this.notifyPromises();
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFlushPromiseNotifier notifyPromises(Throwable cause) {
        FlushCheckpoint cp;
        this.notifyPromises();
        while ((cp = this.flushCheckpoints.poll()) != null) {
            void var2_2;
            if (this.tryNotify) {
                cp.promise().tryFailure(cause);
                continue;
            }
            var2_2.promise().setFailure(cause);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final ChannelFlushPromiseNotifier notifyFlushFutures(Throwable cause) {
        void var1_1;
        return this.notifyPromises((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFlushPromiseNotifier notifyPromises(Throwable cause1, Throwable cause2) {
        FlushCheckpoint cp;
        this.notifyPromises0(cause1);
        while ((cp = this.flushCheckpoints.poll()) != null) {
            void var1_1;
            if (this.tryNotify) {
                cp.promise().tryFailure(cause2);
                continue;
            }
            var1_1.promise().setFailure(cause2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final ChannelFlushPromiseNotifier notifyFlushFutures(Throwable cause1, Throwable cause2) {
        void var2_2;
        void var1_1;
        return this.notifyPromises((Throwable)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void notifyPromises0(Throwable cause) {
        if (this.flushCheckpoints.isEmpty()) {
            this.writeCounter = 0L;
            return;
        }
        long writeCounter = this.writeCounter;
        while (true) {
            FlushCheckpoint cp;
            if ((cp = this.flushCheckpoints.peek()) == null) {
                this.writeCounter = 0L;
                break;
            }
            if (cp.flushCheckpoint() > writeCounter) {
                if (writeCounter <= 0L || this.flushCheckpoints.size() != 1) break;
                this.writeCounter = 0L;
                FlushCheckpoint flushCheckpoint = cp;
                flushCheckpoint.flushCheckpoint(flushCheckpoint.flushCheckpoint() - writeCounter);
                break;
            }
            this.flushCheckpoints.remove();
            ChannelPromise promise = cp.promise();
            if (cause == null) {
                if (this.tryNotify) {
                    promise.trySuccess();
                    continue;
                }
                promise.setSuccess();
                continue;
            }
            if (this.tryNotify) {
                promise.tryFailure(cause);
                continue;
            }
            promise.setFailure(cause);
        }
        long newWriteCounter = this.writeCounter;
        if (newWriteCounter >= 0x8000000000L) {
            this.writeCounter = 0L;
            for (FlushCheckpoint cp : this.flushCheckpoints) {
                void var2_3;
                cp.flushCheckpoint(var2_3.flushCheckpoint() - newWriteCounter);
            }
        }
    }

    private static class DefaultFlushCheckpoint
    implements FlushCheckpoint {
        private long checkpoint;
        private final ChannelPromise future;

        /*
         * WARNING - void declaration
         */
        DefaultFlushCheckpoint(long checkpoint, ChannelPromise future) {
            void var3_2;
            void var1_1;
            this.checkpoint = var1_1;
            this.future = var3_2;
        }

        @Override
        public long flushCheckpoint() {
            return this.checkpoint;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void flushCheckpoint(long checkpoint) {
            void var1_1;
            this.checkpoint = var1_1;
        }

        @Override
        public ChannelPromise promise() {
            return this.future;
        }
    }

    static interface FlushCheckpoint {
        public long flushCheckpoint();

        public void flushCheckpoint(long var1);

        public ChannelPromise promise();
    }
}

