/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.DefaultMaxMessagesRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;

public class AdaptiveRecvByteBufAllocator
extends DefaultMaxMessagesRecvByteBufAllocator {
    static final int DEFAULT_MINIMUM = 64;
    static final int DEFAULT_INITIAL = 2048;
    static final int DEFAULT_MAXIMUM = 65536;
    private static final int INDEX_INCREMENT = 4;
    private static final int INDEX_DECREMENT = 1;
    private static final int[] SIZE_TABLE;
    @Deprecated
    public static final AdaptiveRecvByteBufAllocator DEFAULT;
    private final int minIndex;
    private final int maxIndex;
    private final int initialIndex;
    private final int minCapacity;
    private final int maxCapacity;

    /*
     * WARNING - void declaration
     */
    private static int getSizeTableIndex(int size) {
        void var3_3;
        int n;
        int a;
        int mid;
        int low = 0;
        int high = SIZE_TABLE.length - 1;
        while (true) {
            if (high < low) {
                return low;
            }
            if (high == low) {
                return high;
            }
            mid = low + high >>> 1;
            a = SIZE_TABLE[mid];
            int b = SIZE_TABLE[mid + 1];
            if (size > b) {
                low = mid + 1;
                continue;
            }
            if (size >= a) break;
            high = mid - 1;
        }
        if (n == a) {
            return mid;
        }
        return (int)(var3_3 + true);
    }

    public AdaptiveRecvByteBufAllocator() {
        this(64, 2048, 65536);
    }

    /*
     * WARNING - void declaration
     */
    public AdaptiveRecvByteBufAllocator(int minimum, int initial, int maximum) {
        void var3_3;
        void var1_1;
        void var2_2;
        ObjectUtil.checkPositive((int)minimum, (String)"minimum");
        if (initial < minimum) {
            throw new IllegalArgumentException("initial: " + initial);
        }
        if (maximum < initial) {
            throw new IllegalArgumentException("maximum: " + maximum);
        }
        int minIndex = AdaptiveRecvByteBufAllocator.getSizeTableIndex(minimum);
        this.minIndex = SIZE_TABLE[minIndex] < minimum ? minIndex + 1 : minIndex;
        int maxIndex = AdaptiveRecvByteBufAllocator.getSizeTableIndex(maximum);
        this.maxIndex = SIZE_TABLE[maxIndex] > maximum ? maxIndex - 1 : maxIndex;
        int initialIndex = AdaptiveRecvByteBufAllocator.getSizeTableIndex(initial);
        this.initialIndex = SIZE_TABLE[initialIndex] > var2_2 ? initialIndex - 1 : initialIndex;
        this.minCapacity = var1_1;
        this.maxCapacity = var3_3;
    }

    @Override
    public RecvByteBufAllocator.Handle newHandle() {
        AdaptiveRecvByteBufAllocator adaptiveRecvByteBufAllocator = this;
        return adaptiveRecvByteBufAllocator.new HandleImpl(adaptiveRecvByteBufAllocator.minIndex, this.maxIndex, this.initialIndex, this.minCapacity, this.maxCapacity);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AdaptiveRecvByteBufAllocator respectMaybeMoreData(boolean respectMaybeMoreData) {
        void var1_1;
        super.respectMaybeMoreData((boolean)var1_1);
        return this;
    }

    static {
        int i;
        ArrayList<Integer> sizeTable = new ArrayList<Integer>();
        for (i = 16; i < 512; i += 16) {
            sizeTable.add(i);
        }
        for (i = 512; i > 0; i <<= 1) {
            sizeTable.add(i);
        }
        SIZE_TABLE = new int[sizeTable.size()];
        for (i = 0; i < SIZE_TABLE.length; ++i) {
            AdaptiveRecvByteBufAllocator.SIZE_TABLE[i] = (Integer)sizeTable.get(i);
        }
        DEFAULT = new AdaptiveRecvByteBufAllocator();
    }

    private final class HandleImpl
    extends DefaultMaxMessagesRecvByteBufAllocator.MaxMessageHandle {
        private final int minIndex;
        private final int maxIndex;
        private final int minCapacity;
        private final int maxCapacity;
        private int index;
        private int nextReceiveBufferSize;
        private boolean decreaseNow;

        /*
         * WARNING - void declaration
         */
        HandleImpl(int minIndex, int maxIndex, int initialIndex, int minCapacity, int maxCapacity) {
            void var3_3;
            void var2_2;
            super(AdaptiveRecvByteBufAllocator.this);
            this.minIndex = var2_2;
            this.maxIndex = var3_3;
            this.index = initialIndex;
            this.nextReceiveBufferSize = Math.max(SIZE_TABLE[this.index], minCapacity);
            this.minCapacity = minCapacity;
            this.maxCapacity = maxCapacity;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void lastBytesRead(int bytes) {
            void var1_1;
            if (bytes == this.attemptedBytesRead()) {
                this.record(bytes);
            }
            super.lastBytesRead((int)var1_1);
        }

        @Override
        public final int guess() {
            return this.nextReceiveBufferSize;
        }

        /*
         * WARNING - void declaration
         */
        private void record(int actualReadBytes) {
            void var1_1;
            if (actualReadBytes <= SIZE_TABLE[Math.max(0, this.index - 1)]) {
                if (this.decreaseNow) {
                    this.index = Math.max(this.index - 1, this.minIndex);
                    this.nextReceiveBufferSize = Math.max(SIZE_TABLE[this.index], this.minCapacity);
                    this.decreaseNow = false;
                    return;
                }
                this.decreaseNow = true;
                return;
            }
            if (var1_1 >= this.nextReceiveBufferSize) {
                this.index = Math.min(this.index + 4, this.maxIndex);
                this.nextReceiveBufferSize = Math.min(SIZE_TABLE[this.index], this.maxCapacity);
                this.decreaseNow = false;
            }
        }

        @Override
        public final void readComplete() {
            HandleImpl handleImpl = this;
            handleImpl.record(handleImpl.totalBytesRead());
        }
    }
}

