/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DelegatingChannelPromiseNotifier;
import io.netty.channel.PendingBytesTracker;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;

public abstract class AbstractCoalescingBufferQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractCoalescingBufferQueue.class);
    private final ArrayDeque<Object> bufAndListenerPairs;
    private final PendingBytesTracker tracker;
    private int readableBytes;

    /*
     * WARNING - void declaration
     */
    protected AbstractCoalescingBufferQueue(Channel channel, int initSize) {
        void var1_1;
        void var2_2;
        this.bufAndListenerPairs = new ArrayDeque((int)var2_2);
        this.tracker = channel == null ? null : PendingBytesTracker.newTracker((Channel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addFirst(ByteBuf buf, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        this.addFirst((ByteBuf)var1_1, AbstractCoalescingBufferQueue.toChannelFutureListener((ChannelPromise)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private void addFirst(ByteBuf buf, ChannelFutureListener listener) {
        void var1_1;
        buf.touch();
        if (listener != null) {
            void var2_2;
            this.bufAndListenerPairs.addFirst(var2_2);
        }
        this.bufAndListenerPairs.addFirst(buf);
        this.incrementReadableBytes(var1_1.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    public final void add(ByteBuf buf) {
        void var1_1;
        this.add((ByteBuf)var1_1, (ChannelFutureListener)null);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(ByteBuf buf, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        this.add((ByteBuf)var1_1, AbstractCoalescingBufferQueue.toChannelFutureListener((ChannelPromise)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void add(ByteBuf buf, ChannelFutureListener listener) {
        void var1_1;
        buf.touch();
        this.bufAndListenerPairs.add(buf);
        if (listener != null) {
            void var2_2;
            this.bufAndListenerPairs.add(var2_2);
        }
        this.incrementReadableBytes(var1_1.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf removeFirst(ChannelPromise aggregatePromise) {
        void var3_3;
        Object entry = this.bufAndListenerPairs.poll();
        if (entry == null) {
            return null;
        }
        assert (entry instanceof ByteBuf);
        ByteBuf result = (ByteBuf)entry;
        this.decrementReadableBytes(result.readableBytes());
        entry = this.bufAndListenerPairs.peek();
        if (entry instanceof ChannelFutureListener) {
            void var2_2;
            void var1_1;
            var1_1.addListener((ChannelFutureListener)var2_2);
            this.bufAndListenerPairs.poll();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf remove(ByteBufAllocator alloc, int bytes, ChannelPromise aggregatePromise) {
        void var2_2;
        ObjectUtil.checkPositiveOrZero((int)bytes, (String)"bytes");
        ObjectUtil.checkNotNull((Object)aggregatePromise, (String)"aggregatePromise");
        if (this.bufAndListenerPairs.isEmpty()) {
            assert (this.readableBytes == 0);
            return this.removeEmptyValue();
        }
        bytes = Math.min(bytes, this.readableBytes);
        ByteBuf toReturn = null;
        ByteBuf entryBuffer = null;
        int originalBytes = bytes;
        try {
            Object entry;
            while ((entry = this.bufAndListenerPairs.poll()) != null) {
                if (entry instanceof ByteBuf) {
                    entryBuffer = (ByteBuf)entry;
                    int bufferBytes = entryBuffer.readableBytes();
                    if (bufferBytes > bytes) {
                        this.bufAndListenerPairs.addFirst(entryBuffer);
                        if (bytes > 0) {
                            entryBuffer = entryBuffer.readRetainedSlice(bytes);
                            toReturn = toReturn == null ? entryBuffer : this.compose(alloc, toReturn, entryBuffer);
                            bytes = 0;
                        }
                        break;
                    }
                    toReturn = toReturn == null ? (bytes == 0 ? entryBuffer : this.composeFirst(alloc, entryBuffer, bufferBytes + (bytes -= bufferBytes))) : this.compose(alloc, toReturn, entryBuffer);
                    entryBuffer = null;
                    continue;
                }
                if (entry instanceof DelegatingChannelPromiseNotifier) {
                    aggregatePromise.addListener((DelegatingChannelPromiseNotifier)entry);
                    continue;
                }
                if (!(entry instanceof ChannelFutureListener)) continue;
                aggregatePromise.addListener((ChannelFutureListener)entry);
            }
        }
        catch (Throwable cause) {
            void var3_3;
            this.decrementReadableBytes(originalBytes - bytes);
            Object entry = this.bufAndListenerPairs.peek();
            if (entry instanceof ChannelFutureListener) {
                aggregatePromise.addListener((ChannelFutureListener)entry);
                this.bufAndListenerPairs.poll();
            }
            ReferenceCountUtil.safeRelease((Object)entryBuffer);
            ReferenceCountUtil.safeRelease(toReturn);
            var3_3.setFailure(cause);
            PlatformDependent.throwException((Throwable)cause);
        }
        this.decrementReadableBytes(originalBytes - var2_2);
        return toReturn;
    }

    public final int readableBytes() {
        return this.readableBytes;
    }

    public final boolean isEmpty() {
        return this.bufAndListenerPairs.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void releaseAndFailAll(ChannelOutboundInvoker invoker, Throwable cause) {
        void var2_2;
        void var1_1;
        this.releaseAndCompleteAll(var1_1.newFailedFuture((Throwable)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void copyTo(AbstractCoalescingBufferQueue dest) {
        void var1_1;
        dest.bufAndListenerPairs.addAll(this.bufAndListenerPairs);
        super.incrementReadableBytes(this.readableBytes);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeAndRemoveAll(ChannelHandlerContext ctx) {
        Throwable pending = null;
        ByteBuf previousBuf = null;
        while (true) {
            Object entry = this.bufAndListenerPairs.poll();
            try {
                if (entry == null) {
                    if (previousBuf == null) break;
                    this.decrementReadableBytes(previousBuf.readableBytes());
                    ctx.write(previousBuf, ctx.voidPromise());
                    break;
                }
                if (entry instanceof ByteBuf) {
                    if (previousBuf != null) {
                        this.decrementReadableBytes(previousBuf.readableBytes());
                        ctx.write(previousBuf, ctx.voidPromise());
                    }
                    previousBuf = (ByteBuf)entry;
                    continue;
                }
                if (entry instanceof ChannelPromise) {
                    this.decrementReadableBytes(previousBuf.readableBytes());
                    ctx.write(previousBuf, (ChannelPromise)entry);
                    previousBuf = null;
                    continue;
                }
                this.decrementReadableBytes(previousBuf.readableBytes());
                ctx.write(previousBuf).addListener((ChannelFutureListener)entry);
                previousBuf = null;
            }
            catch (Throwable t) {
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t);
            }
        }
        if (pending != null) {
            void var2_2;
            throw new IllegalStateException((Throwable)var2_2);
        }
    }

    public String toString() {
        return "bytes: " + this.readableBytes + " buffers: " + (this.size() >> 1);
    }

    protected abstract ByteBuf compose(ByteBufAllocator var1, ByteBuf var2, ByteBuf var3);

    /*
     * WARNING - void declaration
     */
    protected final ByteBuf composeIntoComposite(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        void var1_1;
        CompositeByteBuf composite = alloc.compositeBuffer(this.size() + 2);
        try {
            composite.addComponent(true, cumulation);
            composite.addComponent(true, next);
        }
        catch (Throwable cause) {
            void var2_3;
            void var3_4;
            composite.release();
            ReferenceCountUtil.safeRelease((Object)var3_4);
            PlatformDependent.throwException((Throwable)var2_3);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final ByteBuf copyAndCompose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        void var1_1;
        void var3_3;
        void var2_2;
        ByteBuf newCumulation = alloc.ioBuffer(cumulation.readableBytes() + next.readableBytes());
        try {
            newCumulation.writeBytes(cumulation).writeBytes(next);
        }
        catch (Throwable cause) {
            newCumulation.release();
            ReferenceCountUtil.safeRelease((Object)next);
            PlatformDependent.throwException((Throwable)cause);
        }
        var2_2.release();
        var3_3.release();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first, int bufferSize) {
        void var2_2;
        void var1_1;
        return this.composeFirst((ByteBufAllocator)var1_1, (ByteBuf)var2_2);
    }

    @Deprecated
    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first) {
        return first;
    }

    protected abstract ByteBuf removeEmptyValue();

    protected final int size() {
        return this.bufAndListenerPairs.size();
    }

    /*
     * WARNING - void declaration
     */
    private void releaseAndCompleteAll(ChannelFuture future) {
        Object entry;
        Throwable pending = null;
        while ((entry = this.bufAndListenerPairs.poll()) != null) {
            try {
                ByteBuf buffer;
                if (entry instanceof ByteBuf) {
                    buffer = (ByteBuf)entry;
                    this.decrementReadableBytes(buffer.readableBytes());
                    ReferenceCountUtil.safeRelease((Object)buffer);
                    continue;
                }
                ((ChannelFutureListener)buffer).operationComplete(future);
            }
            catch (Throwable t) {
                void var3_4;
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)var3_4);
            }
        }
        if (pending != null) {
            void var2_2;
            throw new IllegalStateException((Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void incrementReadableBytes(int increment) {
        void var2_2;
        int nextReadableBytes = this.readableBytes + increment;
        if (nextReadableBytes < this.readableBytes) {
            throw new IllegalStateException("buffer queue length overflow: " + this.readableBytes + " + " + increment);
        }
        this.readableBytes = var2_2;
        if (this.tracker != null) {
            void var1_1;
            this.tracker.incrementPendingOutboundBytes((long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void decrementReadableBytes(int decrement) {
        this.readableBytes -= decrement;
        assert (this.readableBytes >= 0);
        if (this.tracker != null) {
            void var1_1;
            this.tracker.decrementPendingOutboundBytes((long)var1_1);
        }
    }

    private static ChannelFutureListener toChannelFutureListener(ChannelPromise promise) {
        ChannelPromise channelPromise;
        if (promise.isVoid()) {
            return null;
        }
        return new DelegatingChannelPromiseNotifier(channelPromise);
    }
}

