/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerMask;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.SucceededChannelFuture;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakHint;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannelHandlerContext.class);
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private static final AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> HANDLER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, "handlerState");
    private static final int ADD_PENDING = 1;
    private static final int ADD_COMPLETE = 2;
    private static final int REMOVE_COMPLETE = 3;
    private static final int INIT = 0;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final boolean ordered;
    private final int executionMask;
    final EventExecutor executor;
    private ChannelFuture succeededFuture;
    private Tasks invokeTasks;
    private volatile int handlerState = 0;

    /*
     * WARNING - void declaration
     */
    AbstractChannelHandlerContext(DefaultChannelPipeline pipeline, EventExecutor executor, String name, Class<? extends ChannelHandler> handlerClass) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.name = (String)ObjectUtil.checkNotNull((Object)var3_3, (String)"name");
        this.pipeline = var1_1;
        this.executor = executor;
        this.executionMask = ChannelHandlerMask.mask(handlerClass);
        this.ordered = executor == null || var2_2 instanceof OrderedEventExecutor;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            return this.channel().eventLoop();
        }
        return this.executor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.findContextInbound(2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void invokeChannelRegistered(AbstractChannelHandlerContext next) {
        AbstractChannelHandlerContext abstractChannelHandlerContext;
        void var1_1;
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelRegistered();
            return;
        }
        var1_1.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeChannelRegistered();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void invokeChannelRegistered() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var2_3;
                    var2_3.channelRegistered(this);
                }
                if (handler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)handler).channelRegistered(this);
                }
                ((ChannelInboundHandler)handler).channelRegistered(this);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                this.invokeExceptionCaught((Throwable)var1_2);
                return;
            }
        } else {
            this.fireChannelRegistered();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.findContextInbound(4));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void invokeChannelUnregistered(AbstractChannelHandlerContext next) {
        AbstractChannelHandlerContext abstractChannelHandlerContext;
        void var1_1;
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelUnregistered();
            return;
        }
        var1_1.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeChannelUnregistered();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void invokeChannelUnregistered() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var2_3;
                    var2_3.channelUnregistered(this);
                }
                if (handler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)handler).channelUnregistered(this);
                }
                ((ChannelInboundHandler)handler).channelUnregistered(this);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                this.invokeExceptionCaught((Throwable)var1_2);
                return;
            }
        } else {
            this.fireChannelUnregistered();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext.invokeChannelActive(this.findContextInbound(8));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void invokeChannelActive(AbstractChannelHandlerContext next) {
        AbstractChannelHandlerContext abstractChannelHandlerContext;
        void var1_1;
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelActive();
            return;
        }
        var1_1.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeChannelActive();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void invokeChannelActive() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var2_3;
                    var2_3.channelActive(this);
                }
                if (handler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)handler).channelActive(this);
                }
                ((ChannelInboundHandler)handler).channelActive(this);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                this.invokeExceptionCaught((Throwable)var1_2);
                return;
            }
        } else {
            this.fireChannelActive();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.findContextInbound(16));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void invokeChannelInactive(AbstractChannelHandlerContext next) {
        AbstractChannelHandlerContext abstractChannelHandlerContext;
        void var1_1;
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelInactive();
            return;
        }
        var1_1.execute(new Runnable(){

            @Override
            public final void run() {
                abstractChannelHandlerContext.invokeChannelInactive();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void invokeChannelInactive() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var2_3;
                    var2_3.channelInactive(this);
                }
                if (handler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)handler).channelInactive(this);
                }
                ((ChannelInboundHandler)handler).channelInactive(this);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                this.invokeExceptionCaught((Throwable)var1_2);
                return;
            }
        } else {
            this.fireChannelInactive();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        void var1_1;
        AbstractChannelHandlerContext.invokeExceptionCaught(this.findContextInbound(1), (Throwable)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void invokeExceptionCaught(final AbstractChannelHandlerContext next, final Throwable cause) {
        ObjectUtil.checkNotNull((Object)cause, (String)"cause");
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeExceptionCaught(cause);
            return;
        }
        try {
            void var2_3;
            var2_3.execute(new Runnable(){

                @Override
                public final void run() {
                    AbstractChannelHandlerContext.access$400(next, cause);
                }
            });
            return;
        }
        catch (Throwable t) {
            if (logger.isWarnEnabled()) {
                void var1_2;
                void var0_1;
                logger.warn("Failed to submit an exceptionCaught() event.", (Throwable)var0_1);
                logger.warn("The exceptionCaught() event that was failed to submit was:", (Throwable)var1_2);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void invokeExceptionCaught(Throwable cause) {
        block5: {
            void var1_1;
            if (this.invokeHandler()) {
                try {
                    this.handler().exceptionCaught(this, cause);
                    return;
                }
                catch (Throwable error) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString((Throwable)error), (Object)cause);
                        break block5;
                    }
                    if (logger.isWarnEnabled()) {
                        void var2_2;
                        logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)var2_2, (Object)cause);
                    }
                    return;
                }
            }
            this.fireExceptionCaught((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object event) {
        void var1_1;
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.findContextInbound(128), var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void invokeUserEventTriggered(AbstractChannelHandlerContext next, Object event) {
        void var1_1;
        AbstractChannelHandlerContext abstractChannelHandlerContext;
        void var2_2;
        ObjectUtil.checkNotNull((Object)event, (String)"event");
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeUserEventTriggered(event);
            return;
        }
        var2_2.execute(new Runnable(){

            @Override
            public final void run() {
                AbstractChannelHandlerContext.access$500(abstractChannelHandlerContext, var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void invokeUserEventTriggered(Object event) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var3_4;
                    var3_4.userEventTriggered(this, event);
                }
                if (handler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)handler).userEventTriggered(this, event);
                }
                ((ChannelInboundHandler)handler).userEventTriggered(this, event);
                return;
            }
            catch (Throwable t) {
                void var2_3;
                this.invokeExceptionCaught((Throwable)var2_3);
                return;
            }
        } else {
            void var1_1;
            this.fireUserEventTriggered(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelHandlerContext fireChannelRead(Object msg) {
        void var1_1;
        AbstractChannelHandlerContext.invokeChannelRead(this.findContextInbound(32), var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void invokeChannelRead(AbstractChannelHandlerContext next, Object msg) {
        void var1_1;
        AbstractChannelHandlerContext abstractChannelHandlerContext;
        void var2_2;
        Object m = next.pipeline.touch(ObjectUtil.checkNotNull((Object)msg, (String)"msg"), next);
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelRead(m);
            return;
        }
        var2_2.execute(new Runnable(){

            @Override
            public final void run() {
                AbstractChannelHandlerContext.access$600(abstractChannelHandlerContext, var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void invokeChannelRead(Object msg) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var3_4;
                    var3_4.channelRead(this, msg);
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).channelRead(this, msg);
                }
                ((ChannelInboundHandler)handler).channelRead(this, msg);
                return;
            }
            catch (Throwable t) {
                void var2_3;
                this.invokeExceptionCaught((Throwable)var2_3);
                return;
            }
        } else {
            void var1_1;
            this.fireChannelRead(var1_1);
        }
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.findContextInbound(64));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void invokeChannelReadComplete(AbstractChannelHandlerContext next) {
        void var2_2;
        void var1_1;
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelReadComplete();
            return;
        }
        Tasks tasks = next.invokeTasks;
        if (tasks == null) {
            AbstractChannelHandlerContext abstractChannelHandlerContext;
            next.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
        }
        var1_1.execute(((Tasks)var2_2).invokeChannelReadCompleteTask);
    }

    /*
     * WARNING - void declaration
     */
    private void invokeChannelReadComplete() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var2_3;
                    var2_3.channelReadComplete(this);
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).channelReadComplete(this);
                }
                ((ChannelInboundHandler)handler).channelReadComplete(this);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                this.invokeExceptionCaught((Throwable)var1_2);
                return;
            }
        } else {
            this.fireChannelReadComplete();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.findContextInbound(256));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static void invokeChannelWritabilityChanged(AbstractChannelHandlerContext next) {
        void var2_2;
        void var1_1;
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelWritabilityChanged();
            return;
        }
        Tasks tasks = next.invokeTasks;
        if (tasks == null) {
            AbstractChannelHandlerContext abstractChannelHandlerContext;
            next.invokeTasks = tasks = new Tasks(abstractChannelHandlerContext);
        }
        var1_1.execute(((Tasks)var2_2).invokeChannelWritableStateChangedTask);
    }

    /*
     * WARNING - void declaration
     */
    private void invokeChannelWritabilityChanged() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var2_3;
                    var2_3.channelWritabilityChanged(this);
                }
                if (handler instanceof ChannelInboundHandlerAdapter) {
                    ((ChannelInboundHandlerAdapter)handler).channelWritabilityChanged(this);
                }
                ((ChannelInboundHandler)handler).channelWritabilityChanged(this);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                this.invokeExceptionCaught((Throwable)var1_2);
                return;
            }
        } else {
            this.fireChannelWritabilityChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        void var1_1;
        return this.bind((SocketAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        void var1_1;
        return this.connect((SocketAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        void var2_2;
        void var1_1;
        return this.connect((SocketAddress)var1_1, (SocketAddress)var2_2, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.disconnect(abstractChannelHandlerContext.newPromise());
    }

    @Override
    public ChannelFuture close() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.close(abstractChannelHandlerContext.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        return abstractChannelHandlerContext.deregister(abstractChannelHandlerContext.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        void var2_2;
        ObjectUtil.checkNotNull((Object)localAddress, (String)"localAddress");
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        AbstractChannelHandlerContext next = this.findContextOutbound(512);
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeBind(localAddress, promise);
        } else {
            void var1_1;
            void var3_3;
            AbstractChannelHandlerContext.safeExecute(executor, new Runnable(this, (AbstractChannelHandlerContext)var3_3, (SocketAddress)var1_1, promise){
                final /* synthetic */ AbstractChannelHandlerContext val$next;
                final /* synthetic */ SocketAddress val$localAddress;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractChannelHandlerContext this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$next = abstractChannelHandlerContext;
                    this.val$localAddress = socketAddress;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    AbstractChannelHandlerContext.access$900(this.val$next, this.val$localAddress, this.val$promise);
                }
            }, promise, null, false);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void invokeBind(SocketAddress localAddress, ChannelPromise promise) {
        if (this.invokeHandler()) {
            try {
                void var3_3;
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    headContext.bind(this, localAddress, promise);
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).bind(this, localAddress, promise);
                }
                if (handler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)handler).bind(this, localAddress, promise);
                }
                ((ChannelOutboundHandler)var3_3).bind(this, localAddress, promise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, promise);
                return;
            }
        } else {
            void var2_2;
            void var1_1;
            this.bind((SocketAddress)var1_1, (ChannelPromise)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.connect((SocketAddress)var1_1, null, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        void var3_3;
        ObjectUtil.checkNotNull((Object)remoteAddress, (String)"remoteAddress");
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        AbstractChannelHandlerContext next = this.findContextOutbound(1024);
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeConnect(remoteAddress, localAddress, promise);
        } else {
            void var2_2;
            void var1_1;
            AbstractChannelHandlerContext.safeExecute(executor, new Runnable(this, next, (SocketAddress)var1_1, (SocketAddress)var2_2, promise){
                final /* synthetic */ AbstractChannelHandlerContext val$next;
                final /* synthetic */ SocketAddress val$remoteAddress;
                final /* synthetic */ SocketAddress val$localAddress;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractChannelHandlerContext this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$next = abstractChannelHandlerContext;
                    this.val$remoteAddress = socketAddress;
                    this.val$localAddress = socketAddress2;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    AbstractChannelHandlerContext.access$1000(this.val$next, this.val$remoteAddress, this.val$localAddress, this.val$promise);
                }
            }, promise, null, false);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void invokeConnect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    headContext.connect(this, remoteAddress, localAddress, promise);
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).connect(this, remoteAddress, localAddress, promise);
                }
                if (handler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)handler).connect(this, remoteAddress, localAddress, promise);
                }
                ((ChannelOutboundHandler)handler).connect(this, remoteAddress, localAddress, promise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, promise);
                return;
            }
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            this.connect((SocketAddress)var1_1, (SocketAddress)var2_2, (ChannelPromise)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        void var1_1;
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(promise);
        }
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        AbstractChannelHandlerContext next = this.findContextOutbound(2048);
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeDisconnect(promise);
        } else {
            void var2_2;
            void var3_3;
            AbstractChannelHandlerContext.safeExecute((EventExecutor)var3_3, new Runnable(this, (AbstractChannelHandlerContext)var2_2, promise){
                final /* synthetic */ AbstractChannelHandlerContext val$next;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractChannelHandlerContext this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$next = abstractChannelHandlerContext;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    AbstractChannelHandlerContext.access$1100(this.val$next, this.val$promise);
                }
            }, promise, null, false);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void invokeDisconnect(ChannelPromise promise) {
        if (this.invokeHandler()) {
            try {
                void var2_2;
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var3_4;
                    var3_4.disconnect(this, promise);
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).disconnect(this, promise);
                }
                if (handler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)handler).disconnect(this, promise);
                }
                ((ChannelOutboundHandler)var2_2).disconnect(this, promise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, promise);
                return;
            }
        } else {
            void var1_1;
            this.disconnect((ChannelPromise)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture close(ChannelPromise promise) {
        void var1_1;
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        AbstractChannelHandlerContext next = this.findContextOutbound(4096);
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeClose(promise);
        } else {
            void var2_2;
            void var3_3;
            AbstractChannelHandlerContext.safeExecute((EventExecutor)var3_3, new Runnable(this, (AbstractChannelHandlerContext)var2_2, promise){
                final /* synthetic */ AbstractChannelHandlerContext val$next;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractChannelHandlerContext this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$next = abstractChannelHandlerContext;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    AbstractChannelHandlerContext.access$1200(this.val$next, this.val$promise);
                }
            }, promise, null, false);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void invokeClose(ChannelPromise promise) {
        if (this.invokeHandler()) {
            try {
                void var2_2;
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var3_4;
                    var3_4.close(this, promise);
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).close(this, promise);
                }
                if (handler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)handler).close(this, promise);
                }
                ((ChannelOutboundHandler)var2_2).close(this, promise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, promise);
                return;
            }
        } else {
            void var1_1;
            this.close((ChannelPromise)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        void var1_1;
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        AbstractChannelHandlerContext next = this.findContextOutbound(8192);
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeDeregister(promise);
        } else {
            void var2_2;
            void var3_3;
            AbstractChannelHandlerContext.safeExecute((EventExecutor)var3_3, new Runnable(this, (AbstractChannelHandlerContext)var2_2, promise){
                final /* synthetic */ AbstractChannelHandlerContext val$next;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractChannelHandlerContext this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$next = abstractChannelHandlerContext;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    AbstractChannelHandlerContext.access$1300(this.val$next, this.val$promise);
                }
            }, promise, null, false);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void invokeDeregister(ChannelPromise promise) {
        if (this.invokeHandler()) {
            try {
                void var2_2;
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var3_4;
                    var3_4.deregister(this, promise);
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).deregister(this, promise);
                }
                if (handler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)handler).deregister(this, promise);
                }
                ((ChannelOutboundHandler)var2_2).deregister(this, promise);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, promise);
                return;
            }
        } else {
            void var1_1;
            this.deregister((ChannelPromise)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelHandlerContext read() {
        AbstractChannelHandlerContext next = this.findContextOutbound(16384);
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeRead();
        } else {
            void var3_3;
            void var2_2;
            Tasks tasks = next.invokeTasks;
            if (tasks == null) {
                void var1_1;
                next.invokeTasks = tasks = new Tasks((AbstractChannelHandlerContext)var1_1);
            }
            var2_2.execute(((Tasks)var3_3).invokeReadTask);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void invokeRead() {
        if (this.invokeHandler()) {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var2_3;
                    var2_3.read(this);
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).read(this);
                }
                if (handler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)handler).read(this);
                }
                ((ChannelOutboundHandler)handler).read(this);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                this.invokeExceptionCaught((Throwable)var1_2);
                return;
            }
        } else {
            this.read();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture write(Object msg) {
        void var1_1;
        return this.write(var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        this.write(var1_1, false, promise);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    void invokeWrite(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        if (this.invokeHandler()) {
            this.invokeWrite0(msg, promise);
            return;
        }
        this.write(var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void invokeWrite0(Object msg, ChannelPromise promise) {
        block5: {
            try {
                void var1_1;
                void var3_3;
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    headContext.write(this, msg, promise);
                    break block5;
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).write(this, msg, promise);
                    break block5;
                }
                if (handler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)handler).write(this, msg, promise);
                    break block5;
                }
                ((ChannelOutboundHandler)var3_3).write(this, var1_1, promise);
                return;
            }
            catch (Throwable throwable) {
                void var2_2;
                Throwable throwable2 = throwable;
                AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, (ChannelPromise)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext next = this.findContextOutbound(65536);
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeFlush();
        } else {
            void var3_3;
            void var2_2;
            Tasks tasks = next.invokeTasks;
            if (tasks == null) {
                void var1_1;
                next.invokeTasks = tasks = new Tasks((AbstractChannelHandlerContext)var1_1);
            }
            AbstractChannelHandlerContext.safeExecute((EventExecutor)var2_2, ((Tasks)var3_3).invokeFlushTask, this.channel().voidPromise(), null, false);
        }
        return this;
    }

    private void invokeFlush() {
        if (this.invokeHandler()) {
            this.invokeFlush0();
            return;
        }
        this.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void invokeFlush0() {
        block5: {
            try {
                ChannelHandler handler = this.handler();
                DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                if (handler == headContext) {
                    void var2_3;
                    var2_3.flush(this);
                    break block5;
                }
                if (handler instanceof ChannelDuplexHandler) {
                    ((ChannelDuplexHandler)handler).flush(this);
                    break block5;
                }
                if (handler instanceof ChannelOutboundHandlerAdapter) {
                    ((ChannelOutboundHandlerAdapter)handler).flush(this);
                    break block5;
                }
                ((ChannelOutboundHandler)handler).flush(this);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                this.invokeExceptionCaught((Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        this.write(var1_1, true, promise);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    void invokeWriteAndFlush(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        if (this.invokeHandler()) {
            this.invokeWrite0(msg, promise);
            this.invokeFlush0();
            return;
        }
        this.writeAndFlush(var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void write(Object msg, boolean flush, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        ObjectUtil.checkNotNull((Object)msg, (String)"msg");
        try {
            if (this.isNotValidPromise(promise, true)) {
                ReferenceCountUtil.release((Object)msg);
                return;
            }
        }
        catch (RuntimeException e) {
            ReferenceCountUtil.release((Object)msg);
            throw e;
        }
        AbstractChannelHandlerContext next = this.findContextOutbound(flush ? 98304 : 32768);
        Object m = this.pipeline.touch(msg, next);
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            if (flush) {
                next.invokeWriteAndFlush(m, promise);
                return;
            }
            next.invokeWrite(m, promise);
            return;
        }
        WriteTask task = WriteTask.newInstance(next, m, promise, flush);
        if (!AbstractChannelHandlerContext.safeExecute(executor, task, (ChannelPromise)var3_3, var1_1, var2_2 == false)) {
            task.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        void var1_1;
        return this.writeAndFlush(var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    private static void notifyOutboundHandlerException(Throwable cause, ChannelPromise promise) {
        void var1_1;
        Throwable throwable;
        PromiseNotificationUtil.tryFailure((Promise)promise, (Throwable)throwable, (InternalLogger)(var1_1 instanceof VoidChannelPromise ? null : logger));
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture newSucceededFuture() {
        void var1_1;
        ChannelFuture succeededFuture = this.succeededFuture;
        if (succeededFuture == null) {
            this.succeededFuture = succeededFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        void var1_1;
        return new FailedChannelFuture(this.channel(), this.executor(), (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNotValidPromise(ChannelPromise promise, boolean allowVoidPromise) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)promise, (String)"promise");
        if (promise.isDone()) {
            if (promise.isCancelled()) {
                return true;
            }
            throw new IllegalArgumentException("promise already done: " + promise);
        }
        if (promise.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", promise.channel(), this.channel()));
        }
        if (promise.getClass() == DefaultChannelPromise.class) {
            return false;
        }
        if (var2_2 == false && promise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (var1_1 instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel.CloseFuture.class) + " not allowed in a pipeline");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractChannelHandlerContext findContextInbound(int mask) {
        void var2_2;
        AbstractChannelHandlerContext ctx = this;
        EventExecutor currentExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(ctx = ctx.next, currentExecutor, mask, 510)) {
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractChannelHandlerContext findContextOutbound(int mask) {
        void var2_2;
        AbstractChannelHandlerContext ctx = this;
        EventExecutor currentExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(ctx = ctx.prev, currentExecutor, mask, 130560)) {
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean skipContext(AbstractChannelHandlerContext ctx, EventExecutor currentExecutor, int mask, int onlyMask) {
        void var2_2;
        AbstractChannelHandlerContext abstractChannelHandlerContext;
        void var1_1;
        void var3_3;
        return (ctx.executionMask & (var3_3 | mask)) == 0 || ctx.executor() == var1_1 && (abstractChannelHandlerContext.executionMask & var2_2) == 0;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    final void setRemoved() {
        this.handlerState = 3;
    }

    /*
     * WARNING - void declaration
     */
    final boolean setAddComplete() {
        void var1_1;
        do {
            int oldState;
            if ((oldState = this.handlerState) != 3) continue;
            return false;
        } while (!HANDLER_STATE_UPDATER.compareAndSet(this, (int)var1_1, 2));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    final void setAddPending() {
        void var1_1;
        boolean updated = HANDLER_STATE_UPDATER.compareAndSet(this, 0, 1);
        assert (var1_1 != false);
    }

    final void callHandlerAdded() throws Exception {
        if (this.setAddComplete()) {
            this.handler().handlerAdded(this);
        }
    }

    final void callHandlerRemoved() throws Exception {
        try {
            if (this.handlerState == 2) {
                this.handler().handlerRemoved(this);
            }
            return;
        }
        finally {
            this.setRemoved();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean invokeHandler() {
        void var1_1;
        int handlerState = this.handlerState;
        return handlerState == 2 || !this.ordered && var1_1 == true;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerState == 3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Attribute<T> attr(AttributeKey<T> key) {
        void var1_1;
        return this.channel().attr((AttributeKey)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> boolean hasAttr(AttributeKey<T> key) {
        void var1_1;
        return this.channel().hasAttr((AttributeKey)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean safeExecute(EventExecutor executor, Runnable runnable, ChannelPromise promise, Object msg, boolean lazy) {
        try {
            if (lazy && executor instanceof AbstractEventExecutor) {
                ((AbstractEventExecutor)executor).lazyExecute(runnable);
            } else {
                void var1_2;
                executor.execute((Runnable)var1_2);
            }
            return true;
        }
        catch (Throwable cause) {
            try {
                if (msg != null) {
                    void var3_5;
                    ReferenceCountUtil.release((Object)var3_5);
                }
                promise.setFailure(cause);
            }
            catch (Throwable throwable) {
                void var0_1;
                void var2_4;
                var2_4.setFailure((Throwable)var0_1);
                throw throwable;
            }
            return false;
        }
    }

    public String toHintString() {
        return "'" + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(AbstractChannelHandlerContext x0, Throwable x1) {
        void var1_1;
        x0.invokeExceptionCaught((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(AbstractChannelHandlerContext x0, Object x1) {
        void var1_1;
        x0.invokeUserEventTriggered(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(AbstractChannelHandlerContext x0, Object x1) {
        void var1_1;
        x0.invokeChannelRead(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(AbstractChannelHandlerContext x0, SocketAddress x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        x0.invokeBind((SocketAddress)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(AbstractChannelHandlerContext x0, SocketAddress x1, SocketAddress x2, ChannelPromise x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.invokeConnect((SocketAddress)var1_1, (SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1100(AbstractChannelHandlerContext x0, ChannelPromise x1) {
        void var1_1;
        x0.invokeDisconnect((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1200(AbstractChannelHandlerContext x0, ChannelPromise x1) {
        void var1_1;
        x0.invokeClose((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1300(AbstractChannelHandlerContext x0, ChannelPromise x1) {
        void var1_1;
        x0.invokeDeregister((ChannelPromise)var1_1);
    }

    private static final class Tasks {
        private final AbstractChannelHandlerContext next;
        private final Runnable invokeChannelReadCompleteTask = new Runnable(this){
            final /* synthetic */ Tasks this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.next.invokeChannelReadComplete();
            }
        };
        private final Runnable invokeReadTask = new Runnable(this){
            final /* synthetic */ Tasks this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.next.invokeRead();
            }
        };
        private final Runnable invokeChannelWritableStateChangedTask = new Runnable(this){
            final /* synthetic */ Tasks this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.next.invokeChannelWritabilityChanged();
            }
        };
        private final Runnable invokeFlushTask = new Runnable(this){
            final /* synthetic */ Tasks this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.next.invokeFlush();
            }
        };

        /*
         * WARNING - void declaration
         */
        Tasks(AbstractChannelHandlerContext next) {
            void var1_1;
            this.next = var1_1;
        }
    }

    static final class WriteTask
    implements Runnable {
        private static final ObjectPool<WriteTask> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<WriteTask>(){

            /*
             * WARNING - void declaration
             */
            public final WriteTask newObject(ObjectPool.Handle<WriteTask> handle) {
                void var1_1;
                return new WriteTask((ObjectPool.Handle)var1_1);
            }
        });
        private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean((String)"io.netty.transport.estimateSizeOnSubmit", (boolean)true);
        private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt((String)"io.netty.transport.writeTaskSizeOverhead", (int)32);
        private final ObjectPool.Handle<WriteTask> handle;
        private AbstractChannelHandlerContext ctx;
        private Object msg;
        private ChannelPromise promise;
        private int size;

        /*
         * WARNING - void declaration
         */
        static WriteTask newInstance(AbstractChannelHandlerContext ctx, Object msg, ChannelPromise promise, boolean flush) {
            void var3_3;
            void var2_2;
            void var1_1;
            AbstractChannelHandlerContext abstractChannelHandlerContext;
            WriteTask task = (WriteTask)RECYCLER.get();
            WriteTask.init(task, abstractChannelHandlerContext, var1_1, (ChannelPromise)var2_2, (boolean)var3_3);
            return task;
        }

        /*
         * WARNING - void declaration
         */
        private WriteTask(ObjectPool.Handle<? extends WriteTask> handle) {
            void var1_1;
            this.handle = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected static void init(WriteTask task, AbstractChannelHandlerContext ctx, Object msg, ChannelPromise promise, boolean flush) {
            void var3_3;
            task.ctx = ctx;
            task.msg = msg;
            task.promise = var3_3;
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                void var1_1;
                void var2_2;
                task.size = ctx.pipeline.estimatorHandle().size(var2_2) + WRITE_TASK_OVERHEAD;
                ((AbstractChannelHandlerContext)var1_1).pipeline.incrementPendingOutboundBytes(task.size);
            } else {
                task.size = 0;
            }
            if (flush) {
                var0.size |= Integer.MIN_VALUE;
            }
        }

        @Override
        public final void run() {
            try {
                this.decrementPendingOutboundBytes();
                if (this.size >= 0) {
                    this.ctx.invokeWrite(this.msg, this.promise);
                } else {
                    this.ctx.invokeWriteAndFlush(this.msg, this.promise);
                }
                return;
            }
            finally {
                this.recycle();
            }
        }

        final void cancel() {
            try {
                this.decrementPendingOutboundBytes();
                return;
            }
            finally {
                this.recycle();
            }
        }

        private void decrementPendingOutboundBytes() {
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                this.ctx.pipeline.decrementPendingOutboundBytes(this.size & Integer.MAX_VALUE);
            }
        }

        private void recycle() {
            this.ctx = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle((Object)this);
        }
    }
}

