/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelId;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.StacklessClosedChannelException;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.channel.socket.ChannelOutputShutdownException;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractChannel
extends DefaultAttributeMap
implements Channel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannel.class);
    private final Channel parent;
    private final ChannelId id;
    private final Channel.Unsafe unsafe;
    private final DefaultChannelPipeline pipeline;
    private final VoidChannelPromise unsafeVoidPromise = new VoidChannelPromise(this, false);
    private final CloseFuture closeFuture = new CloseFuture(this);
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;
    private volatile EventLoop eventLoop;
    private volatile boolean registered;
    private boolean closeInitiated;
    private Throwable initialCloseCause;
    private boolean strValActive;
    private String strVal;

    /*
     * WARNING - void declaration
     */
    protected AbstractChannel(Channel parent) {
        void var1_1;
        this.parent = var1_1;
        this.id = this.newId();
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractChannel(Channel parent, ChannelId id) {
        void var2_2;
        void var1_1;
        this.parent = var1_1;
        this.id = var2_2;
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    /*
     * WARNING - void declaration
     */
    protected final int maxMessagesPerWrite() {
        void var1_1;
        ChannelConfig config = this.config();
        if (config instanceof DefaultChannelConfig) {
            return ((DefaultChannelConfig)config).getMaxMessagesPerWrite();
        }
        Integer value = config.getOption(ChannelOption.MAX_MESSAGES_PER_WRITE);
        if (value == null) {
            return Integer.MAX_VALUE;
        }
        return var1_1.intValue();
    }

    @Override
    public final ChannelId id() {
        return this.id;
    }

    protected ChannelId newId() {
        return DefaultChannelId.newInstance();
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        return new DefaultChannelPipeline(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWritable() {
        void var1_1;
        ChannelOutboundBuffer buf = this.unsafe.outboundBuffer();
        return buf != null && var1_1.isWritable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long bytesBeforeUnwritable() {
        ChannelOutboundBuffer buf = this.unsafe.outboundBuffer();
        if (buf != null) {
            void var1_1;
            return var1_1.bytesBeforeUnwritable();
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long bytesBeforeWritable() {
        ChannelOutboundBuffer buf = this.unsafe.outboundBuffer();
        if (buf != null) {
            void var1_1;
            return var1_1.bytesBeforeWritable();
        }
        return Long.MAX_VALUE;
    }

    @Override
    public Channel parent() {
        return this.parent;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EventLoop eventLoop() {
        void var1_1;
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            throw new IllegalStateException("channel not registered to an event loop");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SocketAddress localAddress() {
        void var1_1;
        Serializable localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                this.localAddress = localAddress = this.unsafe().localAddress();
            }
            catch (Error error) {
                localAddress = error;
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return var1_1;
    }

    @Deprecated
    protected void invalidateLocalAddress() {
        this.localAddress = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SocketAddress remoteAddress() {
        void var1_1;
        Serializable remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = this.unsafe().remoteAddress();
            }
            catch (Error error) {
                remoteAddress = error;
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return var1_1;
    }

    @Deprecated
    protected void invalidateRemoteAddress() {
        this.remoteAddress = null;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        void var1_1;
        return this.pipeline.bind((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        void var1_1;
        return this.pipeline.connect((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        void var2_2;
        void var1_1;
        return this.pipeline.connect((SocketAddress)var1_1, (SocketAddress)var2_2);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.pipeline.disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.pipeline.close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.pipeline.deregister();
    }

    @Override
    public Channel flush() {
        this.pipeline.flush();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.pipeline.bind((SocketAddress)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.pipeline.connect((SocketAddress)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.pipeline.connect((SocketAddress)var1_1, (SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        void var1_1;
        return this.pipeline.disconnect((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture close(ChannelPromise promise) {
        void var1_1;
        return this.pipeline.close((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        void var1_1;
        return this.pipeline.deregister((ChannelPromise)var1_1);
    }

    @Override
    public Channel read() {
        this.pipeline.read();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture write(Object msg) {
        void var1_1;
        return this.pipeline.write(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.pipeline.write(var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        void var1_1;
        return this.pipeline.writeAndFlush(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.pipeline.writeAndFlush(var1_1, (ChannelPromise)var2_2);
    }

    @Override
    public ChannelPromise newPromise() {
        return this.pipeline.newPromise();
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline.newProgressivePromise();
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.pipeline.newSucceededFuture();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        void var1_1;
        return this.pipeline.newFailedFuture((Throwable)var1_1);
    }

    @Override
    public ChannelFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public Channel.Unsafe unsafe() {
        return this.unsafe;
    }

    protected abstract AbstractUnsafe newUnsafe();

    public final int hashCode() {
        return this.id.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        return this == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Channel o) {
        void var1_1;
        if (this == o) {
            return 0;
        }
        return this.id().compareTo(var1_1.id());
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buf;
        boolean active = this.isActive();
        if (this.strValActive == active && this.strVal != null) {
            return this.strVal;
        }
        SocketAddress remoteAddr = this.remoteAddress();
        SocketAddress localAddr = this.localAddress();
        if (remoteAddr != null) {
            buf = new StringBuilder(96).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(localAddr).append(active ? " - " : " ! ").append("R:").append(remoteAddr).append(']');
            this.strVal = buf.toString();
        } else if (localAddr != null) {
            void var3_3;
            buf = new StringBuilder(64).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(var3_3).append(']');
            this.strVal = buf.toString();
        } else {
            void var2_2;
            buf = new StringBuilder(16).append("[id: 0x").append(this.id.asShortText()).append(']');
            this.strVal = var2_2.toString();
        }
        this.strValActive = var1_1;
        return this.strVal;
    }

    @Override
    public final ChannelPromise voidPromise() {
        return this.pipeline.voidPromise();
    }

    protected abstract boolean isCompatible(EventLoop var1);

    protected abstract SocketAddress localAddress0();

    protected abstract SocketAddress remoteAddress0();

    protected void doRegister() throws Exception {
    }

    protected abstract void doBind(SocketAddress var1) throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected abstract void doClose() throws Exception;

    protected void doShutdownOutput() throws Exception {
        this.doClose();
    }

    protected void doDeregister() throws Exception {
    }

    protected abstract void doBeginRead() throws Exception;

    protected abstract void doWrite(ChannelOutboundBuffer var1) throws Exception;

    protected Object filterOutboundMessage(Object msg) throws Exception {
        return msg;
    }

    /*
     * WARNING - void declaration
     */
    protected void validateFileRegion(DefaultFileRegion region, long position) throws IOException {
        void var2_2;
        DefaultFileRegion.validate(region, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ EventLoop access$102(AbstractChannel x0, EventLoop x1) {
        void var1_1;
        x0.eventLoop = var1_1;
        return x0.eventLoop;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(AbstractChannel x0, boolean x1) {
        void var1_1;
        x0.registered = var1_1;
        return x0.registered;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SocketAddress access$602(AbstractChannel x0, SocketAddress x1) {
        void var1_1;
        x0.remoteAddress = var1_1;
        return x0.remoteAddress;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SocketAddress access$702(AbstractChannel x0, SocketAddress x1) {
        void var1_1;
        x0.localAddress = var1_1;
        return x0.localAddress;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$802(AbstractChannel x0, boolean x1) {
        void var1_1;
        x0.closeInitiated = var1_1;
        return x0.closeInitiated;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Throwable access$1202(AbstractChannel x0, Throwable x1) {
        void var1_1;
        x0.initialCloseCause = var1_1;
        return x0.initialCloseCause;
    }

    private static final class AnnotatedSocketException
    extends SocketException {
        private static final long serialVersionUID = 3896743275010454039L;

        /*
         * WARNING - void declaration
         */
        AnnotatedSocketException(SocketException exception, SocketAddress remoteAddress) {
            super(exception.getMessage() + ": " + var2_2);
            void var1_1;
            void var2_2;
            this.initCause((Throwable)var1_1);
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedNoRouteToHostException
    extends NoRouteToHostException {
        private static final long serialVersionUID = -6801433937592080623L;

        /*
         * WARNING - void declaration
         */
        AnnotatedNoRouteToHostException(NoRouteToHostException exception, SocketAddress remoteAddress) {
            super(exception.getMessage() + ": " + var2_2);
            void var1_1;
            void var2_2;
            this.initCause((Throwable)var1_1);
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedConnectException
    extends ConnectException {
        private static final long serialVersionUID = 3901958112696433556L;

        /*
         * WARNING - void declaration
         */
        AnnotatedConnectException(ConnectException exception, SocketAddress remoteAddress) {
            super(exception.getMessage() + ": " + var2_2);
            void var1_1;
            void var2_2;
            this.initCause((Throwable)var1_1);
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class CloseFuture
    extends DefaultChannelPromise {
        /*
         * WARNING - void declaration
         */
        CloseFuture(AbstractChannel ch) {
            super((Channel)var1_1);
            void var1_1;
        }

        @Override
        public final ChannelPromise setSuccess() {
            throw new IllegalStateException();
        }

        @Override
        public final ChannelPromise setFailure(Throwable cause) {
            throw new IllegalStateException();
        }

        @Override
        public final boolean trySuccess() {
            throw new IllegalStateException();
        }

        public final boolean tryFailure(Throwable cause) {
            throw new IllegalStateException();
        }

        final boolean setClosed() {
            return super.trySuccess();
        }
    }

    protected abstract class AbstractUnsafe
    implements Channel.Unsafe {
        private volatile ChannelOutboundBuffer outboundBuffer;
        private RecvByteBufAllocator.Handle recvHandle;
        private boolean inFlush0;
        private boolean neverRegistered;
        final /* synthetic */ AbstractChannel this$0;

        /*
         * WARNING - void declaration
         */
        protected AbstractUnsafe(AbstractChannel this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.outboundBuffer = new ChannelOutboundBuffer(this.this$0);
            this.neverRegistered = true;
        }

        private void assertEventLoop() {
            assert (!this.this$0.registered || this.this$0.eventLoop.inEventLoop());
        }

        @Override
        public RecvByteBufAllocator.Handle recvBufAllocHandle() {
            if (this.recvHandle == null) {
                this.recvHandle = this.this$0.config().getRecvByteBufAllocator().newHandle();
            }
            return this.recvHandle;
        }

        @Override
        public final ChannelOutboundBuffer outboundBuffer() {
            return this.outboundBuffer;
        }

        @Override
        public final SocketAddress localAddress() {
            return this.this$0.localAddress0();
        }

        @Override
        public final SocketAddress remoteAddress() {
            return this.this$0.remoteAddress0();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void register(EventLoop eventLoop, ChannelPromise promise) {
            ObjectUtil.checkNotNull((Object)eventLoop, (String)"eventLoop");
            if (this.this$0.isRegistered()) {
                promise.setFailure(new IllegalStateException("registered to an event loop already"));
                return;
            }
            if (!this.this$0.isCompatible(eventLoop)) {
                promise.setFailure(new IllegalStateException("incompatible event loop type: " + eventLoop.getClass().getName()));
                return;
            }
            AbstractChannel.access$102(this.this$0, eventLoop);
            if (eventLoop.inEventLoop()) {
                this.register0(promise);
                return;
            }
            try {
                eventLoop.execute(new Runnable(this, promise){
                    final /* synthetic */ ChannelPromise val$promise;
                    final /* synthetic */ AbstractUnsafe this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$promise = channelPromise;
                    }

                    @Override
                    public void run() {
                        AbstractUnsafe.access$200(this.this$1, this.val$promise);
                    }
                });
                return;
            }
            catch (Throwable t) {
                void var1_2;
                void var2_3;
                logger.warn("Force-closing a channel whose registration task was not accepted by an event loop: {}", (Object)this.this$0, (Object)t);
                this.closeForcibly();
                this.this$0.closeFuture.setClosed();
                this.safeSetFailure((ChannelPromise)var2_3, (Throwable)var1_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void register0(ChannelPromise promise) {
            try {
                block8: {
                    block7: {
                        if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                            return;
                        }
                        boolean firstRegistration = this.neverRegistered;
                        this.this$0.doRegister();
                        this.neverRegistered = false;
                        AbstractChannel.access$002(this.this$0, true);
                        this.this$0.pipeline.invokeHandlerAddedIfNeeded();
                        this.safeSetSuccess(promise);
                        this.this$0.pipeline.fireChannelRegistered();
                        if (!this.this$0.isActive()) break block7;
                        if (firstRegistration) break block8;
                        if (this.this$0.config().isAutoRead()) {
                            this.beginRead();
                        }
                    }
                    return;
                }
                this.this$0.pipeline.fireChannelActive();
            }
            catch (Throwable t) {
                void var2_3;
                void var1_1;
                this.closeForcibly();
                this.this$0.closeFuture.setClosed();
                this.safeSetFailure((ChannelPromise)var1_1, (Throwable)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void bind(SocketAddress localAddress, ChannelPromise promise) {
            void var2_3;
            void var3_4;
            this.assertEventLoop();
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            if (Boolean.TRUE.equals(this.this$0.config().getOption(ChannelOption.SO_BROADCAST)) && localAddress instanceof InetSocketAddress && !((InetSocketAddress)localAddress).getAddress().isAnyLocalAddress() && !PlatformDependent.isWindows() && !PlatformDependent.maybeSuperUser()) {
                logger.warn("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; binding to a non-wildcard address (" + localAddress + ") anyway as requested.");
            }
            boolean wasActive = this.this$0.isActive();
            try {
                this.this$0.doBind(localAddress);
            }
            catch (Throwable t) {
                void var1_2;
                this.safeSetFailure(promise, (Throwable)var1_2);
                this.closeIfClosed();
                return;
            }
            if (var3_4 == false && this.this$0.isActive()) {
                this.invokeLater(new Runnable(this){
                    final /* synthetic */ AbstractUnsafe this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.pipeline.fireChannelActive();
                    }
                });
            }
            this.safeSetSuccess((ChannelPromise)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void disconnect(ChannelPromise promise) {
            void var1_1;
            void var2_2;
            this.assertEventLoop();
            if (!promise.setUncancellable()) {
                return;
            }
            boolean wasActive = this.this$0.isActive();
            try {
                this.this$0.doDisconnect();
                AbstractChannel.access$602(this.this$0, null);
                AbstractChannel.access$702(this.this$0, null);
            }
            catch (Throwable t) {
                void var2_3;
                this.safeSetFailure(promise, (Throwable)var2_3);
                this.closeIfClosed();
                return;
            }
            if (var2_2 != false && !this.this$0.isActive()) {
                this.invokeLater(new Runnable(this){
                    final /* synthetic */ AbstractUnsafe this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.pipeline.fireChannelInactive();
                    }
                });
            }
            this.safeSetSuccess((ChannelPromise)var1_1);
            this.closeIfClosed();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void close(ChannelPromise promise) {
            void var1_1;
            void var2_2;
            this.assertEventLoop();
            StacklessClosedChannelException closedChannelException = StacklessClosedChannelException.newInstance(AbstractChannel.class, "close(ChannelPromise)");
            void v0 = var2_2;
            this.close((ChannelPromise)var1_1, (Throwable)v0, (ClosedChannelException)v0, false);
        }

        /*
         * WARNING - void declaration
         */
        public final void shutdownOutput(ChannelPromise promise) {
            void var1_1;
            this.assertEventLoop();
            this.shutdownOutput((ChannelPromise)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        private void shutdownOutput(ChannelPromise promise, Throwable cause) {
            if (!promise.setUncancellable()) {
                return;
            }
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null) {
                promise.setFailure(new ClosedChannelException());
                return;
            }
            this.outboundBuffer = null;
            ChannelOutputShutdownException shutdownCause = cause == null ? new ChannelOutputShutdownException("Channel output shutdown") : new ChannelOutputShutdownException("Channel output shutdown", cause);
            try {
                this.this$0.doShutdownOutput();
                promise.setSuccess();
                AbstractUnsafe abstractUnsafe = this;
                abstractUnsafe.closeOutboundBufferForShutdown(abstractUnsafe.this$0.pipeline, outboundBuffer, shutdownCause);
                return;
            }
            catch (Throwable err) {
                try {
                    void var1_1;
                    var1_1.setFailure(err);
                    AbstractUnsafe abstractUnsafe = this;
                    abstractUnsafe.closeOutboundBufferForShutdown(abstractUnsafe.this$0.pipeline, outboundBuffer, shutdownCause);
                    return;
                }
                catch (Throwable throwable) {
                    void var2_3;
                    void var3_4;
                    AbstractUnsafe abstractUnsafe = this;
                    abstractUnsafe.closeOutboundBufferForShutdown(abstractUnsafe.this$0.pipeline, (ChannelOutboundBuffer)var3_4, (Throwable)var2_3);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void closeOutboundBufferForShutdown(ChannelPipeline pipeline, ChannelOutboundBuffer buffer, Throwable cause) {
            void var1_1;
            void var3_3;
            void var2_2;
            buffer.failFlushed(cause, false);
            var2_2.close((Throwable)var3_3, true);
            var1_1.fireUserEventTriggered(ChannelOutputShutdownEvent.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        private void close(ChannelPromise promise, Throwable cause, ClosedChannelException closeCause, boolean notify) {
            if (!promise.setUncancellable()) {
                return;
            }
            if (this.this$0.closeInitiated) {
                if (this.this$0.closeFuture.isDone()) {
                    this.safeSetSuccess(promise);
                    return;
                }
                if (!(promise instanceof VoidChannelPromise)) {
                    this.this$0.closeFuture.addListener(new ChannelFutureListener(this, promise){
                        final /* synthetic */ ChannelPromise val$promise;
                        final /* synthetic */ AbstractUnsafe this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                            this.val$promise = channelPromise;
                        }

                        public void operationComplete(ChannelFuture future) throws Exception {
                            this.val$promise.setSuccess();
                        }
                    });
                }
                return;
            }
            AbstractChannel.access$802(this.this$0, true);
            boolean wasActive = this.this$0.isActive();
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            this.outboundBuffer = null;
            Executor closeExecutor = this.prepareToClose();
            if (closeExecutor != null) {
                closeExecutor.execute(new Runnable(this, promise, outboundBuffer, cause, notify, closeCause, wasActive){
                    final /* synthetic */ ChannelPromise val$promise;
                    final /* synthetic */ ChannelOutboundBuffer val$outboundBuffer;
                    final /* synthetic */ Throwable val$cause;
                    final /* synthetic */ boolean val$notify;
                    final /* synthetic */ ClosedChannelException val$closeCause;
                    final /* synthetic */ boolean val$wasActive;
                    final /* synthetic */ AbstractUnsafe this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$promise = channelPromise;
                        this.val$outboundBuffer = channelOutboundBuffer;
                        this.val$cause = throwable;
                        this.val$notify = bl;
                        this.val$closeCause = closedChannelException;
                        this.val$wasActive = bl2;
                    }

                    @Override
                    public void run() {
                        try {
                            AbstractUnsafe.access$900(this.this$1, this.val$promise);
                        }
                        catch (Throwable throwable) {
                            AbstractUnsafe.access$1100(this.this$1, new Runnable(this){
                                final /* synthetic */ 5 this$2;
                                {
                                    void var1_1;
                                    this.this$2 = var1_1;
                                }

                                @Override
                                public void run() {
                                    if (this.this$2.val$outboundBuffer != null) {
                                        this.this$2.val$outboundBuffer.failFlushed(this.this$2.val$cause, this.this$2.val$notify);
                                        this.this$2.val$outboundBuffer.close(this.this$2.val$closeCause);
                                    }
                                    AbstractUnsafe.access$1000(this.this$2.this$1, this.this$2.val$wasActive);
                                }
                            });
                            throw throwable;
                        }
                        AbstractUnsafe.access$1100(this.this$1, new /* invalid duplicate definition of identical inner class */);
                    }
                });
                return;
            }
            try {
                void var1_1;
                this.doClose0((ChannelPromise)var1_1);
                if (outboundBuffer != null) {
                    outboundBuffer.failFlushed(cause, notify);
                    outboundBuffer.close(closeCause);
                }
            }
            catch (Throwable throwable) {
                if (outboundBuffer != null) {
                    void var3_4;
                    void var2_3;
                    outboundBuffer.failFlushed((Throwable)var2_3, notify);
                    outboundBuffer.close((ClosedChannelException)var3_4);
                }
                throw throwable;
            }
            if (this.inFlush0) {
                this.invokeLater(new Runnable(this, wasActive){
                    final /* synthetic */ boolean val$wasActive;
                    final /* synthetic */ AbstractUnsafe this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$wasActive = bl;
                    }

                    @Override
                    public void run() {
                        AbstractUnsafe.access$1000(this.this$1, this.val$wasActive);
                    }
                });
                return;
            }
            this.fireChannelInactiveAndDeregister(wasActive);
        }

        /*
         * WARNING - void declaration
         */
        private void doClose0(ChannelPromise promise) {
            try {
                this.this$0.doClose();
                this.this$0.closeFuture.setClosed();
                this.safeSetSuccess(promise);
                return;
            }
            catch (Throwable t) {
                void var2_2;
                void var1_1;
                this.this$0.closeFuture.setClosed();
                this.safeSetFailure((ChannelPromise)var1_1, (Throwable)var2_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fireChannelInactiveAndDeregister(boolean wasActive) {
            void var1_1;
            AbstractUnsafe abstractUnsafe = this;
            abstractUnsafe.deregister(abstractUnsafe.voidPromise(), var1_1 != false && !this.this$0.isActive());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void closeForcibly() {
            this.assertEventLoop();
            try {
                this.this$0.doClose();
                return;
            }
            catch (Exception e) {
                void var1_1;
                logger.warn("Failed to close a channel.", (Throwable)var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void deregister(ChannelPromise promise) {
            void var1_1;
            this.assertEventLoop();
            this.deregister((ChannelPromise)var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        private void deregister(ChannelPromise promise, boolean fireChannelInactive) {
            void var1_1;
            void var2_2;
            if (!promise.setUncancellable()) {
                return;
            }
            if (!this.this$0.registered) {
                this.safeSetSuccess(promise);
                return;
            }
            this.invokeLater(new Runnable(this, (boolean)var2_2, (ChannelPromise)var1_1){
                final /* synthetic */ boolean val$fireChannelInactive;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractUnsafe this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$fireChannelInactive = bl;
                    this.val$promise = channelPromise;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        this.this$1.this$0.doDeregister();
                        return;
                    }
                    catch (Throwable t) {
                        void var1_1;
                        logger.warn("Unexpected exception occurred while deregistering a channel.", (Throwable)var1_1);
                        return;
                    }
                    finally {
                        if (this.val$fireChannelInactive) {
                            this.this$1.this$0.pipeline.fireChannelInactive();
                        }
                        if (this.this$1.this$0.registered) {
                            AbstractChannel.access$002(this.this$1.this$0, false);
                            this.this$1.this$0.pipeline.fireChannelUnregistered();
                        }
                        this.this$1.safeSetSuccess(this.val$promise);
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void beginRead() {
            this.assertEventLoop();
            try {
                this.this$0.doBeginRead();
                return;
            }
            catch (Exception e) {
                void var1_1;
                this.invokeLater(new Runnable(this, (Exception)var1_1){
                    final /* synthetic */ Exception val$e;
                    final /* synthetic */ AbstractUnsafe this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$e = exception;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.pipeline.fireExceptionCaught(this.val$e);
                    }
                });
                AbstractUnsafe abstractUnsafe = this;
                abstractUnsafe.close(abstractUnsafe.voidPromise());
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(Object msg2, ChannelPromise promise) {
            void var2_3;
            void var1_1;
            void var3_4;
            int size;
            this.assertEventLoop();
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null) {
                try {
                    ReferenceCountUtil.release((Object)msg2);
                    AbstractUnsafe abstractUnsafe = this;
                    this.safeSetFailure(promise, abstractUnsafe.newClosedChannelException(abstractUnsafe.this$0.initialCloseCause, "write(Object, ChannelPromise)"));
                    return;
                }
                catch (Throwable throwable) {
                    AbstractUnsafe abstractUnsafe = this;
                    this.safeSetFailure(promise, abstractUnsafe.newClosedChannelException(abstractUnsafe.this$0.initialCloseCause, "write(Object, ChannelPromise)"));
                    throw throwable;
                }
            }
            try {
                msg2 = this.this$0.filterOutboundMessage(msg2);
                size = this.this$0.pipeline.estimatorHandle().size(msg2);
                if (size < 0) {
                    size = 0;
                }
            }
            catch (Throwable t) {
                try {
                    ReferenceCountUtil.release((Object)msg2);
                    this.safeSetFailure(promise, t);
                    return;
                }
                catch (Throwable msg2) {
                    void var3_5;
                    this.safeSetFailure(promise, (Throwable)var3_5);
                    throw msg2;
                }
            }
            var3_4.addMessage(var1_1, size, (ChannelPromise)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void flush() {
            void var1_1;
            this.assertEventLoop();
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null) {
                return;
            }
            var1_1.addFlush();
            this.flush0();
        }

        /*
         * WARNING - void declaration
         */
        protected void flush0() {
            if (this.inFlush0) {
                return;
            }
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer;
            if (outboundBuffer == null || outboundBuffer.isEmpty()) {
                return;
            }
            this.inFlush0 = true;
            if (!this.this$0.isActive()) {
                try {
                    if (!outboundBuffer.isEmpty()) {
                        if (this.this$0.isOpen()) {
                            outboundBuffer.failFlushed(new NotYetConnectedException(), true);
                        } else {
                            AbstractUnsafe abstractUnsafe = this;
                            outboundBuffer.failFlushed(abstractUnsafe.newClosedChannelException(abstractUnsafe.this$0.initialCloseCause, "flush0()"), false);
                        }
                    }
                    return;
                }
                finally {
                    this.inFlush0 = false;
                }
            }
            try {
                this.this$0.doWrite(outboundBuffer);
                return;
            }
            catch (Throwable t) {
                void var1_3;
                this.handleWriteError((Throwable)var1_3);
                return;
            }
            finally {
                this.inFlush0 = false;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected final void handleWriteError(Throwable t) {
            if (t instanceof IOException && this.this$0.config().isAutoClose()) {
                AbstractChannel.access$1202(this.this$0, t);
                AbstractUnsafe abstractUnsafe = this;
                abstractUnsafe.close(abstractUnsafe.voidPromise(), t, this.newClosedChannelException(t, "flush0()"), false);
                return;
            }
            try {
                AbstractUnsafe abstractUnsafe = this;
                abstractUnsafe.shutdownOutput(abstractUnsafe.voidPromise(), t);
                return;
            }
            catch (Throwable t2) {
                void var1_1;
                void var2_2;
                AbstractChannel.access$1202(this.this$0, t);
                AbstractUnsafe abstractUnsafe = this;
                abstractUnsafe.close(abstractUnsafe.voidPromise(), (Throwable)var2_2, this.newClosedChannelException((Throwable)var1_1, "flush0()"), false);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private ClosedChannelException newClosedChannelException(Throwable cause, String method) {
            void var2_2;
            StacklessClosedChannelException exception = StacklessClosedChannelException.newInstance(AbstractUnsafe.class, method);
            if (cause != null) {
                void var1_1;
                exception.initCause((Throwable)var1_1);
            }
            return var2_2;
        }

        @Override
        public final ChannelPromise voidPromise() {
            this.assertEventLoop();
            return this.this$0.unsafeVoidPromise;
        }

        /*
         * WARNING - void declaration
         */
        protected final boolean ensureOpen(ChannelPromise promise) {
            void var1_1;
            if (this.this$0.isOpen()) {
                return true;
            }
            AbstractUnsafe abstractUnsafe = this;
            this.safeSetFailure((ChannelPromise)var1_1, abstractUnsafe.newClosedChannelException(abstractUnsafe.this$0.initialCloseCause, "ensureOpen(ChannelPromise)"));
            return false;
        }

        /*
         * WARNING - void declaration
         */
        protected final void safeSetSuccess(ChannelPromise promise) {
            if (!(promise instanceof VoidChannelPromise) && !promise.trySuccess()) {
                void var1_1;
                logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected final void safeSetFailure(ChannelPromise promise, Throwable cause) {
            if (!(promise instanceof VoidChannelPromise) && !promise.tryFailure(cause)) {
                void var2_2;
                void var1_1;
                logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)var1_1, (Object)var2_2);
            }
        }

        protected final void closeIfClosed() {
            if (this.this$0.isOpen()) {
                return;
            }
            AbstractUnsafe abstractUnsafe = this;
            abstractUnsafe.close(abstractUnsafe.voidPromise());
        }

        /*
         * WARNING - void declaration
         */
        private void invokeLater(Runnable task) {
            try {
                this.this$0.eventLoop().execute(task);
                return;
            }
            catch (RejectedExecutionException e) {
                void var1_2;
                logger.warn("Can't invoke task later as EventLoop rejected it", (Throwable)var1_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected final Throwable annotateConnectException(Throwable cause, SocketAddress remoteAddress) {
            void var1_1;
            if (cause instanceof ConnectException) {
                return new AnnotatedConnectException((ConnectException)cause, remoteAddress);
            }
            if (cause instanceof NoRouteToHostException) {
                return new AnnotatedNoRouteToHostException((NoRouteToHostException)cause, remoteAddress);
            }
            if (cause instanceof SocketException) {
                void var2_2;
                return new AnnotatedSocketException((SocketException)cause, (SocketAddress)var2_2);
            }
            return var1_1;
        }

        protected Executor prepareToClose() {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$200(AbstractUnsafe x0, ChannelPromise x1) {
            void var1_1;
            x0.register0((ChannelPromise)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$900(AbstractUnsafe x0, ChannelPromise x1) {
            void var1_1;
            x0.doClose0((ChannelPromise)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1000(AbstractUnsafe x0, boolean x1) {
            void var1_1;
            x0.fireChannelInactiveAndDeregister((boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1100(AbstractUnsafe x0, Runnable x1) {
            void var1_1;
            x0.invokeLater((Runnable)var1_1);
        }
    }
}

