/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ChannelInitializerExtension;
import io.netty.bootstrap.ServerBootstrapConfig;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.util.AttributeKey;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ServerBootstrap
extends AbstractBootstrap<ServerBootstrap, ServerChannel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerBootstrap.class);
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> childAttrs = new ConcurrentHashMap();
    private final ServerBootstrapConfig config = new ServerBootstrapConfig(this);
    private volatile EventLoopGroup childGroup;
    private volatile ChannelHandler childHandler;

    public ServerBootstrap() {
    }

    /*
     * WARNING - void declaration
     */
    private ServerBootstrap(ServerBootstrap bootstrap) {
        super(bootstrap);
        void var1_1;
        this.childGroup = bootstrap.childGroup;
        this.childHandler = bootstrap.childHandler;
        Map<ChannelOption<?>, Object> map = bootstrap.childOptions;
        synchronized (map) {
            this.childOptions.putAll(bootstrap.childOptions);
        }
        this.childAttrs.putAll(var1_1.childAttrs);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ServerBootstrap group(EventLoopGroup group) {
        void var1_1;
        void v0 = var1_1;
        return this.group((EventLoopGroup)v0, (EventLoopGroup)v0);
    }

    /*
     * WARNING - void declaration
     */
    public ServerBootstrap group(EventLoopGroup parentGroup, EventLoopGroup childGroup) {
        void var2_2;
        void var1_1;
        super.group((EventLoopGroup)var1_1);
        if (this.childGroup != null) {
            throw new IllegalStateException("childGroup set already");
        }
        this.childGroup = (EventLoopGroup)ObjectUtil.checkNotNull((Object)var2_2, (String)"childGroup");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public <T> ServerBootstrap childOption(ChannelOption<T> childOption, T value) {
        ObjectUtil.checkNotNull(childOption, (String)"childOption");
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            if (value == null) {
                this.childOptions.remove(childOption);
            } else {
                void var2_3;
                void var1_1;
                this.childOptions.put((ChannelOption<?>)var1_1, var2_3);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public <T> ServerBootstrap childAttr(AttributeKey<T> childKey, T value) {
        ObjectUtil.checkNotNull(childKey, (String)"childKey");
        if (value == null) {
            this.childAttrs.remove(childKey);
        } else {
            void var2_2;
            void var1_1;
            this.childAttrs.put((AttributeKey<?>)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ServerBootstrap childHandler(ChannelHandler childHandler) {
        void var1_1;
        this.childHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)var1_1, (String)"childHandler");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void init(Channel channel) {
        Iterator<ChannelInitializerExtension> iterator;
        ServerBootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        ServerBootstrap.setAttributes(channel, this.newAttributesArray());
        ChannelPipeline p = channel.pipeline();
        EventLoopGroup currentChildGroup = this.childGroup;
        ChannelHandler currentChildHandler = this.childHandler;
        Map.Entry[] currentChildOptions = ServerBootstrap.newOptionsArray(this.childOptions);
        Map.Entry[] currentChildAttrs = ServerBootstrap.newAttributesArray(this.childAttrs);
        Collection<ChannelInitializerExtension> extensions = this.getInitializerExtensions();
        iterator.addLast(new ChannelInitializer<Channel>(this, currentChildGroup, currentChildHandler, currentChildOptions, currentChildAttrs, extensions){
            final /* synthetic */ EventLoopGroup val$currentChildGroup;
            final /* synthetic */ ChannelHandler val$currentChildHandler;
            final /* synthetic */ Map.Entry[] val$currentChildOptions;
            final /* synthetic */ Map.Entry[] val$currentChildAttrs;
            final /* synthetic */ Collection val$extensions;
            final /* synthetic */ ServerBootstrap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$currentChildGroup = eventLoopGroup;
                this.val$currentChildHandler = channelHandler;
                this.val$currentChildOptions = entryArray;
                this.val$currentChildAttrs = entryArray2;
                this.val$extensions = collection;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void initChannel(Channel ch) {
                void var1_1;
                void var2_2;
                ChannelPipeline pipeline = ch.pipeline();
                ChannelHandler handler = this.this$0.config.handler();
                if (handler != null) {
                    void var3_3;
                    pipeline.addLast(new ChannelHandler[]{var3_3});
                }
                ch.eventLoop().execute(new Runnable(this, (ChannelPipeline)var2_2, (Channel)var1_1){
                    final /* synthetic */ ChannelPipeline val$pipeline;
                    final /* synthetic */ Channel val$ch;
                    final /* synthetic */ 1 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$pipeline = channelPipeline;
                        this.val$ch = channel;
                    }

                    @Override
                    public void run() {
                        this.val$pipeline.addLast(new ServerBootstrapAcceptor(this.val$ch, this.this$1.val$currentChildGroup, this.this$1.val$currentChildHandler, this.this$1.val$currentChildOptions, this.this$1.val$currentChildAttrs, this.this$1.val$extensions));
                    }
                });
            }
        });
        if (!extensions.isEmpty() && channel instanceof ServerChannel) {
            ServerChannel serverChannel = (ServerChannel)channel;
            for (ChannelInitializerExtension extension : extensions) {
                try {
                    extension.postInitializeServerListenerChannel(serverChannel);
                }
                catch (Exception e) {
                    void var3_4;
                    logger.warn("Exception thrown from postInitializeServerListenerChannel", (Throwable)var3_4);
                }
            }
        }
    }

    @Override
    public ServerBootstrap validate() {
        super.validate();
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        if (this.childGroup == null) {
            logger.warn("childGroup is not set. Using parentGroup instead.");
            this.childGroup = this.config.group();
        }
        return this;
    }

    @Override
    public ServerBootstrap clone() {
        return new ServerBootstrap(this);
    }

    @Deprecated
    public EventLoopGroup childGroup() {
        return this.childGroup;
    }

    final ChannelHandler childHandler() {
        return this.childHandler;
    }

    final Map<ChannelOption<?>, Object> childOptions() {
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            return ServerBootstrap.copiedMap(this.childOptions);
        }
    }

    final Map<AttributeKey<?>, Object> childAttrs() {
        return ServerBootstrap.copiedMap(this.childAttrs);
    }

    public final ServerBootstrapConfig config() {
        return this.config;
    }

    private static class ServerBootstrapAcceptor
    extends ChannelInboundHandlerAdapter {
        private final EventLoopGroup childGroup;
        private final ChannelHandler childHandler;
        private final Map.Entry<ChannelOption<?>, Object>[] childOptions;
        private final Map.Entry<AttributeKey<?>, Object>[] childAttrs;
        private final Runnable enableAutoReadTask;
        private final Collection<ChannelInitializerExtension> extensions;

        /*
         * WARNING - void declaration
         */
        ServerBootstrapAcceptor(Channel channel, EventLoopGroup childGroup, ChannelHandler childHandler, Map.Entry<ChannelOption<?>, Object>[] childOptions, Map.Entry<AttributeKey<?>, Object>[] childAttrs, Collection<ChannelInitializerExtension> extensions) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.childGroup = var2_2;
            this.childHandler = var3_3;
            this.childOptions = childOptions;
            this.childAttrs = childAttrs;
            this.extensions = extensions;
            this.enableAutoReadTask = new Runnable(this, (Channel)var1_1){
                final /* synthetic */ Channel val$channel;
                final /* synthetic */ ServerBootstrapAcceptor this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$channel = channel;
                }

                @Override
                public void run() {
                    this.val$channel.config().setAutoRead(true);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Channel child = (Channel)((Object)msg);
            child.pipeline().addLast(this.childHandler);
            AbstractBootstrap.setChannelOptions(child, this.childOptions, logger);
            AbstractBootstrap.setAttributes(child, this.childAttrs);
            if (!this.extensions.isEmpty()) {
                for (ChannelInitializerExtension extension : this.extensions) {
                    try {
                        extension.postInitializeServerChildChannel(child);
                    }
                    catch (Exception e) {
                        void var3_5;
                        logger.warn("Exception thrown from postInitializeServerChildChannel", (Throwable)var3_5);
                    }
                }
            }
            try {
                this.childGroup.register(child).addListener(new ChannelFutureListener(this, child){
                    final /* synthetic */ Channel val$child;
                    final /* synthetic */ ServerBootstrapAcceptor this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$child = channel;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            void var1_1;
                            ServerBootstrapAcceptor.access$200(this.val$child, var1_1.cause());
                        }
                    }
                });
                return;
            }
            catch (Throwable t) {
                void var2_3;
                void var1_1;
                ServerBootstrapAcceptor.forceClose((Channel)var1_1, (Throwable)var2_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private static void forceClose(Channel child, Throwable t) {
            void var1_1;
            Channel channel;
            child.unsafe().closeForcibly();
            logger.warn("Failed to register an accepted channel: {}", (Object)channel, (Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            void var2_2;
            void var1_1;
            ChannelConfig config = ctx.channel().config();
            if (config.isAutoRead()) {
                void var3_3;
                var3_3.setAutoRead(false);
                ctx.channel().eventLoop().schedule(this.enableAutoReadTask, 1L, TimeUnit.SECONDS);
            }
            var1_1.fireExceptionCaught((Throwable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$200(Channel x0, Throwable x1) {
            void var1_1;
            ServerBootstrapAcceptor.forceClose(x0, (Throwable)var1_1);
        }
    }
}

