/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.ChannelInitializerExtension;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;

abstract class ChannelInitializerExtensions {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializerExtensions.class);
    private static volatile ChannelInitializerExtensions implementation;

    private ChannelInitializerExtensions() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ChannelInitializerExtensions getExtensions() {
        ChannelInitializerExtensions channelInitializerExtensions;
        ChannelInitializerExtensions impl = implementation;
        if (impl != null) return channelInitializerExtensions;
        Class<ChannelInitializerExtensions> clazz = ChannelInitializerExtensions.class;
        synchronized (ChannelInitializerExtensions.class) {
            impl = implementation;
            if (impl != null) {
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return impl;
            }
            Object extensionProp = SystemPropertyUtil.get((String)"io.netty.bootstrap.extensions");
            logger.debug("-Dio.netty.bootstrap.extensions: {}", extensionProp);
            if ("serviceload".equalsIgnoreCase((String)extensionProp)) {
                extensionProp = new ServiceLoadingExtensions(true);
            } else {
                channelInitializerExtensions = "log".equalsIgnoreCase((String)((Object)channelInitializerExtensions)) ? new ServiceLoadingExtensions(false) : new EmptyExtensions();
            }
            implementation = channelInitializerExtensions;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return channelInitializerExtensions;
        }
    }

    abstract Collection<ChannelInitializerExtension> extensions(ClassLoader var1);

    private static final class ServiceLoadingExtensions
    extends ChannelInitializerExtensions {
        private final boolean loadAndCache;
        private WeakReference<ClassLoader> classLoader;
        private Collection<ChannelInitializerExtension> extensions;

        /*
         * WARNING - void declaration
         */
        ServiceLoadingExtensions(boolean loadAndCache) {
            void var1_1;
            this.loadAndCache = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final synchronized Collection<ChannelInitializerExtension> extensions(ClassLoader cl) {
            ClassLoader configured = this.classLoader == null ? null : (ClassLoader)this.classLoader.get();
            if (configured == null || configured != cl) {
                void var2_2;
                void var1_1;
                Collection<ChannelInitializerExtension> loaded = ServiceLoadingExtensions.serviceLoadExtensions(this.loadAndCache, cl);
                this.classLoader = new WeakReference<void>(var1_1);
                this.extensions = this.loadAndCache ? var2_2 : Collections.emptyList();
            }
            return this.extensions;
        }

        /*
         * WARNING - void declaration
         */
        private static Collection<ChannelInitializerExtension> serviceLoadExtensions(boolean load, ClassLoader cl) {
            boolean bl;
            Object object;
            ArrayList<void> extensions = new ArrayList<void>();
            object = ServiceLoader.load(ChannelInitializerExtension.class, (ClassLoader)object);
            object = ((ServiceLoader)object).iterator();
            while (object.hasNext()) {
                void var3_3;
                ChannelInitializerExtension extension = (ChannelInitializerExtension)object.next();
                extensions.add(var3_3);
            }
            if (!extensions.isEmpty()) {
                void var2_2;
                Collections.sort(extensions, new Comparator<ChannelInitializerExtension>(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final int compare(ChannelInitializerExtension a, ChannelInitializerExtension b) {
                        void var2_2;
                        return Double.compare(a.priority(), var2_2.priority());
                    }
                });
                logger.info("ServiceLoader {}(s) {}: {}", new Object[]{ChannelInitializerExtension.class.getSimpleName(), load ? "registered" : "detected", extensions});
                return Collections.unmodifiableList(var2_2);
            }
            logger.debug("ServiceLoader {}(s) {}: []", (Object)ChannelInitializerExtension.class.getSimpleName(), (Object)(bl ? "registered" : "detected"));
            return Collections.emptyList();
        }
    }

    private static final class EmptyExtensions
    extends ChannelInitializerExtensions {
        private EmptyExtensions() {
        }

        @Override
        final Collection<ChannelInitializerExtension> extensions(ClassLoader cl) {
            return Collections.emptyList();
        }
    }
}

