/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.BootstrapConfig;
import io.netty.bootstrap.ChannelInitializerExtension;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;

public class Bootstrap
extends AbstractBootstrap<Bootstrap, Channel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private final BootstrapConfig config = new BootstrapConfig(this);
    private ExternalAddressResolver externalResolver;
    private volatile boolean disableResolver;
    private volatile SocketAddress remoteAddress;

    public Bootstrap() {
    }

    /*
     * WARNING - void declaration
     */
    private Bootstrap(Bootstrap bootstrap) {
        super(bootstrap);
        void var1_1;
        this.externalResolver = bootstrap.externalResolver;
        this.disableResolver = bootstrap.disableResolver;
        this.remoteAddress = var1_1.remoteAddress;
    }

    /*
     * WARNING - void declaration
     */
    public Bootstrap resolver(AddressResolverGroup<?> resolver) {
        void var1_1;
        this.externalResolver = resolver == null ? null : new ExternalAddressResolver((AddressResolverGroup<?>)var1_1);
        this.disableResolver = false;
        return this;
    }

    public Bootstrap disableResolver() {
        this.externalResolver = null;
        this.disableResolver = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Bootstrap remoteAddress(SocketAddress remoteAddress) {
        void var1_1;
        this.remoteAddress = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Bootstrap remoteAddress(String inetHost, int inetPort) {
        void var2_2;
        void var1_1;
        this.remoteAddress = InetSocketAddress.createUnresolved((String)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Bootstrap remoteAddress(InetAddress inetHost, int inetPort) {
        void var2_2;
        void var1_1;
        this.remoteAddress = new InetSocketAddress((InetAddress)var1_1, (int)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture connect() {
        void var1_1;
        this.validate();
        SocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress not set");
        }
        return this.doResolveAndConnect((SocketAddress)var1_1, this.config.localAddress());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture connect(String inetHost, int inetPort) {
        void var2_2;
        void var1_1;
        return this.connect(InetSocketAddress.createUnresolved((String)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture connect(InetAddress inetHost, int inetPort) {
        void var2_2;
        void var1_1;
        return this.connect(new InetSocketAddress((InetAddress)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture connect(SocketAddress remoteAddress) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)remoteAddress, (String)"remoteAddress");
        this.validate();
        return this.doResolveAndConnect((SocketAddress)var1_1, this.config.localAddress());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)remoteAddress, (String)"remoteAddress");
        this.validate();
        return this.doResolveAndConnect((SocketAddress)var1_1, (SocketAddress)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture doResolveAndConnect(SocketAddress remoteAddress, SocketAddress localAddress) {
        void var2_2;
        void var1_1;
        void var3_3;
        ChannelFuture regFuture = this.initAndRegister();
        Channel channel = regFuture.channel();
        if (regFuture.isDone()) {
            if (!regFuture.isSuccess()) {
                return regFuture;
            }
            return this.doResolveAndConnect0(channel, remoteAddress, localAddress, channel.newPromise());
        }
        AbstractBootstrap.PendingRegistrationPromise promise = new AbstractBootstrap.PendingRegistrationPromise(channel);
        var3_3.addListener(new ChannelFutureListener(this, promise, channel, (SocketAddress)var1_1, (SocketAddress)var2_2){
            final /* synthetic */ AbstractBootstrap.PendingRegistrationPromise val$promise;
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ SocketAddress val$remoteAddress;
            final /* synthetic */ SocketAddress val$localAddress;
            final /* synthetic */ Bootstrap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = pendingRegistrationPromise;
                this.val$channel = channel;
                this.val$remoteAddress = socketAddress;
                this.val$localAddress = socketAddress2;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                Throwable cause = future.cause();
                if (cause != null) {
                    void var1_1;
                    this.val$promise.setFailure((Throwable)var1_1);
                    return;
                }
                this.val$promise.registered();
                Bootstrap.access$000(this.this$0, this.val$channel, this.val$remoteAddress, this.val$localAddress, this.val$promise);
            }
        });
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture doResolveAndConnect0(Channel channel, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        try {
            void var3_4;
            void var1_1;
            void var2_2;
            AddressResolver resolver;
            if (this.disableResolver) {
                Bootstrap.doConnect(remoteAddress, localAddress, promise);
                return promise;
            }
            EventLoop eventLoop = channel.eventLoop();
            try {
                resolver = ExternalAddressResolver.getOrDefault(this.externalResolver).getResolver((EventExecutor)eventLoop);
            }
            catch (Throwable cause) {
                channel.close();
                return promise.setFailure(cause);
            }
            if (!resolver.isSupported((SocketAddress)cause) || resolver.isResolved((SocketAddress)cause)) {
                Bootstrap.doConnect((SocketAddress)cause, localAddress, promise);
                return promise;
            }
            Future resolveFuture = resolver.resolve((SocketAddress)cause);
            if (resolveFuture.isDone()) {
                Throwable resolveFailureCause = resolveFuture.cause();
                if (resolveFailureCause != null) {
                    channel.close();
                    promise.setFailure(resolveFailureCause);
                } else {
                    Bootstrap.doConnect((SocketAddress)resolveFuture.getNow(), localAddress, promise);
                }
                return promise;
            }
            var2_2.addListener((GenericFutureListener)new FutureListener<SocketAddress>(this, (Channel)var1_1, promise, (SocketAddress)var3_4){
                final /* synthetic */ Channel val$channel;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ SocketAddress val$localAddress;
                final /* synthetic */ Bootstrap this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$channel = channel;
                    this.val$promise = channelPromise;
                    this.val$localAddress = socketAddress;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(Future<SocketAddress> future) throws Exception {
                    void var1_1;
                    if (future.cause() != null) {
                        this.val$channel.close();
                        this.val$promise.setFailure(future.cause());
                        return;
                    }
                    Bootstrap.access$100((SocketAddress)var1_1.getNow(), this.val$localAddress, this.val$promise);
                }
            });
        }
        catch (Throwable cause) {
            promise.tryFailure(cause);
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    private static void doConnect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise connectPromise) {
        void var2_2;
        SocketAddress socketAddress;
        void var3_3;
        void var1_1;
        Channel channel = connectPromise.channel();
        channel.eventLoop().execute(new Runnable((SocketAddress)var1_1, (Channel)var3_3, socketAddress, (ChannelPromise)var2_2){
            final /* synthetic */ SocketAddress val$localAddress;
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ SocketAddress val$remoteAddress;
            final /* synthetic */ ChannelPromise val$connectPromise;
            {
                this.val$localAddress = socketAddress;
                this.val$channel = channel;
                this.val$remoteAddress = socketAddress2;
                this.val$connectPromise = channelPromise;
            }

            @Override
            public final void run() {
                if (this.val$localAddress == null) {
                    this.val$channel.connect(this.val$remoteAddress, this.val$connectPromise);
                } else {
                    this.val$channel.connect(this.val$remoteAddress, this.val$localAddress, this.val$connectPromise);
                }
                this.val$connectPromise.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void init(Channel channel) {
        Object object = channel.pipeline();
        object.addLast(this.config.handler());
        Bootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        Bootstrap.setAttributes(channel, this.newAttributesArray());
        Collection<ChannelInitializerExtension> extensions = this.getInitializerExtensions();
        if (!extensions.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                ChannelInitializerExtension extension = (ChannelInitializerExtension)object.next();
                try {
                    extension.postInitializeClientChannel(channel);
                }
                catch (Exception e) {
                    void var3_4;
                    logger.warn("Exception thrown from postInitializeClientChannel", (Throwable)var3_4);
                }
            }
        }
    }

    @Override
    public Bootstrap validate() {
        super.validate();
        if (this.config.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
        return this;
    }

    @Override
    public Bootstrap clone() {
        return new Bootstrap(this);
    }

    /*
     * WARNING - void declaration
     */
    public Bootstrap clone(EventLoopGroup group) {
        void var2_2;
        void var1_1;
        Bootstrap bs = new Bootstrap(this);
        new Bootstrap(this).group = var1_1;
        return var2_2;
    }

    public final BootstrapConfig config() {
        return this.config;
    }

    final SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    final AddressResolverGroup<?> resolver() {
        if (this.disableResolver) {
            return null;
        }
        return ExternalAddressResolver.getOrDefault(this.externalResolver);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelFuture access$000(Bootstrap x0, Channel x1, SocketAddress x2, SocketAddress x3, ChannelPromise x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.doResolveAndConnect0((Channel)var1_1, (SocketAddress)var2_2, (SocketAddress)var3_3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(SocketAddress x0, SocketAddress x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        Bootstrap.doConnect(x0, (SocketAddress)var1_1, (ChannelPromise)var2_2);
    }

    static final class ExternalAddressResolver {
        final AddressResolverGroup<SocketAddress> resolverGroup;

        /*
         * WARNING - void declaration
         */
        ExternalAddressResolver(AddressResolverGroup<?> resolverGroup) {
            void var1_1;
            this.resolverGroup = var1_1;
        }

        static AddressResolverGroup<SocketAddress> getOrDefault(ExternalAddressResolver externalResolver) {
            ExternalAddressResolver externalAddressResolver;
            if (externalResolver == null) {
                externalResolver = DefaultAddressResolverGroup.INSTANCE;
                return externalResolver;
            }
            return externalAddressResolver.resolverGroup;
        }
    }
}

