/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ChannelFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.AttributeKey;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.util.Map;

public abstract class AbstractBootstrapConfig<B extends AbstractBootstrap<B, C>, C extends Channel> {
    protected final B bootstrap;

    /*
     * WARNING - void declaration
     */
    protected AbstractBootstrapConfig(B bootstrap) {
        void var1_1;
        this.bootstrap = (AbstractBootstrap)ObjectUtil.checkNotNull((Object)var1_1, (String)"bootstrap");
    }

    public final SocketAddress localAddress() {
        return ((AbstractBootstrap)this.bootstrap).localAddress();
    }

    public final ChannelFactory<? extends C> channelFactory() {
        return ((AbstractBootstrap)this.bootstrap).channelFactory();
    }

    public final ChannelHandler handler() {
        return ((AbstractBootstrap)this.bootstrap).handler();
    }

    public final Map<ChannelOption<?>, Object> options() {
        return ((AbstractBootstrap)this.bootstrap).options();
    }

    public final Map<AttributeKey<?>, Object> attrs() {
        return ((AbstractBootstrap)this.bootstrap).attrs();
    }

    public final EventLoopGroup group() {
        return ((AbstractBootstrap)this.bootstrap).group();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        ChannelHandler handler;
        Map<AttributeKey<?>, Object> attrs;
        Map<ChannelOption<?>, Object> options;
        SocketAddress localAddress;
        ChannelFactory<C> factory;
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName((Object)this)).append('(');
        EventLoopGroup group = this.group();
        if (group != null) {
            buf.append("group: ").append(StringUtil.simpleClassName((Object)group)).append(", ");
        }
        if ((factory = this.channelFactory()) != null) {
            buf.append("channelFactory: ").append(factory).append(", ");
        }
        if ((localAddress = this.localAddress()) != null) {
            buf.append("localAddress: ").append(localAddress).append(", ");
        }
        if (!(options = this.options()).isEmpty()) {
            buf.append("options: ").append(options).append(", ");
        }
        if (!(attrs = this.attrs()).isEmpty()) {
            buf.append("attrs: ").append(attrs).append(", ");
        }
        if ((handler = this.handler()) != null) {
            void var2_2;
            buf.append("handler: ").append(var2_2).append(", ");
        }
        StringBuilder stringBuilder = buf;
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '(') {
            buf.append(')');
        } else {
            StringBuilder stringBuilder2 = buf;
            stringBuilder2.setCharAt(stringBuilder2.length() - 2, ')');
            StringBuilder stringBuilder3 = buf;
            stringBuilder3.setLength(stringBuilder3.length() - 1);
        }
        return var1_1.toString();
    }
}

