/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrapConfig;
import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ChannelInitializerExtension;
import io.netty.bootstrap.ChannelInitializerExtensions;
import io.netty.bootstrap.FailedChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractBootstrap<B extends AbstractBootstrap<B, C>, C extends Channel>
implements Cloneable {
    private static final Map.Entry<ChannelOption<?>, Object>[] EMPTY_OPTION_ARRAY = new Map.Entry[0];
    private static final Map.Entry<AttributeKey<?>, Object>[] EMPTY_ATTRIBUTE_ARRAY = new Map.Entry[0];
    volatile EventLoopGroup group;
    private volatile ChannelFactory<? extends C> channelFactory;
    private volatile SocketAddress localAddress;
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new ConcurrentHashMap();
    private volatile ChannelHandler handler;
    private volatile ClassLoader extensionsClassLoader;

    AbstractBootstrap() {
    }

    /*
     * WARNING - void declaration
     */
    AbstractBootstrap(AbstractBootstrap<B, C> bootstrap) {
        void var1_1;
        this.group = bootstrap.group;
        this.channelFactory = bootstrap.channelFactory;
        this.handler = bootstrap.handler;
        this.localAddress = bootstrap.localAddress;
        Map<ChannelOption<?>, Object> map = bootstrap.options;
        synchronized (map) {
            this.options.putAll(bootstrap.options);
        }
        this.attrs.putAll(bootstrap.attrs);
        this.extensionsClassLoader = var1_1.extensionsClassLoader;
    }

    /*
     * WARNING - void declaration
     */
    public B group(EventLoopGroup group) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)group, (String)"group");
        if (this.group != null) {
            throw new IllegalStateException("group set already");
        }
        this.group = var1_1;
        return this.self();
    }

    private B self() {
        return (B)this;
    }

    /*
     * WARNING - void declaration
     */
    public B channel(Class<? extends C> channelClass) {
        void var1_1;
        return this.channelFactory(new ReflectiveChannelFactory((Class)ObjectUtil.checkNotNull((Object)var1_1, (String)"channelClass")));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public B channelFactory(ChannelFactory<? extends C> channelFactory) {
        void var1_1;
        ObjectUtil.checkNotNull(channelFactory, (String)"channelFactory");
        if (this.channelFactory != null) {
            throw new IllegalStateException("channelFactory set already");
        }
        this.channelFactory = var1_1;
        return this.self();
    }

    /*
     * WARNING - void declaration
     */
    public B channelFactory(io.netty.channel.ChannelFactory<? extends C> channelFactory) {
        void var1_1;
        return this.channelFactory((ChannelFactory<? extends C>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public B localAddress(SocketAddress localAddress) {
        void var1_1;
        this.localAddress = var1_1;
        return this.self();
    }

    /*
     * WARNING - void declaration
     */
    public B localAddress(int inetPort) {
        void var1_1;
        return this.localAddress(new InetSocketAddress((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public B localAddress(String inetHost, int inetPort) {
        void var2_2;
        void var1_1;
        return this.localAddress(SocketUtils.socketAddress((String)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public B localAddress(InetAddress inetHost, int inetPort) {
        void var2_2;
        void var1_1;
        return this.localAddress(new InetSocketAddress((InetAddress)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public <T> B option(ChannelOption<T> option, T value) {
        ObjectUtil.checkNotNull(option, (String)"option");
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            if (value == null) {
                this.options.remove(option);
            } else {
                void var2_3;
                void var1_1;
                this.options.put((ChannelOption<?>)var1_1, var2_3);
            }
        }
        return this.self();
    }

    /*
     * WARNING - void declaration
     */
    public <T> B attr(AttributeKey<T> key, T value) {
        ObjectUtil.checkNotNull(key, (String)"key");
        if (value == null) {
            this.attrs.remove(key);
        } else {
            void var2_2;
            void var1_1;
            this.attrs.put((AttributeKey<?>)var1_1, var2_2);
        }
        return this.self();
    }

    /*
     * WARNING - void declaration
     */
    public B extensionsClassLoader(ClassLoader classLoader) {
        void var1_1;
        this.extensionsClassLoader = var1_1;
        return this.self();
    }

    public B validate() {
        if (this.group == null) {
            throw new IllegalStateException("group not set");
        }
        if (this.channelFactory == null) {
            throw new IllegalStateException("channel or channelFactory not set");
        }
        return this.self();
    }

    public abstract B clone();

    public ChannelFuture register() {
        this.validate();
        return this.initAndRegister();
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture bind() {
        void var1_1;
        this.validate();
        SocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            throw new IllegalStateException("localAddress not set");
        }
        return this.doBind((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture bind(int inetPort) {
        void var1_1;
        return this.bind(new InetSocketAddress((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture bind(String inetHost, int inetPort) {
        void var2_2;
        void var1_1;
        return this.bind(SocketUtils.socketAddress((String)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture bind(InetAddress inetHost, int inetPort) {
        void var2_2;
        void var1_1;
        return this.bind(new InetSocketAddress((InetAddress)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture bind(SocketAddress localAddress) {
        void var1_1;
        this.validate();
        return this.doBind((SocketAddress)ObjectUtil.checkNotNull((Object)var1_1, (String)"localAddress"));
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture doBind(SocketAddress localAddress) {
        void var1_1;
        void var3_3;
        void var2_2;
        ChannelFuture regFuture = this.initAndRegister();
        Channel channel = regFuture.channel();
        if (regFuture.cause() != null) {
            return regFuture;
        }
        if (regFuture.isDone()) {
            ChannelPromise promise = channel.newPromise();
            AbstractBootstrap.doBind0(regFuture, channel, localAddress, promise);
            return promise;
        }
        PendingRegistrationPromise promise = new PendingRegistrationPromise(channel);
        regFuture.addListener(new ChannelFutureListener(this, promise, (ChannelFuture)var2_2, (Channel)var3_3, (SocketAddress)var1_1){
            final /* synthetic */ PendingRegistrationPromise val$promise;
            final /* synthetic */ ChannelFuture val$regFuture;
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ SocketAddress val$localAddress;
            final /* synthetic */ AbstractBootstrap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = pendingRegistrationPromise;
                this.val$regFuture = channelFuture;
                this.val$channel = channel;
                this.val$localAddress = socketAddress;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                Throwable cause = future.cause();
                if (cause != null) {
                    void var1_1;
                    this.val$promise.setFailure((Throwable)var1_1);
                    return;
                }
                this.val$promise.registered();
                AbstractBootstrap.access$000(this.val$regFuture, this.val$channel, this.val$localAddress, this.val$promise);
            }
        });
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    final ChannelFuture initAndRegister() {
        void var2_3;
        Channel channel = null;
        try {
            channel = (Channel)this.channelFactory.newChannel();
            this.init(channel);
        }
        catch (Throwable t) {
            if (channel != null) {
                channel.unsafe().closeForcibly();
                return new DefaultChannelPromise(channel, (EventExecutor)GlobalEventExecutor.INSTANCE).setFailure(t);
            }
            return new DefaultChannelPromise(new FailedChannel(), (EventExecutor)GlobalEventExecutor.INSTANCE).setFailure(t);
        }
        ChannelFuture regFuture = this.config().group().register(channel);
        if (regFuture.cause() != null) {
            if (channel.isRegistered()) {
                channel.close();
            } else {
                void var1_1;
                var1_1.unsafe().closeForcibly();
            }
        }
        return var2_3;
    }

    abstract void init(Channel var1) throws Exception;

    /*
     * WARNING - void declaration
     */
    Collection<ChannelInitializerExtension> getInitializerExtensions() {
        void var1_1;
        ClassLoader loader = this.extensionsClassLoader;
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return ChannelInitializerExtensions.getExtensions().extensions((ClassLoader)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void doBind0(ChannelFuture regFuture, Channel channel, SocketAddress localAddress, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        ChannelFuture channelFuture;
        channel.eventLoop().execute(new Runnable((Channel)var1_1, (SocketAddress)var2_2, (ChannelPromise)var3_3){
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ SocketAddress val$localAddress;
            final /* synthetic */ ChannelPromise val$promise;
            {
                this.val$channel = channel;
                this.val$localAddress = socketAddress;
                this.val$promise = channelPromise;
            }

            @Override
            public final void run() {
                if (channelFuture.isSuccess()) {
                    this.val$channel.bind(this.val$localAddress, this.val$promise).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
                    return;
                }
                this.val$promise.setFailure(channelFuture.cause());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public B handler(ChannelHandler handler) {
        void var1_1;
        this.handler = (ChannelHandler)ObjectUtil.checkNotNull((Object)var1_1, (String)"handler");
        return this.self();
    }

    @Deprecated
    public final EventLoopGroup group() {
        return this.group;
    }

    public abstract AbstractBootstrapConfig<B, C> config();

    final Map.Entry<ChannelOption<?>, Object>[] newOptionsArray() {
        return AbstractBootstrap.newOptionsArray(this.options);
    }

    static Map.Entry<ChannelOption<?>, Object>[] newOptionsArray(Map<ChannelOption<?>, Object> options) {
        Map<ChannelOption<?>, Object> map = options;
        synchronized (map) {
            Map<ChannelOption<?>, Object> map2;
            return new LinkedHashMap(map2).entrySet().toArray(EMPTY_OPTION_ARRAY);
        }
    }

    final Map.Entry<AttributeKey<?>, Object>[] newAttributesArray() {
        return AbstractBootstrap.newAttributesArray(this.attrs0());
    }

    static Map.Entry<AttributeKey<?>, Object>[] newAttributesArray(Map<AttributeKey<?>, Object> attributes) {
        return attributes.entrySet().toArray(EMPTY_ATTRIBUTE_ARRAY);
    }

    final Map<ChannelOption<?>, Object> options0() {
        return this.options;
    }

    final Map<AttributeKey<?>, Object> attrs0() {
        return this.attrs;
    }

    final SocketAddress localAddress() {
        return this.localAddress;
    }

    final ChannelFactory<? extends C> channelFactory() {
        return this.channelFactory;
    }

    final ChannelHandler handler() {
        return this.handler;
    }

    final Map<ChannelOption<?>, Object> options() {
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            return AbstractBootstrap.copiedMap(this.options);
        }
    }

    final Map<AttributeKey<?>, Object> attrs() {
        return AbstractBootstrap.copiedMap(this.attrs);
    }

    static <K, V> Map<K, V> copiedMap(Map<K, V> map) {
        Map<K, V> map2;
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(map2));
    }

    static void setAttributes(Channel channel, Map.Entry<AttributeKey<?>, Object>[] attrs) {
        Map.Entry<AttributeKey<?>, Object>[] entryArray = attrs;
        int n = attrs.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry<AttributeKey<?>, Object> e = entryArray[i];
            AttributeKey<?> key = e.getKey();
            channel.attr(key).set(e.getValue());
        }
    }

    static void setChannelOptions(Channel channel, Map.Entry<ChannelOption<?>, Object>[] options, InternalLogger logger) {
        Map.Entry<ChannelOption<?>, Object>[] entryArray = options;
        int n = options.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry<ChannelOption<?>, Object> e = entryArray[i];
            AbstractBootstrap.setChannelOption(channel, e.getKey(), e.getValue(), logger);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void setChannelOption(Channel channel, ChannelOption<?> option, Object value, InternalLogger logger) {
        try {
            if (!channel.config().setOption(option, value)) {
                logger.warn("Unknown channel option '{}' for channel '{}'", option, (Object)channel);
            }
            return;
        }
        catch (Throwable t) {
            Channel channel2;
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", new Object[]{var1_1, var2_2, channel2, t});
            return;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName((Object)this)).append('(').append(this.config()).append(')');
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ChannelFuture x0, Channel x1, SocketAddress x2, ChannelPromise x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        AbstractBootstrap.doBind0(x0, (Channel)var1_1, (SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    static final class PendingRegistrationPromise
    extends DefaultChannelPromise {
        private volatile boolean registered;

        /*
         * WARNING - void declaration
         */
        PendingRegistrationPromise(Channel channel) {
            super((Channel)var1_1);
            void var1_1;
        }

        final void registered() {
            this.registered = true;
        }

        @Override
        protected final EventExecutor executor() {
            if (this.registered) {
                return super.executor();
            }
            return GlobalEventExecutor.INSTANCE;
        }
    }
}

