/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver.bundled;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Landroidx/sqlite/driver/bundled/NativeLibraryLoader;", "", "<init>", "()V", "loadLibrary", "", "name", "", "getResourceName", "sqlite-bundled"})
@SourceDebugExtension(value={"SMAP\nNativeLibraryLoader.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeLibraryLoader.jvm.kt\nandroidx/sqlite/driver/bundled/NativeLibraryLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class NativeLibraryLoader {
    public static final NativeLibraryLoader INSTANCE = new NativeLibraryLoader();

    private NativeLibraryLoader() {
    }

    public final void loadLibrary(String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NativeLibraryLoader nativeLibraryLoader = this;
        synchronized (nativeLibraryLoader) {
            try {
                System.loadLibrary(name);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Object object;
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                Object object2;
                String string6;
                CopyOption[] copyOptionArray;
                block60: {
                    block59: {
                        String string7;
                        block58: {
                            block57: {
                                copyOptionArray = name;
                                string7 = System.getProperty("os.name");
                                if (string7 == null) break block57;
                                string6 = string7;
                                Locale locale = Locale.US;
                                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                                String string8 = string6.toLowerCase(locale);
                                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
                                string7 = string8;
                                if (string8 != null) break block58;
                            }
                            throw new IllegalStateException("Cannot read osName".toString());
                        }
                        object2 = string7;
                        string5 = System.getProperty("os.arch");
                        if (string5 == null) break block59;
                        string6 = string5;
                        Locale locale = Locale.US;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                        String string9 = string6.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
                        string5 = string9;
                        if (string9 != null) break block60;
                    }
                    throw new IllegalStateException("Cannot read osArch".toString());
                }
                string6 = string5;
                if (StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)"linux", (boolean)false, (int)2, null)) {
                    string4 = "linux";
                } else if (StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)"mac", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)"osx", (boolean)false, (int)2, null)) {
                    string4 = "osx";
                } else if (StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)"windows", (boolean)false, (int)2, null)) {
                    string4 = "windows";
                } else {
                    throw new IllegalStateException(("Unsupported operating system: " + (String)object2).toString());
                }
                String string10 = string4;
                if (Intrinsics.areEqual((Object)string6, (Object)"aarch64")) {
                    string3 = "arm64";
                } else if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"arm", (boolean)false, (int)2, null)) {
                    string3 = StringsKt.contains$default((CharSequence)string6, (CharSequence)"64", (boolean)false, (int)2, null) ? "arm64" : "arm32";
                } else if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"64", (boolean)false, (int)2, null)) {
                    string3 = "x64";
                } else if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"86", (boolean)false, (int)2, null)) {
                    string3 = "x86";
                } else {
                    throw new IllegalStateException(("Unsupported architecture: " + string6).toString());
                }
                string6 = string3;
                string6 = string10 + '_' + string6;
                switch (string10) {
                    case "osx": 
                    case "linux": {
                        string2 = "lib";
                        break;
                    }
                    case "windows": {
                        string2 = "";
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Unsupported operating system: " + (String)object2).toString());
                    }
                }
                String string11 = string2;
                int n = -1;
                switch (string10.hashCode()) {
                    case 110356: {
                        if (string10.equals("osx")) {
                            n = 1;
                        }
                        break;
                    }
                    case 102977780: {
                        if (string10.equals("linux")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1349493379: {
                        if (string10.equals("windows")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        string = "so";
                        break;
                    }
                    case 1: {
                        string = "dylib";
                        break;
                    }
                    case 3: {
                        string = "dll";
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Unsupported operating system: " + (String)object2).toString());
                    }
                }
                String string12 = string;
                String libResourceName = "natives/" + string6 + '/' + string11 + (String)copyOptionArray + '.' + string12;
                object2 = object = Files.createTempFile("androidx_" + (String)object, null, new FileAttribute[0]);
                object.toFile().deleteOnExit();
                Path libTempCopy = object;
                ClassLoader classLoader = NativeLibraryLoader.class.getClassLoader();
                Intrinsics.checkNotNull((Object)classLoader);
                object = classLoader.getResourceAsStream(libResourceName);
                object2 = null;
                try {
                    Object resourceStream = (InputStream)object;
                    if (resourceStream == null) {
                        resourceStream = "Cannot find a suitable SQLite binary for " + System.getProperty("os.name") + " | " + System.getProperty("os.arch") + ". Please file a bug at https://issuetracker.google.com/issues/new?component=460784";
                        throw new IllegalStateException(resourceStream.toString());
                    }
                    CopyOption[] copyOptionArray2 = copyOptionArray;
                    CopyOption[] copyOptionArray3 = new CopyOption[1];
                    copyOptionArray = copyOptionArray3;
                    copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy((InputStream)copyOptionArray2, libTempCopy, copyOptionArray);
                }
                catch (Throwable throwable) {
                    try {
                        copyOptionArray = throwable;
                        object2 = throwable;
                        throw copyOptionArray;
                    }
                    catch (Throwable throwable2) {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                        throw throwable2;
                    }
                }
                CloseableKt.closeFinally((Closeable)object, null);
                System.load(libTempCopy.toFile().getCanonicalPath());
                return;
            }
        }
    }
}

