/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.util;

import com.github.sardine.model.ObjectFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SardineUtil {
    private static final String[] SUPPORTED_DATE_FORMATS;
    public static final String CUSTOM_NAMESPACE_PREFIX = "s";
    public static final String CUSTOM_NAMESPACE_URI = "SAR:";
    public static final String DEFAULT_NAMESPACE_PREFIX = "d";
    public static final String DEFAULT_NAMESPACE_URI = "DAV:";
    private static final JAXBContext JAXB_CONTEXT;
    private static final DocumentBuilderFactory factory;
    private static final List<ThreadLocal<SimpleDateFormat>> DATETIME_FORMATS;

    private SardineUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static Date parseDate(String value) {
        void var1_1;
        if (value == null) {
            return null;
        }
        Date date = null;
        for (int i = 0; i < DATETIME_FORMATS.size(); ++i) {
            ThreadLocal<SimpleDateFormat> format = DATETIME_FORMATS.get(i);
            SimpleDateFormat sdf = format.get();
            if (sdf == null) {
                void var3_3;
                sdf = new SimpleDateFormat(SUPPORTED_DATE_FORMATS[i], Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                var3_3.set(sdf);
            }
            try {
                date = sdf.parse(value);
                break;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return var1_1;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream in) throws IOException {
        Unmarshaller unmarshaller = SardineUtil.createUnmarshaller();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            try {
                reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (SAXException sAXException) {}
            try {
                reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXException sAXException) {}
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException sAXException) {}
            try {
                reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (SAXException sAXException) {}
            new SAXSource(reader, new InputSource((InputStream)in));
            in = unmarshaller.unmarshal$280a531d();
        }
        catch (SAXException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
                catch (JAXBException e2) {
                    IOException iOException;
                    void var2_5;
                    IOException failure = new IOException("Not a valid DAV response");
                    failure.initCause((Throwable)var2_5);
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                if (!(unmarshaller instanceof Closeable)) throw throwable;
                try {
                    void var1_2;
                    ((Closeable)var1_2).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        if (!(unmarshaller instanceof Closeable)) return (T)in;
        try {
            ((Closeable)unmarshaller).close();
            return (T)in;
        }
        catch (IOException iOException) {}
        return (T)in;
    }

    /*
     * WARNING - void declaration
     */
    private static Unmarshaller createUnmarshaller() throws IOException {
        try {
            return JAXB_CONTEXT.createUnmarshaller();
        }
        catch (JAXBException e) {
            void var0;
            throw new IOException(e.getMessage(), (Throwable)var0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Marshaller createMarshaller() throws IOException {
        try {
            return JAXB_CONTEXT.createMarshaller();
        }
        catch (JAXBException e) {
            void var0;
            throw new IOException(e.getMessage(), (Throwable)var0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Document createDocument() {
        void var0;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return var0.newDocument();
    }

    /*
     * WARNING - void declaration
     */
    public static String toXml(Object jaxbElement) throws IOException {
        Object object;
        Object writer = new StringWriter();
        try {
            SardineUtil.createMarshaller();
        }
        catch (JAXBException e) {
            void var0_1;
            throw new RuntimeException(e.getMessage(), (Throwable)var0_1);
        }
        return ((StringWriter)object).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<QName, String> toQName(Map<String, String> setProps) {
        void var1_1;
        Object object;
        if (setProps == null) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap(setProps.size());
        for (Map.Entry entry : object.entrySet()) {
            result.put(SardineUtil.createQNameWithCustomNamespace((String)entry.getKey()), entry.getValue());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<QName> toQName(List<String> removeProps) {
        void var1_1;
        Iterator<String> iterator;
        if (removeProps == null) {
            return Collections.emptyList();
        }
        ArrayList<QName> result = new ArrayList<QName>(removeProps.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            String entry = (String)iterator.next();
            result.add(SardineUtil.createQNameWithCustomNamespace((String)var2_2));
        }
        return var1_1;
    }

    public static QName toQName(Element element) {
        Element element2;
        String string = element.getNamespaceURI();
        if (string == null) {
            return new QName(DEFAULT_NAMESPACE_URI, element.getLocalName(), DEFAULT_NAMESPACE_PREFIX);
        }
        if (element.getPrefix() == null) {
            return new QName(element.getNamespaceURI(), element.getLocalName());
        }
        return new QName(element.getNamespaceURI(), element.getLocalName(), element2.getPrefix());
    }

    public static QName createQNameWithCustomNamespace(String key) {
        String string;
        return new QName(CUSTOM_NAMESPACE_URI, string, CUSTOM_NAMESPACE_PREFIX);
    }

    public static QName createQNameWithDefaultNamespace(String key) {
        String string;
        return new QName(DEFAULT_NAMESPACE_URI, string, DEFAULT_NAMESPACE_PREFIX);
    }

    public static Element createElement(QName key) {
        QName qName;
        return SardineUtil.createDocument().createElementNS(key.getNamespaceURI(), key.getPrefix() + ":" + qName.getLocalPart());
    }

    /*
     * WARNING - void declaration
     */
    public static Element createElement(Element parent, QName key) {
        void var1_1;
        return parent.getOwnerDocument().createElementNS(key.getNamespaceURI(), key.getPrefix() + ":" + var1_1.getLocalPart());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_1;
        SUPPORTED_DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "EEE, dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ssZ", "EEE MMM dd HH:mm:ss zzz yyyy", "EEEEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMMM d HH:mm:ss yyyy"};
        factory = DocumentBuilderFactory.newInstance();
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)SardineUtil.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        ArrayList l = new ArrayList(SUPPORTED_DATE_FORMATS.length);
        for (int i = 0; i < SUPPORTED_DATE_FORMATS.length; ++i) {
            l.add(new ThreadLocal());
        }
        DATETIME_FORMATS = Collections.unmodifiableList(var0_1);
    }
}

