/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.report;

import com.github.sardine.DavResource;
import com.github.sardine.model.Limit;
import com.github.sardine.model.Multistatus;
import com.github.sardine.model.Prop;
import com.github.sardine.model.Response;
import com.github.sardine.model.SyncCollection;
import com.github.sardine.report.SardineReport;
import com.github.sardine.util.SardineUtil;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SyncCollectionReport
extends SardineReport<Result> {
    private static final Logger log = Logger.getLogger(SardineReport.class.getName());
    private final String syncToken;
    private final SyncLevel syncLevel;
    private final Set<QName> properties;
    private final Integer limit;

    /*
     * WARNING - void declaration
     */
    public SyncCollectionReport(String syncToken, SyncLevel syncLevel, Set<QName> properties, Integer limit) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.syncToken = var1_1;
        this.syncLevel = var2_2;
        this.properties = var3_3;
        this.limit = limit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object toJaxb() {
        void var1_1;
        Prop prop = new Prop();
        List<Element> any = prop.getAny();
        Iterator<QName> iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            QName entry = iterator.next();
            any.add(SardineUtil.createElement(entry));
        }
        SyncCollection syncCollection = new SyncCollection();
        syncCollection.setSyncToken(this.syncToken == null ? "" : this.syncToken);
        syncCollection.setSyncLevel(this.syncLevel.toString());
        syncCollection.setProp((Prop)var1_1);
        if (this.limit != null && this.limit > 0) {
            Limit l = new Limit();
            l.setNresults(BigInteger.valueOf(this.limit.intValue()));
            syncCollection.setLimit(l);
        }
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Result fromMultistatus(Multistatus multistatus) {
        void var1_1;
        void var3_3;
        Iterator iterator;
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Response response = (Response)iterator.next();
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException uRISyntaxException) {
                log.warning(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return new Result((List<DavResource>)var3_3, var1_1.getSyncToken());
    }

    public static enum SyncLevel {
        LEVEL_1("1"),
        LEVEL_INFINITY("infinite");

        private final String value;

        /*
         * WARNING - void declaration
         */
        private SyncLevel(String value) {
            void var3_3;
            this.value = var3_3;
        }

        public final String toString() {
            return this.value;
        }
    }

    public static class Result {
        private final List<DavResource> resources;
        private final String syncToken;

        /*
         * WARNING - void declaration
         */
        Result(List<DavResource> resources, String syncToken) {
            void var2_2;
            void var1_1;
            this.resources = var1_1;
            this.syncToken = var2_2;
        }

        public List<DavResource> getResources() {
            return this.resources;
        }

        public String getSyncToken() {
            return this.syncToken;
        }
    }
}

