/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.impl;

import com.github.sardine.DavAce;
import com.github.sardine.DavAcl;
import com.github.sardine.DavPrincipal;
import com.github.sardine.DavQuota;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.Version;
import com.github.sardine.impl.SardineRedirectStrategy;
import com.github.sardine.impl.handler.ExistsResponseHandler;
import com.github.sardine.impl.handler.LockResponseHandler;
import com.github.sardine.impl.handler.MultiStatusResponseHandler;
import com.github.sardine.impl.handler.VoidResponseHandler;
import com.github.sardine.impl.io.ContentLengthInputStream;
import com.github.sardine.impl.io.HttpMethodReleaseInputStream;
import com.github.sardine.impl.methods.HttpAcl;
import com.github.sardine.impl.methods.HttpCopy;
import com.github.sardine.impl.methods.HttpLock;
import com.github.sardine.impl.methods.HttpMkCol;
import com.github.sardine.impl.methods.HttpMove;
import com.github.sardine.impl.methods.HttpPropFind;
import com.github.sardine.impl.methods.HttpPropPatch;
import com.github.sardine.impl.methods.HttpReport;
import com.github.sardine.impl.methods.HttpSearch;
import com.github.sardine.impl.methods.HttpUnlock;
import com.github.sardine.model.Ace;
import com.github.sardine.model.Acl;
import com.github.sardine.model.Allprop;
import com.github.sardine.model.Displayname;
import com.github.sardine.model.Exclusive;
import com.github.sardine.model.Group;
import com.github.sardine.model.Lockinfo;
import com.github.sardine.model.Lockscope;
import com.github.sardine.model.Locktype;
import com.github.sardine.model.Multistatus;
import com.github.sardine.model.ObjectFactory;
import com.github.sardine.model.Owner;
import com.github.sardine.model.PrincipalCollectionSet;
import com.github.sardine.model.PrincipalURL;
import com.github.sardine.model.Prop;
import com.github.sardine.model.Propertyupdate;
import com.github.sardine.model.Propfind;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.QuotaAvailableBytes;
import com.github.sardine.model.QuotaUsedBytes;
import com.github.sardine.model.Remove;
import com.github.sardine.model.Resourcetype;
import com.github.sardine.model.Response;
import com.github.sardine.model.SearchRequest;
import com.github.sardine.model.Write;
import com.github.sardine.report.SardineReport;
import com.github.sardine.util.SardineUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.w3c.dom.Element;

public class SardineImpl
implements Sardine {
    private static final Logger log = Logger.getLogger(DavResource.class.getName());
    private static final String UTF_8 = "UTF-8";
    protected CloseableHttpClient client;
    private HttpClientBuilder builder;
    protected HttpClientContext context = HttpClientContext.create();

    public SardineImpl() {
        this.builder = this.configure(null, null);
        this.client = this.builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public SardineImpl(String bearerAuth) {
        void var1_1;
        BasicHeader bearerHeader = new BasicHeader("Authorization", "Bearer " + bearerAuth);
        this.builder = this.configure(null, null).setDefaultHeaders(Collections.singletonList(var1_1));
        this.client = this.builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public SardineImpl(String username, String password) {
        void var2_2;
        void var1_1;
        this.builder = this.configure(null, this.createDefaultCredentialsProvider((String)var1_1, (String)var2_2, null, null));
        this.client = this.builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public SardineImpl(String username, String password, ProxySelector selector) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.builder = this.configure((ProxySelector)var3_3, this.createDefaultCredentialsProvider((String)var1_1, (String)var2_2, null, null));
        this.client = this.builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public SardineImpl(HttpClientBuilder builder) {
        void var1_1;
        this.builder = var1_1;
        this.client = this.builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public SardineImpl(HttpClientBuilder builder, String username, String password) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.builder = var1_1;
        this.setCredentials((String)var2_2, (String)var3_3);
        this.client = this.builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCredentials(String username, String password) {
        void var2_2;
        void var1_1;
        this.setCredentials((String)var1_1, (String)var2_2, "", "");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCredentials(String username, String password, String domain, String workstation) {
        void var3_3;
        void var2_2;
        void var1_1;
        SardineImpl sardineImpl = this;
        sardineImpl.setCredentials(sardineImpl.createDefaultCredentialsProvider((String)var1_1, (String)var2_2, (String)var3_3, workstation));
    }

    /*
     * WARNING - void declaration
     */
    public void setCredentials(CredentialsProvider provider) {
        void var1_1;
        this.context.setCredentialsProvider((CredentialsProvider)var1_1);
        this.context.setAttribute("http.auth.target-scope", (Object)new AuthState());
    }

    /*
     * WARNING - void declaration
     */
    private CredentialsProvider createDefaultCredentialsProvider(String username, String password, String domain, String workstation) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        if (username != null) {
            void var2_2;
            void var1_1;
            void var3_3;
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(username, password, workstation, domain));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Digest"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Negotiate"), (Credentials)new NTCredentials(username, password, workstation, (String)var3_3));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Kerberos"), (Credentials)new UsernamePasswordCredentials((String)var1_1, (String)var2_2));
        }
        return provider;
    }

    @Override
    public void enableCompression() {
        this.builder.addInterceptorLast((HttpRequestInterceptor)new RequestAcceptEncoding());
        this.builder.addInterceptorLast((HttpResponseInterceptor)new ResponseContentEncoding());
        this.client = this.builder.build();
    }

    @Override
    public void disableCompression() {
        this.builder.disableContentCompression();
        this.client = this.builder.build();
    }

    @Override
    public void ignoreCookies() {
        this.builder.setDefaultCookieSpecRegistry((Lookup)new Lookup<CookieSpecProvider>(this){
            final /* synthetic */ SardineImpl this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public CookieSpecProvider lookup(String name) {
                return new IgnoreSpecProvider();
            }
        });
        this.client = this.builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enablePreemptiveAuthentication(String hostname) {
        void var1_1;
        this.enablePreemptiveAuthentication((String)var1_1, -1, -1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enablePreemptiveAuthentication(URL url) {
        void var3_4;
        void var1_2;
        void var2_3;
        void httpPort2;
        int httpPort2;
        String host = url.getHost();
        int port = url.getPort();
        String protocol = url.getProtocol();
        if ("https".equals(protocol)) {
            httpPort2 = -1;
        } else if ("http".equals(httpPort2)) {
            int httpsPort;
            httpPort2 = httpsPort;
            httpsPort = -1;
        } else {
            throw new IllegalArgumentException("Unsupported protocol " + (String)httpPort2);
        }
        this.enablePreemptiveAuthentication((String)var2_3, (int)var1_2, (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enablePreemptiveAuthentication(String hostname, int httpPort, int httpsPort) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.enablePreemptiveAuthentication((String)var1_1, (int)var2_2, (int)var3_3, Consts.ISO_8859_1);
    }

    /*
     * WARNING - void declaration
     */
    public void enablePreemptiveAuthentication(String hostname, int httpPort, int httpsPort, Charset credentialsCharset) {
        void var3_3;
        void var1_1;
        void var2_2;
        AuthCache cache = this.context.getAuthCache();
        if (cache == null) {
            cache = new BasicAuthCache();
            this.context.setAuthCache(cache);
        }
        BasicScheme basicAuth = new BasicScheme(credentialsCharset);
        cache.put(new HttpHost(hostname, (int)var2_2, "http"), (AuthScheme)basicAuth);
        cache.put(new HttpHost((String)var1_1, (int)var3_3, "https"), (AuthScheme)basicAuth);
    }

    @Override
    public void disablePreemptiveAuthentication() {
        this.context.removeAttribute("http.auth.auth-cache");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> getResources(String url) throws IOException {
        void var1_1;
        return this.list((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> list(String url) throws IOException {
        void var1_1;
        return this.list((String)var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> list(String url, int depth) throws IOException {
        void var2_2;
        void var1_1;
        return this.list((String)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> list(String url, int depth, boolean allProp) throws IOException {
        void var2_2;
        void var1_1;
        if (allProp) {
            void var3_4;
            Propfind body = new Propfind();
            body.setAllprop(new Allprop());
            return this.propfind(url, depth, (Propfind)var3_4);
        }
        return this.list((String)var1_1, (int)var2_2, Collections.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> list(String url, int depth, Set<QName> props) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        Propfind body = new Propfind();
        Prop prop = new Prop();
        ObjectFactory objectFactory = new ObjectFactory();
        prop.setGetcontentlength(objectFactory.createGetcontentlength());
        prop.setGetlastmodified(objectFactory.createGetlastmodified());
        prop.setCreationdate(objectFactory.createCreationdate());
        prop.setDisplayname(objectFactory.createDisplayname());
        prop.setGetcontenttype(objectFactory.createGetcontenttype());
        prop.setResourcetype(objectFactory.createResourcetype());
        prop.setGetetag(objectFactory.createGetetag());
        this.addCustomProperties(prop, (Set<QName>)var3_3);
        body.setProp(prop);
        return this.propfind((String)var1_1, (int)var2_2, body);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> propfind(String url, int depth, Set<QName> props) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        Propfind body = new Propfind();
        Prop prop = new Prop();
        this.addCustomProperties(prop, (Set<QName>)var3_3);
        body.setProp(prop);
        return this.propfind((String)var1_1, (int)var2_2, body);
    }

    private void addCustomProperties(Prop prop, Set<QName> props) {
        Iterator iterator;
        List<Element> any = prop.getAny();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            Element element = SardineUtil.createElement(qName);
            any.add((Element)((Object)qName));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<DavResource> propfind(String url, int depth, Propfind body) throws IOException {
        void var2_3;
        Iterator iterator;
        Object entity = new HttpPropFind(url);
        entity.setDepth(depth < 0 ? "infinity" : Integer.toString(depth));
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        entity = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = ((Multistatus)entity).getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Response response = (Response)iterator.next();
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException uRISyntaxException) {
                void var3_4;
                log.warning(String.format("Ignore resource with invalid URI %s", var3_4.getHref().get(0)));
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T report(String url, int depth, SardineReport<T> report) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        HttpReport entity = new HttpReport(url);
        entity.setDepth(depth < 0 ? "infinity" : Integer.toString((int)var2_2));
        entity.setEntity((HttpEntity)new StringEntity(report.toXml(), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        return var3_3.fromMultistatus((Multistatus)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> search(String url, String language, String query) throws IOException {
        void var2_2;
        Iterator iterator;
        Object search = new HttpSearch(url);
        language = new SearchRequest((String)language, query);
        String body = SardineUtil.toXml(language);
        search.setEntity((HttpEntity)new StringEntity(body, UTF_8));
        search = this.execute((HttpRequestBase)search, new MultiStatusResponseHandler());
        List<Response> responses = ((Multistatus)search).getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Response response = (Response)iterator.next();
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException uRISyntaxException) {
                void var3_3;
                log.warning(String.format("Ignore resource with invalid URI %s", var3_3.getHref().get(0)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCustomProps(String url, Map<String, String> set, List<String> remove) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.patch((String)var1_1, SardineUtil.toQName((Map<String, String>)var2_2), SardineUtil.toQName((List<String>)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps) throws IOException {
        void var2_2;
        void var1_1;
        return this.patch((String)var1_1, (Map<QName, String>)var2_2, Collections.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps, List<QName> removeProps) throws IOException {
        void var3_3;
        void var1_1;
        Iterator iterator;
        ArrayList<Element> setPropsElements = new ArrayList<Element>();
        for (Map.Entry entry : iterator.entrySet()) {
            Element element = SardineUtil.createElement((QName)entry.getKey());
            element.setTextContent((String)entry.getValue());
            setPropsElements.add(element);
        }
        return this.patch((String)var1_1, setPropsElements, (List<QName>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavResource> patch(String url, List<Element> setProps, List<QName> removeProps) throws IOException {
        void var1_1;
        Iterator<Object> iterator;
        HttpPropPatch entity = new HttpPropPatch(url);
        Propertyupdate body = new Propertyupdate();
        com.github.sardine.model.Set set = new com.github.sardine.model.Set();
        body.getRemoveOrSet().add(set);
        Prop prop = new Prop();
        List<Element> any = prop.getAny();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            any.add(element);
        }
        set.setProp(prop);
        if (!removeProps.isEmpty()) {
            Remove remove = new Remove();
            body.getRemoveOrSet().add(remove);
            prop = new Prop();
            any = prop.getAny();
            for (QName qName : removeProps) {
                void var3_3;
                Element element2 = SardineUtil.createElement(qName);
                any.add((Element)var3_3);
            }
            remove.setProp(prop);
        }
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)var1_1, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException uRISyntaxException) {
                log.warning(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String lock(String url) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        HttpLock entity = new HttpLock(url);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype((Locktype)var3_3);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(var2_2), UTF_8));
        return this.execute((HttpRequestBase)var1_1, new LockResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String refreshLock(String url, String token, String file) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        HttpLock entity = new HttpLock(url);
        entity.setHeader("If", "<" + (String)var3_3 + "> (<" + (String)var2_2 + ">)");
        return this.execute((HttpRequestBase)var1_1, new LockResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unlock(String url, String token) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        HttpUnlock entity = new HttpUnlock(url, token);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        var2_2.setLocktype((Locktype)var3_3);
        this.execute((HttpRequestBase)var1_1, new VoidResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAcl(String url, List<DavAce> aces) throws IOException {
        void var1_1;
        void var3_3;
        Iterator iterator;
        HttpAcl entity = new HttpAcl(url);
        Acl body = new Acl();
        body.setAce(new ArrayList<Ace>());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            DavAce davAce = (DavAce)iterator.next();
            if (davAce.getInherited() != null || davAce.isProtected()) continue;
            Ace ace = davAce.toModel();
            body.getAce().add(ace);
        }
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(var3_3), UTF_8));
        this.execute((HttpRequestBase)var1_1, new VoidResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DavAcl getAcl(String url) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        Object entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setOwner(new Owner());
        prop.setGroup(new Group());
        prop.setAcl(new Acl());
        body.setProp((Prop)var3_3);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(var2_2), UTF_8));
        entity = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = ((Multistatus)entity).getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavAcl((Response)var1_1.get(0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DavQuota getQuota(String url) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        Object entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setQuotaAvailableBytes(new QuotaAvailableBytes());
        prop.setQuotaUsedBytes(new QuotaUsedBytes());
        body.setProp((Prop)var3_3);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(var2_2), UTF_8));
        entity = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = ((Multistatus)entity).getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavQuota((Response)var1_1.get(0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<DavPrincipal> getPrincipals(String url) throws IOException {
        void var2_2;
        Iterator iterator;
        Object entity = new HttpPropFind(url);
        entity.setDepth("1");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setDisplayname(new Displayname());
        prop.setResourcetype(new Resourcetype());
        prop.setPrincipalURL(new PrincipalURL());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        entity = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = ((Multistatus)entity).getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<DavPrincipal> collections = new ArrayList<DavPrincipal>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Response r = (Response)iterator.next();
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : r.getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getResourcetype() == null || propstat.getProp().getResourcetype().getPrincipal() == null) continue;
                collections.add(new DavPrincipal(DavPrincipal.PrincipalType.HREF, r.getHref().get(0), propstat.getProp().getDisplayname().getContent().get(0)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> getPrincipalCollectionSet(String url) throws IOException {
        void var2_2;
        Iterator iterator;
        Object entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setPrincipalCollectionSet(new PrincipalCollectionSet());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        entity = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = ((Multistatus)entity).getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<String> collections = new ArrayList<String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Iterator<Propstat> iterator2;
            Response r = (Response)iterator.next();
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : ((Response)((Object)iterator2)).getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getPrincipalCollectionSet() == null || propstat.getProp().getPrincipalCollectionSet().getHref() == null) continue;
                collections.addAll(propstat.getProp().getPrincipalCollectionSet().getHref());
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ContentLengthInputStream get(String url) throws IOException {
        void var1_1;
        return this.get((String)var1_1, Collections.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ContentLengthInputStream get(String url, Map<String, String> headers) throws IOException {
        void var3_3;
        void var1_1;
        Iterator iterator;
        ArrayList<BasicHeader> list = new ArrayList<BasicHeader>();
        for (Map.Entry h : iterator.entrySet()) {
            list.add(new BasicHeader((String)h.getKey(), (String)h.getValue()));
        }
        return this.get((String)var1_1, (List<Header>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ContentLengthInputStream get(String url, List<Header> headers) throws IOException {
        HttpGet get = new HttpGet(url);
        headers = headers.iterator();
        while (headers.hasNext()) {
            Header header = (Header)headers.next();
            get.addHeader(header);
        }
        HttpResponse response = this.execute((HttpRequestBase)get);
        VoidResponseHandler handler = new VoidResponseHandler();
        try {
            void var3_4;
            var3_4.handleResponse(response);
            return new ContentLengthInputStream(new HttpMethodReleaseInputStream(response), response.getEntity().getContentLength());
        }
        catch (IOException ex) {
            void var2_3;
            void var1_1;
            var1_1.abort();
            throw var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String url, byte[] data) throws IOException {
        void var2_2;
        void var1_1;
        this.put((String)var1_1, (byte[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String url, byte[] data, String contentType) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrayEntity entity = new ByteArrayEntity(data);
        this.put((String)var1_1, (HttpEntity)var2_2, (String)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String url, InputStream dataStream) throws IOException {
        void var2_2;
        void var1_1;
        this.put((String)var1_1, (InputStream)var2_2, (String)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String url, InputStream dataStream, String contentType) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.put((String)var1_1, (InputStream)var2_2, (String)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String url, InputStream dataStream, String contentType, boolean expectContinue) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.put((String)var1_1, (InputStream)var2_2, (String)var3_3, expectContinue, -1L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String url, InputStream dataStream, String contentType, boolean expectContinue, long contentLength) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        InputStreamEntity entity = new InputStreamEntity(dataStream, contentLength);
        this.put((String)var1_1, (HttpEntity)var2_2, (String)var3_3, expectContinue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String url, InputStream dataStream, Map<String, String> headers) throws IOException {
        void var2_2;
        void var1_1;
        Iterator iterator;
        ArrayList<Header> list = new ArrayList<Header>();
        for (Map.Entry h : iterator.entrySet()) {
            list.add((Header)new BasicHeader((String)h.getKey(), (String)h.getValue()));
        }
        this.put((String)var1_1, (InputStream)var2_2, list);
    }

    /*
     * WARNING - void declaration
     */
    public void put(String url, InputStream dataStream, List<Header> headers) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        InputStreamEntity entity = new InputStreamEntity(dataStream, -1L);
        this.put((String)var1_1, (HttpEntity)var2_2, (List<Header>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void put(String url, HttpEntity entity, String contentType, boolean expectContinue) throws IOException {
        void var2_2;
        void var1_1;
        ArrayList<Header> headers = new ArrayList<Header>();
        if (contentType != null) {
            void var3_3;
            headers.add((Header)new BasicHeader("Content-Type", (String)var3_3));
        }
        if (expectContinue) {
            headers.add((Header)new BasicHeader("Expect", "100-continue"));
        }
        this.put((String)var1_1, (HttpEntity)var2_2, headers);
    }

    /*
     * WARNING - void declaration
     */
    public void put(String url, HttpEntity entity, List<Header> headers) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.put((String)var1_1, (HttpEntity)var2_2, (List<Header>)var3_3, new VoidResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    public <T> T put(String url, HttpEntity entity, List<Header> headers, ResponseHandler<T> handler) throws IOException {
        HttpPut put = new HttpPut(url);
        put.setEntity(entity);
        headers = headers.iterator();
        while (headers.hasNext()) {
            Header header = (Header)headers.next();
            put.addHeader(header);
        }
        if (entity.getContentType() == null && !put.containsHeader("Content-Type")) {
            put.addHeader("Content-Type", HTTP.DEF_CONTENT_CHARSET.name());
        }
        try {
            return this.execute((HttpRequestBase)put, handler);
        }
        catch (HttpResponseException httpResponseException) {
            void var3_3;
            HttpResponseException e = httpResponseException;
            if (httpResponseException.getStatusCode() == 417) {
                void var2_2;
                put.removeHeaders("Expect");
                if (var2_2.isRepeatable()) {
                    void var1_1;
                    return this.execute((HttpRequestBase)var1_1, handler);
                }
            }
            throw var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String url, File localFile, String contentType) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.put((String)var1_1, (File)var2_2, (String)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(String url, File localFile, String contentType, boolean expectContinue) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        FileEntity content = new FileEntity(localFile);
        this.put((String)var1_1, (HttpEntity)var2_2, (String)var3_3, expectContinue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void delete(String url) throws IOException {
        void var1_1;
        HttpDelete delete = new HttpDelete(url);
        this.execute((HttpRequestBase)var1_1, new VoidResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void move(String sourceUrl, String destinationUrl) throws IOException {
        void var2_2;
        void var1_1;
        this.move((String)var1_1, (String)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void move(String sourceUrl, String destinationUrl, boolean overwrite) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        HttpMove move = new HttpMove(sourceUrl, (String)var2_2, (boolean)var3_3);
        this.execute((HttpRequestBase)var1_1, new VoidResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copy(String sourceUrl, String destinationUrl) throws IOException {
        void var2_2;
        void var1_1;
        this.copy((String)var1_1, (String)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copy(String sourceUrl, String destinationUrl, boolean overwrite) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        HttpCopy copy = new HttpCopy(sourceUrl, (String)var2_2, (boolean)var3_3);
        this.execute((HttpRequestBase)var1_1, new VoidResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createDirectory(String url) throws IOException {
        void var1_1;
        HttpMkCol mkcol = new HttpMkCol(url);
        this.execute((HttpRequestBase)var1_1, new VoidResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean exists(String url) throws IOException {
        void var1_1;
        HttpHead head = new HttpHead(url);
        return this.execute((HttpRequestBase)var1_1, new ExistsResponseHandler());
    }

    /*
     * WARNING - void declaration
     */
    protected <T> T execute(HttpRequestBase request, ResponseHandler<T> responseHandler) throws IOException {
        void var2_2;
        void var1_1;
        SardineImpl sardineImpl = this;
        return sardineImpl.execute(sardineImpl.context, (HttpRequestBase)var1_1, (ResponseHandler<T>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        void var1_1;
        SardineImpl sardineImpl = this;
        return (HttpResponse)sardineImpl.execute(sardineImpl.context, (HttpRequestBase)var1_1, null);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T execute(HttpClientContext context, HttpRequestBase request, ResponseHandler<T> responseHandler) throws IOException {
        BasicHttpContext requestLocalContext;
        block6: {
            requestLocalContext = new BasicHttpContext((HttpContext)context);
            if (responseHandler == null) break block6;
            responseHandler = this.client.execute((HttpUriRequest)request, (ResponseHandler)responseHandler, (HttpContext)requestLocalContext);
            context.setAttribute("http.user-token", requestLocalContext.getAttribute("http.user-token"));
            return (T)responseHandler;
        }
        try {
            responseHandler = this.client.execute((HttpUriRequest)request, (HttpContext)requestLocalContext);
        }
        catch (HttpResponseException httpResponseException) {
            try {
                responseHandler = httpResponseException;
                throw httpResponseException;
                catch (IOException e) {
                    void var3_5;
                    void var2_2;
                    var2_2.abort();
                    throw var3_5;
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.setAttribute("http.user-token", requestLocalContext.getAttribute("http.user-token"));
                throw throwable;
            }
        }
        context.setAttribute("http.user-token", requestLocalContext.getAttribute("http.user-token"));
        return (T)responseHandler;
    }

    @Override
    public void shutdown() throws IOException {
        this.client.close();
    }

    /*
     * WARNING - void declaration
     */
    protected HttpClientBuilder configure(ProxySelector selector, CredentialsProvider credentials) {
        void var1_1;
        void var3_3;
        void var2_2;
        Registry<ConnectionSocketFactory> schemeRegistry = this.createDefaultSchemeRegistry();
        HttpClientConnectionManager cm = this.createDefaultConnectionManager(schemeRegistry);
        String version = Version.getSpecification();
        if (version == null) {
            version = "UNAVAILABLE";
        }
        SardineImpl sardineImpl = this;
        return HttpClients.custom().setUserAgent("Sardine/" + version).setDefaultCredentialsProvider((CredentialsProvider)var2_2).setRedirectStrategy((RedirectStrategy)this.createDefaultRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().setExpectContinueEnabled(false).build()).setConnectionManager((HttpClientConnectionManager)var3_3).setRoutePlanner(sardineImpl.createDefaultRoutePlanner((SchemePortResolver)sardineImpl.createDefaultSchemePortResolver(), (ProxySelector)var1_1));
    }

    protected DefaultSchemePortResolver createDefaultSchemePortResolver() {
        return new DefaultSchemePortResolver();
    }

    protected SardineRedirectStrategy createDefaultRedirectStrategy() {
        return new SardineRedirectStrategy();
    }

    protected Registry<ConnectionSocketFactory> createDefaultSchemeRegistry() {
        return RegistryBuilder.create().register("http", (Object)this.createDefaultSocketFactory()).register("https", (Object)this.createDefaultSecureSocketFactory()).build();
    }

    protected ConnectionSocketFactory createDefaultSocketFactory() {
        return PlainConnectionSocketFactory.getSocketFactory();
    }

    protected ConnectionSocketFactory createDefaultSecureSocketFactory() {
        return SSLConnectionSocketFactory.getSocketFactory();
    }

    /*
     * WARNING - void declaration
     */
    protected HttpClientConnectionManager createDefaultConnectionManager(Registry<ConnectionSocketFactory> schemeRegistry) {
        void var1_1;
        return new PoolingHttpClientConnectionManager((Registry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpRoutePlanner createDefaultRoutePlanner(SchemePortResolver resolver, ProxySelector selector) {
        void var2_2;
        void var1_1;
        return new SystemDefaultRoutePlanner((SchemePortResolver)var1_1, (ProxySelector)var2_2);
    }
}

