/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.ant.command;

import com.github.sardine.DavResource;
import com.github.sardine.ant.Command;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class RecursiveGet
extends Command {
    String serverUrl;
    String remoteDirectory;
    String localDirectory;
    boolean overwriteFiles = false;
    boolean skipExistingFiles = false;

    /*
     * WARNING - void declaration
     */
    @Override
    protected void validateAttributes() throws Exception {
        StringBuilder sb = new StringBuilder();
        if (this.serverUrl == null) {
            sb.append("[serverUrl] must not be null\n");
        }
        if (this.remoteDirectory == null) {
            sb.append("[remoteDirectory] must not be null\n");
        }
        if (this.localDirectory == null) {
            sb.append("[localDirectory] must not be null\n");
        }
        if (sb.length() > 0) {
            void var1_1;
            throw new IllegalArgumentException(sb.substring(0, var1_1.length() - 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute() throws Exception {
        Object object;
        URI remoteDirectoryUrl = new URI(this.serverUrl + '/').resolve(this.remoteDirectory);
        String remoteDirectoryPath = remoteDirectoryUrl.getPath();
        object = this.getSardine().list(((URI)object).toString(), -1);
        object = object.iterator();
        while (object.hasNext()) {
            InputStream ioStream;
            block5: {
                DavResource davResource = (DavResource)object.next();
                if (davResource.isDirectory()) continue;
                String filePathRelativeToRemoteDirectory = davResource.getPath().replace(remoteDirectoryPath, "");
                Path localFilePath = Paths.get(this.localDirectory, filePathRelativeToRemoteDirectory);
                if (this.skipExistingFiles && Files.exists(localFilePath, new LinkOption[0])) {
                    this.log("skipping download of already existing file " + localFilePath);
                    continue;
                }
                Files.createDirectories(localFilePath.getParent(), new FileAttribute[0]);
                this.log("downloading " + filePathRelativeToRemoteDirectory + " to " + localFilePath);
                ioStream = this.getSardine().get(this.serverUrl + davResource.getHref().toString());
                try {
                    if (this.overwriteFiles) {
                        Files.copy(ioStream, localFilePath, StandardCopyOption.REPLACE_EXISTING);
                        break block5;
                    }
                    Files.copy(ioStream, localFilePath, new CopyOption[0]);
                }
                catch (Throwable throwable) {
                    void var3_4;
                    var3_4.close();
                    throw throwable;
                }
            }
            ioStream.close();
        }
        this.log("downloaded files to " + this.localDirectory);
    }

    /*
     * WARNING - void declaration
     */
    public void setServerUrl(String serverUrl) {
        void var1_1;
        this.serverUrl = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoteDirectory(String remoteDirectory) {
        void var1_1;
        this.remoteDirectory = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setLocalDirectory(String localDirectory) {
        void var1_1;
        this.localDirectory = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setOverwriteFiles(boolean overwriteFiles) {
        void var1_1;
        this.overwriteFiles = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSkipExistingFiles(boolean skipExistingFiles) {
        void var1_1;
        this.skipExistingFiles = var1_1;
    }
}

