/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.ant.command;

import com.github.sardine.ant.Command;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ResourceUtils;

public class Put
extends Command {
    private String urlString;
    private URL dest;
    private List<FileSet> srcFileSets = new ArrayList<FileSet>();
    private File srcFile = null;
    private String contentType;
    private FilterSetCollection filterSets = new FilterSetCollection();
    private Vector<FilterChain> filterChains = new Vector();
    private String inputEncoding = null;
    private String outputEncoding = null;
    private boolean inMemoryFiltering = true;

    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute() throws Exception {
        void var1_1;
        long fileCounter = 0L;
        if (this.srcFile != null) {
            Put put = this;
            put.process(put.srcFile, this.dest, false);
            fileCounter = 1L;
        } else {
            String urlString = this.dest.toString();
            urlString = urlString.endsWith("/") ? urlString : urlString + '/';
            URL baseUrl = new URL(urlString);
            HashSet<URL> alreadyCreated = new HashSet<URL>();
            File currentParentDir = null;
            Iterator<FileSet> setIterator = this.srcFileSets.iterator();
            while (setIterator.hasNext()) {
                FileSet fileSet = setIterator.next();
                File dir = fileSet.getDir(this.getProject());
                this.log("putting from " + dir + " to " + baseUrl);
                String[] files = fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles();
                for (int idx = 0; idx < files.length; ++idx) {
                    String fileName = files[idx].replace('\\', '/');
                    File parentDir = new File(fileName).getParentFile();
                    if (parentDir == null || !parentDir.equals(currentParentDir)) {
                        this.checkOrCreateDir(baseUrl, parentDir, alreadyCreated);
                        currentParentDir = parentDir;
                    }
                    File srcFile = new File(dir, fileName);
                    URL destUrl = new URL(baseUrl, fileName);
                    boolean expectContinue = setIterator.hasNext() || idx + 1 < files.length;
                    this.process(srcFile, destUrl, expectContinue);
                    ++fileCounter;
                }
            }
        }
        this.log("putting of " + (long)var1_1 + " file(s) completed");
    }

    /*
     * WARNING - void declaration
     */
    private void checkOrCreateDir(URL baseUrl, File dir, Set<URL> createdDirs) throws IOException {
        void var2_2;
        URL dirUrl;
        if (dir != null) {
            this.checkOrCreateDir(baseUrl, dir.getParentFile(), createdDirs);
        }
        URL uRL = dirUrl = dir == null ? baseUrl : new URL(baseUrl, var2_2.getPath().replace('\\', '/'));
        if (createdDirs.contains(dirUrl)) {
            return;
        }
        if (!this.getSardine().exists(dirUrl.toString())) {
            void var1_1;
            void var3_3;
            this.log("creating directory " + dirUrl, 3);
            this.getSardine().createDirectory(dirUrl.toString());
            var3_3.add(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void process(File file, URL dest, boolean expectContinue) throws Exception {
        this.log("putting " + file + " to " + dest + " with expectContinue=" + expectContinue, 3);
        if (this.filterSets.hasFilters() || !this.filterChains.isEmpty()) {
            StringResource filteredResult;
            File tempFile = null;
            if (this.inMemoryFiltering) {
                filteredResult = new StringResource();
            } else {
                tempFile = File.createTempFile("filterResult", ".tmp");
                filteredResult = new FileResource(tempFile);
            }
            try {
                ResourceUtils.copyResource((Resource)new FileResource(file), (Resource)filteredResult, (FilterSetCollection)this.filterSets, this.filterChains, (boolean)false, (boolean)false, (boolean)false, (String)this.inputEncoding, (String)this.outputEncoding, (Project)this.getProject());
                this.getSardine().put(dest.toString(), filteredResult.getInputStream(), this.contentType, expectContinue);
            }
            finally {
                FileUtils.delete((File)tempFile);
            }
        } else {
            void var3_4;
            void var1_1;
            void var2_3;
            this.getSardine().put(var2_3.toString(), (File)var1_1, this.contentType, (boolean)var3_4);
        }
    }

    @Override
    protected void validateAttributes() throws Exception {
        if (this.urlString == null) {
            throw new NullPointerException("url must not be null");
        }
        this.dest = new URL(this.urlString);
        if (this.srcFile == null && this.srcFileSets.size() == 0) {
            throw new NullPointerException("Need to define either the file attribute or add a fileset.");
        }
        if (this.srcFile != null && !this.srcFile.isFile()) {
            throw new Exception(this.srcFile + " is not a file");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUrl(String urlString) {
        void var1_1;
        this.urlString = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFile(File file) {
        void var1_1;
        this.srcFile = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setContentType(String contentType) {
        void var1_1;
        this.contentType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addConfiguredFileset(FileSet value) {
        void var1_1;
        this.srcFileSets.add((FileSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public FilterSet createFilterSet() {
        void var1_1;
        FilterSet filterSet = new FilterSet();
        this.filterSets.addFilterSet(filterSet);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FilterChain createFilterChain() {
        void var1_1;
        FilterChain filterChain = new FilterChain();
        this.filterChains.addElement(filterChain);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncoding(String encoding) {
        this.inputEncoding = encoding;
        if (this.outputEncoding == null) {
            void var1_1;
            this.outputEncoding = var1_1;
        }
    }

    public String getEncoding() {
        return this.inputEncoding;
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputEncoding(String encoding) {
        void var1_1;
        this.outputEncoding = var1_1;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public boolean getInMemoryFiltering() {
        return this.inMemoryFiltering;
    }

    /*
     * WARNING - void declaration
     */
    public void setInMemoryFiltering(boolean inMemoryFiltering) {
        void var1_1;
        this.inMemoryFiltering = var1_1;
    }
}

