/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine;

import com.github.sardine.model.Creationdate;
import com.github.sardine.model.Displayname;
import com.github.sardine.model.Getcontentlanguage;
import com.github.sardine.model.Getcontentlength;
import com.github.sardine.model.Getcontenttype;
import com.github.sardine.model.Getetag;
import com.github.sardine.model.Getlastmodified;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.Report;
import com.github.sardine.model.Resourcetype;
import com.github.sardine.model.Response;
import com.github.sardine.model.SupportedReport;
import com.github.sardine.model.SupportedReportSet;
import com.github.sardine.util.SardineUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.http.ParseException;
import org.apache.http.message.BasicLineParser;
import org.w3c.dom.Element;

public class DavResource {
    private static final Logger log = Logger.getLogger(DavResource.class.getName());
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final long DEFAULT_CONTENT_LENGTH = -1L;
    public static final String HTTPD_UNIX_DIRECTORY_CONTENT_TYPE = "httpd/unix-directory";
    public static final int DEFAULT_STATUS_CODE = 200;
    private static final String SEPARATOR = "/";
    private final URI href;
    private final int status;
    private final DavProperties props;

    /*
     * WARNING - void declaration
     */
    protected DavResource(String href, Date creation, Date modified, String contentType, Long contentLength, String etag, String displayName, List<QName> resourceTypes, String contentLanguage, List<QName> supportedReports, Map<QName, String> customProps) throws URISyntaxException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.href = new URI((String)var1_1);
        this.status = 200;
        this.props = new DavProperties((Date)var2_2, (Date)var3_3, contentType, contentLength, etag, displayName, resourceTypes, contentLanguage, supportedReports, customProps);
    }

    /*
     * WARNING - void declaration
     */
    public DavResource(Response response) throws URISyntaxException {
        void var1_1;
        this.href = new URI(response.getHref().get(0));
        this.status = this.getStatusCode(response);
        this.props = new DavProperties((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int getStatusCode(Response response) {
        String status = response.getStatus();
        if (status == null || status.isEmpty()) {
            return 200;
        }
        try {
            void var1_1;
            return BasicLineParser.parseStatusLine((String)var1_1.getStatus(), null).getStatusCode();
        }
        catch (ParseException parseException) {
            void var2_2;
            log.warning(String.format("Failed to parse status line: %s", var2_2));
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getModifiedDate(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Getlastmodified glm;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null || (glm = propstat.getProp().getGetlastmodified()) == null || glm.getContent().size() != 1) continue;
            return var2_2.getContent().get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getCreationDate(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Creationdate gcd;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null || (gcd = propstat.getProp().getCreationdate()) == null || gcd.getContent().size() != 1) continue;
            return var2_2.getContent().get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getContentType(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            void var3_3;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null) continue;
            Resourcetype resourcetype = propstat.getProp().getResourcetype();
            if (resourcetype != null && var3_3.getCollection() != null) {
                return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE;
            }
            Getcontenttype gtt = propstat.getProp().getGetcontenttype();
            if (gtt == null || gtt.getContent().size() != 1) continue;
            return var2_2.getContent().get(0);
        }
        return DEFAULT_CONTENT_TYPE;
    }

    /*
     * WARNING - void declaration
     */
    private long getContentLength(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return -1L;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Getcontentlength gcl;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null || (gcl = propstat.getProp().getGetcontentlength()) == null || gcl.getContent().size() != 1) continue;
            try {
                return Long.parseLong(gcl.getContent().get(0));
            }
            catch (NumberFormatException numberFormatException) {
                void var2_2;
                log.warning(String.format("Failed to parse content length %s", var2_2.getContent().get(0)));
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private String getEtag(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Getetag e;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null || (e = propstat.getProp().getGetetag()) == null || e.getContent().size() != 1) continue;
            return var2_2.getContent().get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getContentLanguage(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            void var3_3;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null) continue;
            Resourcetype resourcetype = propstat.getProp().getResourcetype();
            if (resourcetype != null && var3_3.getCollection() != null) {
                return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE;
            }
            Getcontentlanguage gtl = propstat.getProp().getGetcontentlanguage();
            if (gtl == null || gtl.getContent().size() != 1) continue;
            return var2_2.getContent().get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getDisplayName(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Displayname dn;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null || (dn = propstat.getProp().getDisplayname()) == null || dn.getContent().size() != 1) continue;
            return var2_2.getContent().get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private List<QName> getResourceTypes(Response response) {
        void var2_2;
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QName> resourceTypes = new ArrayList<QName>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Iterator<Element> iterator2;
            Resourcetype rt;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null || (rt = propstat.getProp().getResourcetype()) == null) continue;
            if (rt.getCollection() != null) {
                resourceTypes.add(SardineUtil.createQNameWithDefaultNamespace("collection"));
            }
            if (rt.getPrincipal() != null) {
                resourceTypes.add(SardineUtil.createQNameWithDefaultNamespace("principal"));
            }
            for (Element element : ((Resourcetype)((Object)iterator2)).getAny()) {
                resourceTypes.add(SardineUtil.toQName(element));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private List<QName> getSupportedReports(Response response) {
        void var2_2;
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QName> supportedReports = new ArrayList<QName>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Iterator<SupportedReport> iterator2;
            SupportedReportSet srs;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null || (srs = propstat.getProp().getSupportedReportSet()) == null) continue;
            for (SupportedReport supportedReport : ((SupportedReportSet)((Object)iterator2)).getSupportedReport()) {
                Report report = supportedReport.getReport();
                if (report == null || report.getAny() == null) continue;
                supportedReports.add(SardineUtil.toQName(report.getAny()));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<QName, String> getCustomProps(Response response) {
        void var2_2;
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        HashMap<QName, String> customPropsMap = new HashMap<QName, String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object;
            Propstat propstat = (Propstat)iterator.next();
            if (propstat.getProp() == null) continue;
            object = ((Propstat)object).getProp().getAny();
            object = object.iterator();
            while (object.hasNext()) {
                Element element = (Element)object.next();
                customPropsMap.put(SardineUtil.toQName(element), element.getTextContent());
            }
        }
        return var2_2;
    }

    public int getStatusCode() {
        return this.status;
    }

    public Date getCreation() {
        return this.props.creation;
    }

    public Date getModified() {
        return this.props.modified;
    }

    public String getContentType() {
        return this.props.contentType;
    }

    public Long getContentLength() {
        return this.props.contentLength;
    }

    public String getEtag() {
        return this.props.etag;
    }

    public String getContentLanguage() {
        return this.props.contentLanguage;
    }

    public String getDisplayName() {
        return this.props.displayName;
    }

    public List<QName> getResourceTypes() {
        return this.props.resourceTypes;
    }

    public List<QName> getSupportedReports() {
        return this.props.supportedReports;
    }

    public boolean isDirectory() {
        return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE.equals(this.props.contentType);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getCustomProps() {
        void var1_1;
        HashMap<String, String> local = new HashMap<String, String>();
        Map<QName, String> properties = this.getCustomPropsNS();
        for (QName key : properties.keySet()) {
            local.put(key.getLocalPart(), properties.get(key));
        }
        return var1_1;
    }

    public Map<QName, String> getCustomPropsNS() {
        return this.props.customProps;
    }

    public URI getHref() {
        return this.href;
    }

    /*
     * WARNING - void declaration
     */
    public String getName() {
        String path = this.href.getPath();
        try {
            if (path.endsWith(SEPARATOR)) {
                path = path.substring(0, path.length() - 1);
            }
            String string = path;
            return string.substring(string.lastIndexOf(47) + 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            void var1_1;
            log.warning(String.format("Failed to parse name from path %s", var1_1));
            return null;
        }
    }

    public String getPath() {
        return this.href.getPath();
    }

    public String toString() {
        return this.getPath();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$000(DavResource x0, Response x1) {
        void var1_1;
        return x0.getCreationDate((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$100(DavResource x0, Response x1) {
        void var1_1;
        return x0.getModifiedDate((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$200(DavResource x0, Response x1) {
        void var1_1;
        return x0.getContentType((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$300(DavResource x0, Response x1) {
        void var1_1;
        return x0.getContentLength((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$400(DavResource x0, Response x1) {
        void var1_1;
        return x0.getEtag((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$500(DavResource x0, Response x1) {
        void var1_1;
        return x0.getDisplayName((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$600(DavResource x0, Response x1) {
        void var1_1;
        return x0.getResourceTypes((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$700(DavResource x0, Response x1) {
        void var1_1;
        return x0.getContentLanguage((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$800(DavResource x0, Response x1) {
        void var1_1;
        return x0.getSupportedReports((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$900(DavResource x0, Response x1) {
        void var1_1;
        return x0.getCustomProps((Response)var1_1);
    }

    private class DavProperties {
        final Date creation;
        final Date modified;
        final String contentType;
        final String etag;
        final String displayName;
        final List<QName> resourceTypes;
        final String contentLanguage;
        final Long contentLength;
        final List<QName> supportedReports;
        final Map<QName, String> customProps;

        /*
         * WARNING - void declaration
         */
        DavProperties(Date creation, Date modified, String contentType, Long contentLength, String etag, String displayName, List<QName> resourceTypes, String contentLanguage, List<QName> supportedReports, Map<QName, String> customProps) {
            void var3_3;
            void var2_2;
            this.creation = var2_2;
            this.modified = var3_3;
            this.contentType = contentType;
            this.contentLength = contentLength;
            this.etag = etag;
            this.displayName = displayName;
            this.resourceTypes = resourceTypes;
            this.contentLanguage = contentLanguage;
            this.supportedReports = supportedReports;
            this.customProps = customProps;
        }

        /*
         * WARNING - void declaration
         */
        DavProperties(Response response) {
            void var2_2;
            this.creation = SardineUtil.parseDate(DavResource.access$000(DavResource.this, response));
            this.modified = SardineUtil.parseDate(DavResource.access$100(DavResource.this, response));
            this.contentType = DavResource.access$200(DavResource.this, response);
            this.contentLength = DavResource.access$300(DavResource.this, response);
            this.etag = DavResource.access$400(DavResource.this, response);
            this.displayName = DavResource.access$500(DavResource.this, response);
            this.resourceTypes = DavResource.access$600(DavResource.this, response);
            this.contentLanguage = DavResource.access$700(DavResource.this, response);
            this.supportedReports = DavResource.access$800(DavResource.this, response);
            this.customProps = DavResource.access$900(DavResource.this, (Response)var2_2);
        }
    }
}

