/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine;

import com.github.sardine.model.Prop;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.Response;
import java.util.Iterator;
import java.util.List;

public class DavQuota {
    private final long quotaAvailableBytes;
    private final long quotaUsedBytes;

    /*
     * WARNING - void declaration
     */
    public DavQuota(Response response) {
        void var1_1;
        this.quotaAvailableBytes = this.getAvailable(response);
        this.quotaUsedBytes = this.getUsed((Response)var1_1);
    }

    private long getAvailable(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return Long.MAX_VALUE;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Propstat propstat = (Propstat)iterator.next();
            Prop prop = propstat.getProp();
            if (prop == null || null == prop.getQuotaAvailableBytes() || prop.getQuotaAvailableBytes().getContent().isEmpty()) continue;
            return Long.valueOf(((Prop)((Object)propstat)).getQuotaAvailableBytes().getContent().get(0));
        }
        return Long.MAX_VALUE;
    }

    private long getUsed(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return 0L;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Propstat propstat = (Propstat)iterator.next();
            Prop prop = propstat.getProp();
            if (prop == null || null == prop.getQuotaUsedBytes() || prop.getQuotaUsedBytes().getContent().isEmpty()) continue;
            return Long.valueOf(((Prop)((Object)propstat)).getQuotaUsedBytes().getContent().get(0));
        }
        return 0L;
    }

    public long getQuotaAvailableBytes() {
        return this.quotaAvailableBytes;
    }

    public long getQuotaUsedBytes() {
        return this.quotaUsedBytes;
    }
}

