/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine;

import com.github.sardine.model.Principal;
import javax.xml.namespace.QName;

public class DavPrincipal {
    public static final String KEY_SELF = "self";
    public static final String KEY_UNAUTHENTICATED = "unauthenticated";
    public static final String KEY_AUTHENTICATED = "authenticated";
    public static final String KEY_ALL = "all";
    private final PrincipalType principalType;
    private final String value;
    private final QName property;
    private final String displayName;

    /*
     * WARNING - void declaration
     */
    public DavPrincipal(PrincipalType principalType, String value, String name) {
        this((PrincipalType)var1_1, (String)var2_2, null, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected DavPrincipal(PrincipalType principalType, String value, QName property, String name) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (value != null && principalType == PrincipalType.PROPERTY) {
            throw new IllegalArgumentException("Principal type property can't have a string value");
        }
        if (property != null && principalType != PrincipalType.PROPERTY) {
            throw new IllegalArgumentException("Principal type " + principalType.name() + " property is not allowed to have a QName property");
        }
        this.principalType = var1_1;
        this.value = var2_2;
        this.property = var3_3;
        this.displayName = name;
    }

    /*
     * WARNING - void declaration
     */
    public DavPrincipal(PrincipalType principalType, QName property, String name) {
        this((PrincipalType)var1_1, null, (QName)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DavPrincipal(Principal principal) {
        this.displayName = null;
        if (principal.getHref() != null) {
            this.principalType = PrincipalType.HREF;
            this.value = principal.getHref();
            this.property = null;
            return;
        }
        if (principal.getProperty() != null) {
            this.principalType = PrincipalType.PROPERTY;
            this.value = null;
            this.property = new QName(principal.getProperty().getProperty().getNamespaceURI(), principal.getProperty().getProperty().getLocalName());
            return;
        }
        if (principal.getAll() != null || principal.getAuthenticated() != null || principal.getUnauthenticated() != null || principal.getSelf() != null) {
            void var1_1;
            this.principalType = PrincipalType.KEY;
            this.property = null;
            if (principal.getAll() != null) {
                this.value = KEY_ALL;
                return;
            }
            if (principal.getAuthenticated() != null) {
                this.value = KEY_AUTHENTICATED;
                return;
            }
            if (var1_1.getUnauthenticated() != null) {
                this.value = KEY_UNAUTHENTICATED;
                return;
            }
            this.value = KEY_SELF;
            return;
        }
        this.principalType = null;
        this.value = null;
        this.property = null;
    }

    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public String getValue() {
        return this.value;
    }

    public QName getProperty() {
        return this.property;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return "[principalType=" + (Object)((Object)this.principalType) + ", value=" + this.value + ", property=" + this.property + ", displayName=" + this.displayName + "]";
    }

    public static enum PrincipalType {
        HREF,
        KEY,
        PROPERTY;

    }
}

