/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine;

import com.github.sardine.DavAce;
import com.github.sardine.model.Ace;
import com.github.sardine.model.Acl;
import com.github.sardine.model.Group;
import com.github.sardine.model.Owner;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.Response;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DavAcl {
    private final String owner;
    private final String group;
    private List<DavAce> aces;

    /*
     * WARNING - void declaration
     */
    public DavAcl(Response response) {
        void var1_1;
        this.owner = this.getOwner(response);
        this.group = this.getGroup(response);
        this.aces = this.getAces((Response)var1_1);
    }

    public String getGroup() {
        return this.group;
    }

    public String getOwner() {
        return this.owner;
    }

    public List<DavAce> getAces() {
        return this.aces;
    }

    private String getOwner(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Propstat propstat = (Propstat)iterator.next();
            Owner o = propstat.getProp().getOwner();
            if (o == null) continue;
            if (o.getUnauthenticated() != null) {
                return "unauthenticated";
            }
            if (o.getHref() == null) continue;
            return ((Owner)((Object)propstat)).getHref();
        }
        return null;
    }

    private String getGroup(Response response) {
        Iterator iterator;
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Propstat propstat = (Propstat)iterator.next();
            Group o = propstat.getProp().getGroup();
            if (o == null || o.getHref() == null) continue;
            return ((Group)((Object)propstat)).getHref();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private List<DavAce> getAces(Response response) {
        void var2_2;
        Iterator iterator;
        ArrayList<DavAce> result = new ArrayList<DavAce>();
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Propstat propstat = (Propstat)iterator.next();
            Acl a = propstat.getProp().getAcl();
            if (a == null || a.getAce() == null) continue;
            for (Ace ace : ((Acl)((Object)propstat)).getAce()) {
                result.add(new DavAce(ace));
            }
        }
        return var2_2;
    }
}

