/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine;

import com.github.sardine.DavPrincipal;
import com.github.sardine.model.Ace;
import com.github.sardine.model.All;
import com.github.sardine.model.Authenticated;
import com.github.sardine.model.Bind;
import com.github.sardine.model.Deny;
import com.github.sardine.model.Grant;
import com.github.sardine.model.Principal;
import com.github.sardine.model.Privilege;
import com.github.sardine.model.Property;
import com.github.sardine.model.Read;
import com.github.sardine.model.ReadAcl;
import com.github.sardine.model.ReadCurrentUserPrivilegeSet;
import com.github.sardine.model.Self;
import com.github.sardine.model.SimplePrivilege;
import com.github.sardine.model.UnBind;
import com.github.sardine.model.Unauthenticated;
import com.github.sardine.model.Unlock;
import com.github.sardine.model.Write;
import com.github.sardine.model.WriteContent;
import com.github.sardine.model.WriteProperties;
import com.github.sardine.util.SardineUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

public class DavAce {
    private final DavPrincipal principal;
    private final List<String> granted;
    private final List<String> denied;
    private final String inherited;
    private final boolean isprotected;

    /*
     * WARNING - void declaration
     */
    public DavAce(DavPrincipal principal) {
        void var1_1;
        this.principal = var1_1;
        this.granted = new ArrayList<String>();
        this.denied = new ArrayList<String>();
        this.inherited = null;
        this.isprotected = false;
    }

    /*
     * WARNING - void declaration
     */
    public DavAce(Ace ace) {
        void var1_1;
        this.principal = new DavPrincipal(ace.getPrincipal());
        this.granted = new ArrayList<String>();
        this.denied = new ArrayList<String>();
        if (ace.getGrant() != null) {
            for (Privilege privilege : ace.getGrant().getPrivilege()) {
                for (Object o : privilege.getContent()) {
                    if (!(o instanceof SimplePrivilege)) continue;
                    this.granted.add(o.getClass().getAnnotation(XmlRootElement.class).name());
                }
            }
        }
        if (ace.getDeny() != null) {
            for (Privilege privilege : ace.getDeny().getPrivilege()) {
                for (Object o : privilege.getContent()) {
                    if (!(o instanceof SimplePrivilege)) continue;
                    this.denied.add(o.getClass().getAnnotation(XmlRootElement.class).name());
                }
            }
        }
        this.inherited = ace.getInherited() != null ? ace.getInherited().getHref() : null;
        this.isprotected = var1_1.getProtected() != null;
    }

    public DavPrincipal getPrincipal() {
        return this.principal;
    }

    public List<String> getGranted() {
        return this.granted;
    }

    public List<String> getDenied() {
        return this.denied;
    }

    public String getInherited() {
        return this.inherited;
    }

    public boolean isProtected() {
        return this.isprotected;
    }

    /*
     * WARNING - void declaration
     */
    public Ace toModel() {
        void var1_1;
        void var2_2;
        Ace ace = new Ace();
        Principal p = new Principal();
        switch (this.principal.getPrincipalType()) {
            case HREF: {
                p.setHref(this.principal.getValue());
                break;
            }
            case PROPERTY: {
                p.setProperty(new Property());
                p.getProperty().setProperty(SardineUtil.createElement(this.principal.getProperty()));
                break;
            }
            case KEY: {
                if ("all".equals(this.principal.getValue())) {
                    p.setAll(new All());
                    break;
                }
                if ("authenticated".equals(this.principal.getValue())) {
                    p.setAuthenticated(new Authenticated());
                    break;
                }
                if ("unauthenticated".equals(this.principal.getValue())) {
                    p.setUnauthenticated(new Unauthenticated());
                    break;
                }
                if (!"self".equals(this.principal.getValue())) break;
                p.setSelf(new Self());
            }
        }
        ace.setPrincipal((Principal)var2_2);
        if (this.granted != null && this.granted.size() > 0) {
            ace.setGrant(new Grant());
            DavAce davAce = this;
            ace.getGrant().setPrivilege(davAce.toPrivilege(davAce.granted));
        }
        if (this.denied != null && this.denied.size() > 0) {
            ace.setDeny(new Deny());
            DavAce davAce = this;
            ace.getDeny().setPrivilege(davAce.toPrivilege(davAce.denied));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<Privilege> toPrivilege(List<String> rights) {
        void var2_2;
        Iterator iterator;
        ArrayList<Privilege> privileges = new ArrayList<Privilege>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String right = (String)iterator.next();
            Privilege p = new Privilege();
            if ("all".equals(right)) {
                p.getContent().add(new All());
            } else if ("bind".equals(right)) {
                p.getContent().add(new Bind());
            } else if ("read".equals(right)) {
                p.getContent().add(new Read());
            } else if ("read-acl".equals(right)) {
                p.getContent().add(new ReadAcl());
            } else if ("read-current-user-privilege-set".equals(right)) {
                p.getContent().add(new ReadCurrentUserPrivilegeSet());
            } else if ("unbind".equals(right)) {
                p.getContent().add(new UnBind());
            } else if ("unlock".equals(right)) {
                p.getContent().add(new Unlock());
            } else if ("write".equals(right)) {
                p.getContent().add(new Write());
            } else if ("write-content".equals(right)) {
                p.getContent().add(new WriteContent());
            } else {
                void var3_3;
                if (!"write-properties".equals(var3_3)) continue;
                p.getContent().add(new WriteProperties());
            }
            privileges.add(p);
        }
        return var2_2;
    }
}

