/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.Lab;
import androidx.compose.ui.graphics.colorspace.Oklab;
import androidx.compose.ui.graphics.colorspace.Rgb;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import androidx.compose.ui.graphics.colorspace.Xyz;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020=H\u0080\b\u00a2\u0006\u0002\b>J\u001a\u0010?\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010@\u001a\u00020)2\u0006\u0010A\u001a\u00020%R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006R\u0011\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0006R\u0011\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0006R\u0011\u0010 \u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0006R\u0011\u0010\"\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0006R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0006R\u0014\u0010(\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0012R\u0011\u0010.\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0006R\u0011\u00100\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0006R\u0011\u00102\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0006R\u0014\u00104\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010+R\u0014\u00106\u001a\u00020%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0006\u00a8\u0006B"}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpaces;", "", "()V", "Aces", "Landroidx/compose/ui/graphics/colorspace/Rgb;", "getAces", "()Landroidx/compose/ui/graphics/colorspace/Rgb;", "Acescg", "getAcescg", "AdobeRgb", "getAdobeRgb", "Bt2020", "getBt2020", "Bt709", "getBt709", "CieLab", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "getCieLab", "()Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "CieXyz", "getCieXyz", "ColorSpacesArray", "", "getColorSpacesArray$ui_graphics", "()[Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "[Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "DciP3", "getDciP3", "DisplayP3", "getDisplayP3", "ExtendedSrgb", "getExtendedSrgb", "LinearExtendedSrgb", "getLinearExtendedSrgb", "LinearSrgb", "getLinearSrgb", "NoneTransferParameters", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "Ntsc1953", "getNtsc1953", "Ntsc1953Primaries", "", "getNtsc1953Primaries$ui_graphics", "()[F", "Oklab", "getOklab", "ProPhotoRgb", "getProPhotoRgb", "SmpteC", "getSmpteC", "Srgb", "getSrgb", "SrgbPrimaries", "getSrgbPrimaries$ui_graphics", "SrgbTransferParameters", "getSrgbTransferParameters$ui_graphics", "()Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "Unspecified", "getUnspecified$ui_graphics", "getColorSpace", "id", "", "getColorSpace$ui_graphics", "match", "toXYZD50", "function", "ui-graphics"})
public final class ColorSpaces {
    public static final ColorSpaces INSTANCE = new ColorSpaces();
    private static final float[] SrgbPrimaries;
    private static final float[] Ntsc1953Primaries;
    private static final TransferParameters SrgbTransferParameters;
    private static final TransferParameters NoneTransferParameters;
    private static final Rgb Srgb;
    private static final Rgb LinearSrgb;
    private static final Rgb ExtendedSrgb;
    private static final Rgb LinearExtendedSrgb;
    private static final Rgb Bt709;
    private static final Rgb Bt2020;
    private static final Rgb DciP3;
    private static final Rgb DisplayP3;
    private static final Rgb Ntsc1953;
    private static final Rgb SmpteC;
    private static final Rgb AdobeRgb;
    private static final Rgb ProPhotoRgb;
    private static final Rgb Aces;
    private static final Rgb Acescg;
    private static final ColorSpace CieXyz;
    private static final ColorSpace CieLab;
    private static final Rgb Unspecified;
    private static final ColorSpace Oklab;
    private static final ColorSpace[] ColorSpacesArray;

    private ColorSpaces() {
    }

    public final float[] getSrgbPrimaries$ui_graphics() {
        return SrgbPrimaries;
    }

    public final float[] getNtsc1953Primaries$ui_graphics() {
        return Ntsc1953Primaries;
    }

    public final TransferParameters getSrgbTransferParameters$ui_graphics() {
        return SrgbTransferParameters;
    }

    public final Rgb getSrgb() {
        return Srgb;
    }

    public final Rgb getLinearSrgb() {
        return LinearSrgb;
    }

    public final Rgb getExtendedSrgb() {
        return ExtendedSrgb;
    }

    public final Rgb getLinearExtendedSrgb() {
        return LinearExtendedSrgb;
    }

    public final Rgb getBt709() {
        return Bt709;
    }

    public final Rgb getBt2020() {
        return Bt2020;
    }

    public final Rgb getDciP3() {
        return DciP3;
    }

    public final Rgb getDisplayP3() {
        return DisplayP3;
    }

    public final Rgb getNtsc1953() {
        return Ntsc1953;
    }

    public final Rgb getSmpteC() {
        return SmpteC;
    }

    public final Rgb getAdobeRgb() {
        return AdobeRgb;
    }

    public final Rgb getProPhotoRgb() {
        return ProPhotoRgb;
    }

    public final Rgb getAces() {
        return Aces;
    }

    public final Rgb getAcescg() {
        return Acescg;
    }

    public final ColorSpace getCieXyz() {
        return CieXyz;
    }

    public final ColorSpace getCieLab() {
        return CieLab;
    }

    public final Rgb getUnspecified$ui_graphics() {
        return Unspecified;
    }

    public final ColorSpace getOklab() {
        return Oklab;
    }

    public final ColorSpace match(float[] toXYZD50, TransferParameters function) {
        Intrinsics.checkNotNullParameter((Object)toXYZD50, (String)"toXYZD50");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        for (ColorSpace colorSpace : ColorSpacesArray) {
            if (!ColorModel.equals-impl0(colorSpace.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw())) continue;
            ColorSpace colorSpace2 = ColorSpaceKt.adapt$default(colorSpace, Illuminant.INSTANCE.getD50(), null, 2, null);
            Intrinsics.checkNotNull((Object)colorSpace2, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
            Rgb rgb = (Rgb)colorSpace2;
            if (!ColorSpaceKt.compare(toXYZD50, rgb.getTransform$ui_graphics()) || !ColorSpaceKt.compare(function, rgb.getTransferParameters())) continue;
            return colorSpace;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final ColorSpace getColorSpace$ui_graphics(int id) {
        void var1_1;
        return this.getColorSpacesArray$ui_graphics()[var1_1];
    }

    public final ColorSpace[] getColorSpacesArray$ui_graphics() {
        return ColorSpacesArray;
    }

    private static final double ExtendedSrgb$lambda$0(double x) {
        return ColorSpaceKt.absRcpResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4);
    }

    private static final double ExtendedSrgb$lambda$1(double x) {
        return ColorSpaceKt.absResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4);
    }

    static {
        float[] fArray = new float[6];
        Object[] objectArray = fArray;
        fArray[0] = 0.64f;
        objectArray[1] = 0.33f;
        objectArray[2] = 0.3f;
        objectArray[3] = 0.6f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        SrgbPrimaries = objectArray;
        float[] fArray2 = new float[6];
        objectArray = fArray2;
        fArray2[0] = 0.67f;
        objectArray[1] = 0.33f;
        objectArray[2] = 0.21f;
        objectArray[3] = 0.71f;
        objectArray[4] = 0.14f;
        objectArray[5] = 0.08f;
        Ntsc1953Primaries = objectArray;
        SrgbTransferParameters = new TransferParameters(2.4, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 0.0, 0.0, 96, null);
        NoneTransferParameters = new TransferParameters(2.2, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 0.0, 0.0, 96, null);
        Srgb = new Rgb("sRGB IEC61966-2.1", SrgbPrimaries, Illuminant.INSTANCE.getD65(), SrgbTransferParameters, 0);
        LinearSrgb = new Rgb("sRGB IEC61966-2.1 (Linear)", SrgbPrimaries, Illuminant.INSTANCE.getD65(), 1.0, 0.0f, 1.0f, 1);
        ExtendedSrgb = new Rgb("scRGB-nl IEC 61966-2-2:2003", SrgbPrimaries, Illuminant.INSTANCE.getD65(), null, ColorSpaces::ExtendedSrgb$lambda$0, ColorSpaces::ExtendedSrgb$lambda$1, -0.799f, 2.399f, SrgbTransferParameters, 2);
        LinearExtendedSrgb = new Rgb("scRGB IEC 61966-2-2:2003", SrgbPrimaries, Illuminant.INSTANCE.getD65(), 1.0, -0.5f, 7.499f, 3);
        float[] fArray3 = new float[6];
        objectArray = fArray3;
        fArray3[0] = 0.64f;
        objectArray[1] = 0.33f;
        objectArray[2] = 0.3f;
        objectArray[3] = 0.6f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        Bt709 = new Rgb("Rec. ITU-R BT.709-5", (float[])objectArray, Illuminant.INSTANCE.getD65(), new TransferParameters(2.2222222222222223, 0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 0.0, 0.0, 96, null), 4);
        float[] fArray4 = new float[6];
        objectArray = fArray4;
        fArray4[0] = 0.708f;
        objectArray[1] = 0.292f;
        objectArray[2] = 0.17f;
        objectArray[3] = 0.797f;
        objectArray[4] = 0.131f;
        objectArray[5] = 0.046f;
        Bt2020 = new Rgb("Rec. ITU-R BT.2020-1", (float[])objectArray, Illuminant.INSTANCE.getD65(), new TransferParameters(2.2222222222222223, 0.9096697898662786, 0.09033021013372146, 0.2222222222222222, 0.08145, 0.0, 0.0, 96, null), 5);
        float[] fArray5 = new float[6];
        objectArray = fArray5;
        fArray5[0] = 0.68f;
        objectArray[1] = 0.32f;
        objectArray[2] = 0.265f;
        objectArray[3] = 0.69f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        DciP3 = new Rgb("SMPTE RP 431-2-2007 DCI (P3)", (float[])objectArray, new WhitePoint(0.314f, 0.351f), 2.6, 0.0f, 1.0f, 6);
        float[] fArray6 = new float[6];
        objectArray = fArray6;
        fArray6[0] = 0.68f;
        objectArray[1] = 0.32f;
        objectArray[2] = 0.265f;
        objectArray[3] = 0.69f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        DisplayP3 = new Rgb("Display P3", (float[])objectArray, Illuminant.INSTANCE.getD65(), SrgbTransferParameters, 7);
        Ntsc1953 = new Rgb("NTSC (1953)", Ntsc1953Primaries, Illuminant.INSTANCE.getC(), new TransferParameters(2.2222222222222223, 0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 0.0, 0.0, 96, null), 8);
        float[] fArray7 = new float[6];
        objectArray = fArray7;
        fArray7[0] = 0.63f;
        objectArray[1] = 0.34f;
        objectArray[2] = 0.31f;
        objectArray[3] = 0.595f;
        objectArray[4] = 0.155f;
        objectArray[5] = 0.07f;
        SmpteC = new Rgb("SMPTE-C RGB", (float[])objectArray, Illuminant.INSTANCE.getD65(), new TransferParameters(2.2222222222222223, 0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 0.0, 0.0, 96, null), 9);
        float[] fArray8 = new float[6];
        objectArray = fArray8;
        fArray8[0] = 0.64f;
        objectArray[1] = 0.33f;
        objectArray[2] = 0.21f;
        objectArray[3] = 0.71f;
        objectArray[4] = 0.15f;
        objectArray[5] = 0.06f;
        AdobeRgb = new Rgb("Adobe RGB (1998)", (float[])objectArray, Illuminant.INSTANCE.getD65(), 2.2, 0.0f, 1.0f, 10);
        float[] fArray9 = new float[6];
        objectArray = fArray9;
        fArray9[0] = 0.7347f;
        objectArray[1] = 0.2653f;
        objectArray[2] = 0.1596f;
        objectArray[3] = 0.8404f;
        objectArray[4] = 0.0366f;
        objectArray[5] = 1.0E-4f;
        ProPhotoRgb = new Rgb("ROMM RGB ISO 22028-2:2013", (float[])objectArray, Illuminant.INSTANCE.getD50(), new TransferParameters(1.8, 1.0, 0.0, 0.0625, 0.031248, 0.0, 0.0, 96, null), 11);
        float[] fArray10 = new float[6];
        objectArray = fArray10;
        fArray10[0] = 0.7347f;
        objectArray[1] = 0.2653f;
        objectArray[2] = 0.0f;
        objectArray[3] = 1.0f;
        objectArray[4] = 1.0E-4f;
        objectArray[5] = -0.077f;
        Aces = new Rgb("SMPTE ST 2065-1:2012 ACES", (float[])objectArray, Illuminant.INSTANCE.getD60(), 1.0, -65504.0f, 65504.0f, 12);
        float[] fArray11 = new float[6];
        objectArray = fArray11;
        fArray11[0] = 0.713f;
        objectArray[1] = 0.293f;
        objectArray[2] = 0.165f;
        objectArray[3] = 0.83f;
        objectArray[4] = 0.128f;
        objectArray[5] = 0.044f;
        Acescg = new Rgb("Academy S-2014-004 ACEScg", (float[])objectArray, Illuminant.INSTANCE.getD60(), 1.0, -65504.0f, 65504.0f, 13);
        CieXyz = new Xyz("Generic XYZ", 14);
        CieLab = new Lab("Generic L*a*b*", 15);
        Unspecified = new Rgb("None", SrgbPrimaries, Illuminant.INSTANCE.getD65(), NoneTransferParameters, 16);
        Oklab = new Oklab("Oklab", 17);
        ColorSpace[] colorSpaceArray = new ColorSpace[18];
        objectArray = colorSpaceArray;
        colorSpaceArray[0] = Srgb;
        objectArray[1] = (float)LinearSrgb;
        objectArray[2] = (float)ExtendedSrgb;
        objectArray[3] = (float)LinearExtendedSrgb;
        objectArray[4] = (float)Bt709;
        objectArray[5] = (float)Bt2020;
        objectArray[6] = (float)DciP3;
        objectArray[7] = (float)DisplayP3;
        objectArray[8] = (float)Ntsc1953;
        objectArray[9] = (float)SmpteC;
        objectArray[10] = (float)AdobeRgb;
        objectArray[11] = (float)ProPhotoRgb;
        objectArray[12] = (float)Aces;
        objectArray[13] = (float)Acescg;
        objectArray[14] = (float)CieXyz;
        objectArray[15] = (float)CieLab;
        objectArray[16] = (float)Unspecified;
        objectArray[17] = (float)Oklab;
        ColorSpacesArray = (ColorSpace[])objectArray;
    }
}

