/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.InternalComposeUiApi;
import androidx.compose.ui.graphics.GraphicsContext;
import androidx.compose.ui.graphics.SkiaGraphicsContext;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/compose/ui/graphics/SkiaGraphicsContext;", "Landroidx/compose/ui/graphics/GraphicsContext;", "()V", "<set-?>", "", "activeGraphicsLayersCount", "getActiveGraphicsLayersCount", "()I", "snapshotObserver", "Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "createGraphicsLayer", "Landroidx/compose/ui/graphics/layer/GraphicsLayer;", "dispose", "", "releaseGraphicsLayer", "layer", "ui-graphics"})
@InternalComposeUiApi
public final class SkiaGraphicsContext
implements GraphicsContext {
    private final SnapshotStateObserver snapshotObserver = new SnapshotStateObserver((Function1)snapshotObserver.1.INSTANCE);
    private int activeGraphicsLayersCount;

    public SkiaGraphicsContext() {
        this.snapshotObserver.start();
    }

    public final int getActiveGraphicsLayersCount() {
        return this.activeGraphicsLayersCount;
    }

    public final void dispose() {
        this.snapshotObserver.stop();
        this.snapshotObserver.clear();
    }

    @Override
    public final GraphicsLayer createGraphicsLayer() {
        int n = this.activeGraphicsLayersCount;
        this.activeGraphicsLayersCount = n + 1;
        return new GraphicsLayer(this.snapshotObserver);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void releaseGraphicsLayer(GraphicsLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        if (!layer.isReleased()) {
            void var1_1;
            int n = this.activeGraphicsLayersCount;
            this.activeGraphicsLayersCount = n + -1;
            var1_1.release$ui_graphics();
        }
    }
}

