/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.collection.FloatFloatPair;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b&\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\t\u001a\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0082\b\u001a?\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010\u001b\u001a'\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010\u001e\u001a'\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\u0010\u001e\u001aH\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0000\u001a \u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0018H\u0002\u001a0\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u0018H\u0000\u001a \u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0007\u001a0\u00103\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0002\u001a \u00109\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0002\u001a(\u0010:\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003H\u0002\u001a\u0018\u0010;\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0003H\u0002\u001a\u0018\u0010<\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0003H\u0007\u001a\u0018\u0010=\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u0018H\u0002\u001a(\u0010?\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010@\u001a\u00020A2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a(\u0010B\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0007\u001a\u0019\u0010C\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0082\b\u001a \u0010D\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0002\u001a\u0018\u0010E\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010F\u001a\u00020\u0003H\u0007\u001a+\u0010G\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0082\b\u001a2\u0010H\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002\u001a \u0010I\u001a\u00020A2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002\u001a \u0010J\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0000\u001a(\u0010K\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010L\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0002\u001a0\u0010M\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010L\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0018H\u0002\u001a\u0018\u0010N\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0018H\u0002\u001a0\u0010P\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u0010Q\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u0018H\u0000\u001a0\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00182\u0006\u0010U\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010V\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u0003H\u0002\u001a \u0010W\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u0003H\u0002\u001a\u0018\u0010X\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0002\u001a \u0010Y\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0015\u0010Z\u001a\u00020A*\u00020\u00012\u0006\u0010[\u001a\u00020\u0001H\u0080\b\u001a\u0015\u0010Z\u001a\u00020A*\u00020\u00032\u0006\u0010[\u001a\u00020\u0003H\u0080\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0003*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0003*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0019\u0010\u000b\u001a\u00020\u0003*\u00020\u00068\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0019\u0010\r\u001a\u00020\u0003*\u00020\u00068\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\\"}, d2={"Epsilon", "", "FloatEpsilon", "", "Tau", "endX", "Landroidx/compose/ui/graphics/PathSegment;", "getEndX", "(Landroidx/compose/ui/graphics/PathSegment;)F", "endY", "getEndY", "startX", "getStartX", "startY", "getStartY", "clampValidRootInUnitRange", "r", "computeCubicVerticalBounds", "Landroidx/collection/FloatFloatPair;", "p0y", "p1y", "p2y", "p3y", "roots", "", "index", "", "(FFFF[FI)J", "computeHorizontalBounds", "segment", "(Landroidx/compose/ui/graphics/PathSegment;[FI)J", "computeVerticalBounds", "cubicArea", "x0", "y0", "x1", "y1", "x2", "y2", "x3", "y3", "cubicToMonotonicCubics", "cubic", "dst", "tmpRoot", "cubicWinding", "points", "x", "y", "tmpCubics", "tmpRoots", "evaluateCubic", "p1", "p2", "t", "p0", "p3", "evaluateLine", "evaluateQuadratic", "evaluateX", "evaluateY", "findCubicExtremaY", "dstRoots", "findDerivativeRoots", "horizontal", "", "findFirstCubicRoot", "findFirstLineRoot", "findFirstQuadraticRoot", "findFirstRoot", "fraction", "findLineRoot", "findQuadraticRoots", "isQuadraticMonotonic", "lineWinding", "monotonicCubicWinding", "offset", "monotonicQuadraticWinding", "quadraticToMonotonicQuadratics", "quadratic", "quadraticWinding", "tmpQuadratics", "splitCubicAt", "", "src", "srcOffset", "dstOffset", "splitQuadraticAt", "unitDivide", "writeValidRootInUnitRange", "closeTo", "b", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nBezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,1120:1\n230#1:1121\n571#1,7:1122\n571#1,7:1129\n571#1,7:1136\n571#1,7:1143\n571#1,7:1150\n560#1:1157\n560#1:1158\n560#1:1159\n571#1,7:1160\n571#1,7:1167\n571#1,7:1174\n571#1,7:1197\n571#1,7:1204\n571#1,7:1211\n571#1,7:1218\n571#1,7:1225\n571#1,7:1232\n359#1:1239\n359#1:1240\n1094#1:1241\n1094#1:1242\n1108#1:1243\n1108#1:1244\n359#1:1245\n571#1,7:1246\n563#1:1253\n563#1:1256\n97#2,16:1181\n49#2:1254\n60#2:1255\n71#2,16:1257\n*S KotlinDebug\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n*L\n201#1:1121\n201#1:1122,7\n230#1:1129,7\n254#1:1136,7\n257#1:1143,7\n259#1:1150,7\n293#1:1157\n295#1:1158\n297#1:1159\n300#1:1160,7\n305#1:1167,7\n308#1:1174,7\n329#1:1197,7\n332#1:1204,7\n335#1:1211,7\n339#1:1218,7\n342#1:1225,7\n349#1:1232,7\n442#1:1239\n461#1:1240\n484#1:1241\n485#1:1242\n511#1:1243\n512#1:1244\n544#1:1245\n586#1:1246,7\n726#1:1253\n910#1:1256\n325#1:1181,16\n889#1:1254\n892#1:1255\n950#1:1257,16\n*E\n"})
public final class BezierKt {
    private static final double Tau = Math.PI * 2;
    private static final double Epsilon = 1.0E-7;
    private static final float FloatEpsilon = 8.34465E-7f;

    /*
     * WARNING - void declaration
     */
    private static final float evaluateX(PathSegment segment, float t) {
        PathSegment pathSegment;
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                return points[0];
            }
            case 2: {
                return BezierKt.evaluateLine(points[0], points[2], t);
            }
            case 3: {
                return BezierKt.evaluateQuadratic(points[0], points[2], points[4], t);
            }
            case 4: {
                return Float.NaN;
            }
            case 5: {
                void var1_1;
                void var2_2;
                return BezierKt.evaluateCubic(points[0], points[2], points[4], (float)var2_2[6], (float)var1_1);
            }
            case 6: {
                return Float.NaN;
            }
            case 7: {
                return Float.NaN;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    public static final float evaluateY(PathSegment segment, float t) {
        PathSegment pathSegment;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                return points[1];
            }
            case 2: {
                return BezierKt.evaluateLine(points[1], points[3], t);
            }
            case 3: {
                return BezierKt.evaluateQuadratic(points[1], points[3], points[5], t);
            }
            case 4: {
                return Float.NaN;
            }
            case 5: {
                void var1_1;
                void var2_2;
                return BezierKt.evaluateCubic(points[1], points[3], points[5], (float)var2_2[7], (float)var1_1);
            }
            case 6: {
                return Float.NaN;
            }
            case 7: {
                return Float.NaN;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private static final float evaluateLine(float p0y, float p1y, float t) {
        float f;
        void var2_2;
        return (p1y - p0y) * var2_2 + f;
    }

    /*
     * WARNING - void declaration
     */
    private static final float evaluateQuadratic(float p0, float p1, float p2, float t) {
        float f;
        void var3_3;
        void var1_1;
        void var2_2;
        float by = 2.0f * (p1 - p0);
        var1_1 = var2_2 - var1_1 * 2.0f + p0;
        return (float)((var1_1 * t + by) * var3_3 + f);
    }

    /*
     * WARNING - void declaration
     */
    private static final float evaluateCubic(float p0, float p1, float p2, float p3, float t) {
        float f;
        void var1_1;
        void var2_2;
        void var3_3;
        float a = p3 + 3.0f * (p1 - p2) - p0;
        float b = 3.0f * (p2 - p1 * 2.0f + p0);
        float c = 3.0f * (p1 - p0);
        return (float)(((var3_3 * t + var2_2) * t + var1_1) * t + f);
    }

    /*
     * WARNING - void declaration
     */
    public static final float evaluateCubic(float p1, float p2, float t) {
        void var2_2;
        float f;
        void var1_1;
        void var3_3;
        float a = 0.33333334f + (p1 - p2);
        float b = p2 - p1 * 2.0f;
        return 3.0f * ((var3_3 * t + var1_1) * t + f) * var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final float findFirstRoot(PathSegment segment2, float fraction) {
        float f;
        Intrinsics.checkNotNullParameter((Object)segment2, (String)"segment");
        float[] points = segment2.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment2.getType().ordinal()]) {
            case 1: {
                return Float.NaN;
            }
            case 2: {
                void var0_1;
                void v0;
                void var1_2;
                void p0$iv;
                float segment2 = points[0] - fraction;
                float p1$iv = points[2] - fraction;
                void r$iv$iv = -p0$iv / (var1_2 - p0$iv);
                if (v0 < 0.0f) {
                    if (r$iv$iv >= -8.34465E-7f) {
                        f = 0.0f;
                        break;
                    }
                    f = Float.NaN;
                    break;
                }
                if (r$iv$iv > 1.0f) {
                    if (r$iv$iv <= 1.0000008f) {
                        f = 1.0f;
                        break;
                    }
                    f = Float.NaN;
                    break;
                }
                return (float)var0_1;
            }
            case 3: {
                void var1_2;
                return BezierKt.findFirstQuadraticRoot(points[0] - var1_2, points[2] - var1_2, points[4] - var1_2);
            }
            case 4: {
                return Float.NaN;
            }
            case 5: {
                void var2_3;
                void var1_2;
                return BezierKt.findFirstCubicRoot(points[0] - var1_2, points[2] - var1_2, points[4] - var1_2, (float)(var2_3[6] - var1_2));
            }
            case 6: {
                return Float.NaN;
            }
            case 7: {
                return Float.NaN;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    private static final float findFirstLineRoot(float p0, float p1) {
        float f;
        float f2;
        void var1_1;
        float r$iv = -p0 / (var1_1 - p0);
        if (f2 < 0.0f) {
            if (r$iv >= -8.34465E-7f) {
                return 0.0f;
            }
            return Float.NaN;
        }
        if (r$iv > 1.0f) {
            if (r$iv <= 1.0000008f) {
                return 1.0f;
            }
            return Float.NaN;
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    private static final float findFirstQuadraticRoot(float p0, float p1, float p2) {
        void var2_2;
        void var1_1;
        double a = p0;
        double b = (double)var1_1;
        double c = (double)var2_2;
        double d = a - b * 2.0 + c;
        if (!(d == 0.0)) {
            float f;
            float f2;
            float root;
            float f3;
            void var3_3;
            double d2 = b;
            double v1 = -Math.sqrt(d2 * d2 - a * c);
            void v2 = -var3_3 + b;
            float r$iv = (float)(-(v1 + v2) / d);
            float f4 = f3 < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : (root = r$iv));
            if (!Float.isNaN(f4)) {
                return root;
            }
            r$iv = (float)((v1 - v2) / d);
            if (f2 < 0.0f) {
                if (r$iv >= -8.34465E-7f) {
                    return 0.0f;
                }
                return Float.NaN;
            }
            if (r$iv > 1.0f) {
                if (r$iv <= 1.0000008f) {
                    return 1.0f;
                }
                return Float.NaN;
            }
            return f;
        }
        if (!(b == c)) {
            float f;
            float r$iv = (float)((b * 2.0 - c) / (b * 2.0 - c * 2.0));
            if (f < 0.0f) {
                if (r$iv >= -8.34465E-7f) {
                    return 0.0f;
                }
                return Float.NaN;
            }
            if (r$iv > 1.0f) {
                if (r$iv <= 1.0000008f) {
                    return 1.0f;
                }
                return Float.NaN;
            }
            return r$iv;
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public static final float findFirstCubicRoot(float p0, float p1, float p2, float p3) {
        float f;
        double d;
        void var3_3;
        void var2_2;
        double d2;
        double a = 3.0 * ((double)p0 - 2.0 * (double)p1 + (double)p2);
        double b = 3.0 * (double)(p1 - p0);
        double c = p0;
        double d3 = d2 = (double)(-p0) + 3.0 * (double)(p1 - var2_2) + (double)var3_3;
        if (Math.abs(d) < 1.0E-7) {
            float f2;
            float root;
            float f3;
            double d4;
            d3 = a;
            if (Math.abs(d4) < 1.0E-7) {
                float f4;
                double d5;
                d3 = b;
                if (Math.abs(d5) < 1.0E-7) {
                    return Float.NaN;
                }
                float r$iv = (float)(-c / b);
                if (f4 < 0.0f) {
                    if (r$iv >= -8.34465E-7f) {
                        return 0.0f;
                    }
                    return Float.NaN;
                }
                if (r$iv > 1.0f) {
                    if (r$iv <= 1.0000008f) {
                        return 1.0f;
                    }
                    return Float.NaN;
                }
                return r$iv;
            }
            double d6 = b;
            double q = Math.sqrt(d6 * d6 - a * 4.0 * c);
            double a2 = a * 2.0;
            float r$iv = (float)((q - b) / a2);
            float f5 = f3 < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : (root = r$iv));
            if (!Float.isNaN(f5)) {
                return root;
            }
            r$iv = (float)((-b - q) / a2);
            if (f2 < 0.0f) {
                if (r$iv >= -8.34465E-7f) {
                    return 0.0f;
                }
                return Float.NaN;
            }
            if (r$iv > 1.0f) {
                if (r$iv <= 1.0000008f) {
                    return 1.0f;
                }
                return Float.NaN;
            }
            return r$iv;
        }
        double d7 = a /= d2;
        double o3 = ((b /= d2) * 3.0 - d7 * d7) / 9.0;
        double q2 = (a * 2.0 * a * a - a * 9.0 * b + (c /= d2) * 27.0) / 54.0;
        double d8 = o3;
        double discriminant = q2 * q2 + d8 * d8 * o3;
        double a3 = a / 3.0;
        if (discriminant < 0.0) {
            void var1_1;
            float f6;
            float f7;
            float f8;
            float root;
            float f9;
            double d9;
            double d10;
            double d11 = o3;
            double d12 = -(d11 * d11 * o3);
            double r = Math.sqrt(d12);
            double d13 = d10 = -q2 / r;
            double $this$fastCoerceAtLeast$iv$iv = d10;
            double $this$fastCoerceAtMost$iv$iv = d9 < -1.0 ? -1.0 : $this$fastCoerceAtLeast$iv$iv;
            double d14 = $this$fastCoerceAtMost$iv$iv > 1.0 ? 1.0 : $this$fastCoerceAtMost$iv$iv;
            double phi = Math.acos(d14);
            float t1 = 2.0f * MathHelpersKt.fastCbrt((float)((float)r));
            float r$iv = (float)((double)t1 * Math.cos(phi / 3.0) - a3);
            float f10 = f9 < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : (root = r$iv));
            if (!Float.isNaN(f10)) {
                return root;
            }
            r$iv = (float)((double)t1 * Math.cos((phi + Math.PI * 2) / 3.0) - a3);
            float f11 = f8 < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : (r$iv = r$iv));
            if (!Float.isNaN(f11)) {
                return r$iv;
            }
            r$iv = (float)((double)f7 * Math.cos((phi + Math.PI * 4) / 3.0) - a3);
            if (f6 < 0.0f) {
                if (r$iv >= -8.34465E-7f) {
                    return 0.0f;
                }
                return Float.NaN;
            }
            if (r$iv > 1.0f) {
                if (r$iv <= 1.0000008f) {
                    return 1.0f;
                }
                return Float.NaN;
            }
            return (float)var1_1;
        }
        if (discriminant == 0.0) {
            float f12;
            float root;
            float f13;
            float u1 = -MathHelpersKt.fastCbrt((float)((float)q2));
            float r$iv = u1 * 2.0f - (float)a3;
            float f14 = f13 < 0.0f ? (r$iv >= -8.34465E-7f ? 0.0f : Float.NaN) : (r$iv > 1.0f ? (r$iv <= 1.0000008f ? 1.0f : Float.NaN) : (root = r$iv));
            if (!Float.isNaN(f14)) {
                return root;
            }
            r$iv = -u1 - (float)a3;
            if (f12 < 0.0f) {
                if (r$iv >= -8.34465E-7f) {
                    return 0.0f;
                }
                return Float.NaN;
            }
            if (r$iv > 1.0f) {
                if (r$iv <= 1.0000008f) {
                    return 1.0f;
                }
                return Float.NaN;
            }
            return r$iv;
        }
        double sd = Math.sqrt(discriminant);
        float u1 = MathHelpersKt.fastCbrt((float)((float)(-q2 + sd)));
        float v1 = MathHelpersKt.fastCbrt((float)((float)(q2 + sd)));
        float r$iv = (float)((double)(u1 - v1) - a3);
        if (f < 0.0f) {
            if (r$iv >= -8.34465E-7f) {
                return 0.0f;
            }
            return Float.NaN;
        }
        if (r$iv > 1.0f) {
            if (r$iv <= 1.0000008f) {
                return 1.0f;
            }
            return Float.NaN;
        }
        return r$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final int findLineRoot(float p0, float p1, float[] roots, int index) {
        void var3_3;
        void var2_2;
        float f;
        void var1_1;
        return BezierKt.access$writeValidRootInUnitRange(-p0 / (var1_1 - f), (float[])var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int findLineRoot$default(float p0, float p1, float[] roots, int index, int n, Object object) {
        void var3_3;
        void var2_2;
        float f;
        void var1_1;
        if ((n & 8) != 0) {
            index = 0;
        }
        return BezierKt.access$writeValidRootInUnitRange(-p0 / (var1_1 - f), (float[])var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static final int findQuadraticRoots(float p0, float p1, float p2, float[] roots, int index) {
        void var0_1;
        double a = p0;
        double b = p1;
        double c = p2;
        double d = a - b * 2.0 + c;
        int rootCount = 0;
        if (!(d == 0.0)) {
            double d2 = b;
            double v1 = -Math.sqrt(d2 * d2 - a * c);
            double v2 = -a + b;
            rootCount = 0 + BezierKt.writeValidRootInUnitRange((float)(-(v1 + v2) / d), roots, index);
            if ((rootCount += BezierKt.writeValidRootInUnitRange((float)((v1 - v2) / d), roots, index + rootCount)) > 1) {
                void var2_3;
                void var1_2;
                float s = roots[index];
                float t = roots[index + 1];
                if (s > t) {
                    roots[index] = t;
                    roots[index + 1] = s;
                } else if (var1_2 == var2_3) {
                    --rootCount;
                }
            }
        } else if (!(b == c)) {
            void var3_4;
            rootCount = 0 + BezierKt.writeValidRootInUnitRange((float)((b * 2.0 - c) / (b * 2.0 - c * 2.0)), (float[])var3_4, index);
        }
        return (int)var0_1;
    }

    static /* synthetic */ int findQuadraticRoots$default(float f, float f2, float f3, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return BezierKt.findQuadraticRoots(f, f2, f3, fArray, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final int findDerivativeRoots(PathSegment segment, boolean horizontal, float[] roots, int index) {
        int offset = horizontal ? 0 : 1;
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                float d0 = 2.0f * (points[offset + 2] - points[offset]);
                float d1 = 2.0f * (points[offset + 4] - points[offset + 2]);
                return BezierKt.access$writeValidRootInUnitRange(-d0 / (d1 - d0), roots, index);
            }
            case 4: {
                return 0;
            }
            case 5: {
                void var3_6;
                void var2_5;
                void var0_2;
                void var1_4;
                float d0 = 3.0f * (points[offset + 2] - points[offset]);
                float d1 = 3.0f * (points[offset + 4] - points[offset + 2]);
                float d2 = 3.0f * (points[offset + 6] - points[offset + 4]);
                int count = BezierKt.findQuadraticRoots(d0, d1, d2, roots, index);
                float dd0 = 2.0f * (d1 - d0);
                float dd1 = 2.0f * (d2 - d1);
                int index$iv = index + count;
                return count + BezierKt.access$writeValidRootInUnitRange(-dd0 / (var1_4 - var0_2), (float[])var2_5, (int)var3_6);
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 0;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    public static final long computeHorizontalBounds(PathSegment segment, float[] roots, int index) {
        void var3_9;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        int count = BezierKt.findDerivativeRoots(segment, true, roots, index);
        PathSegment pathSegment = segment;
        float f = pathSegment.getPoints()[0];
        float f2 = BezierKt.getEndX(segment);
        float minX = Math.min(f, f2);
        PathSegment pathSegment2 = segment;
        float f3 = pathSegment2.getPoints()[0];
        float f4 = BezierKt.getEndX(segment);
        float maxX = Math.max(f3, f4);
        for (int i = 0; i < count; ++i) {
            float t = roots[i];
            float x = BezierKt.evaluateX(segment, t);
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
        }
        return FloatFloatPair.constructor-impl((float)var3_9, (float)maxX);
    }

    public static /* synthetic */ long computeHorizontalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeHorizontalBounds(pathSegment, fArray, n);
    }

    /*
     * WARNING - void declaration
     */
    public static final long computeVerticalBounds(PathSegment segment, float[] roots, int index) {
        void var3_9;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        int count = BezierKt.findDerivativeRoots(segment, false, roots, index);
        PathSegment pathSegment = segment;
        float f = pathSegment.getPoints()[1];
        float f2 = BezierKt.getEndY(segment);
        float minY = Math.min(f, f2);
        PathSegment pathSegment2 = segment;
        float f3 = pathSegment2.getPoints()[1];
        float f4 = BezierKt.getEndY(segment);
        float maxY = Math.max(f3, f4);
        for (int i = 0; i < count; ++i) {
            float t = roots[i];
            float x = BezierKt.evaluateY(segment, t);
            minY = Math.min(minY, x);
            maxY = Math.max(maxY, x);
        }
        return FloatFloatPair.constructor-impl((float)var3_9, (float)maxY);
    }

    public static /* synthetic */ long computeVerticalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeVerticalBounds(pathSegment, fArray, n);
    }

    public static final long computeCubicVerticalBounds(float p0y, float p1y, float p2y, float p3y, float[] roots, int index) {
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        float d0 = 3.0f * (p1y - p0y);
        float d1 = 3.0f * (p2y - p1y);
        float d2 = 3.0f * (p3y - p2y);
        int count = BezierKt.findQuadraticRoots(d0, d1, d2, roots, index);
        float dd0 = 2.0f * (d1 - d0);
        float dd1 = 2.0f * (d2 - d1);
        int index$iv = index + count;
        float minY = Math.min(p0y, p3y);
        float maxY = Math.max(p0y, p3y);
        int n = count += BezierKt.access$writeValidRootInUnitRange(-dd0 / (dd1 - dd0), roots, index$iv);
        for (int i = 0; i < n; ++i) {
            float t = roots[i];
            float y = BezierKt.evaluateCubic(p0y, p1y, p2y, p3y, t);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return FloatFloatPair.constructor-impl((float)minY, (float)maxY);
    }

    public static /* synthetic */ long computeCubicVerticalBounds$default(float f, float f2, float f3, float f4, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        return BezierKt.computeCubicVerticalBounds(f, f2, f3, f4, fArray, n);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean closeTo(double $this$closeTo, double b) {
        void var2_1;
        return Math.abs($this$closeTo - var2_1) < 1.0E-7;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean closeTo(float $this$closeTo, float b) {
        void var1_1;
        return Math.abs($this$closeTo - var1_1) < 8.34465E-7f;
    }

    private static final float clampValidRootInUnitRange(float r) {
        float f;
        if (r < 0.0f) {
            if (r >= -8.34465E-7f) {
                return 0.0f;
            }
            return Float.NaN;
        }
        if (r > 1.0f) {
            if (r <= 1.0000008f) {
                return 1.0f;
            }
            return Float.NaN;
        }
        return f;
    }

    private static final int writeValidRootInUnitRange(float r, float[] roots, int index) {
        float f;
        float v;
        var1_1[var2_2] = v = r < 0.0f ? (r >= -8.34465E-7f ? 0.0f : Float.NaN) : (r > 1.0f ? (r <= 1.0000008f ? 1.0f : Float.NaN) : v);
        if (Float.isNaN(f)) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static final int lineWinding(float[] points, float x, float y) {
        void var0_1;
        void var3_4;
        void var1_2;
        void var2_3;
        float y0;
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        float x0 = points[0];
        float yo = y0 = points[1];
        float x1 = points[2];
        float y1 = points[3];
        float dy = y1 - y0;
        int direction = 1;
        if (y0 > y1) {
            y0 = y1;
            y1 = yo;
            direction = -1;
        }
        if (y < y0 || y >= y1) {
            return 0;
        }
        float crossProduct = (x1 - x0) * (var2_3 - yo) - dy * (var1_2 - var3_4);
        if (crossProduct == 0.0f) {
            direction = 0;
        } else if ((int)Math.signum((float)var0_1) == direction) {
            direction = 0;
        }
        return direction;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isQuadraticMonotonic(float y0, float y1, float y2) {
        void var2_2;
        void var1_1;
        return !(Math.signum(y0 - y1) + Math.signum((float)(var1_1 - var2_2)) == 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static final int quadraticWinding(float[] points, float x, float y, float[] tmpQuadratics, float[] tmpRoots) {
        void var0_1;
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)tmpQuadratics, (String)"tmpQuadratics");
        Intrinsics.checkNotNullParameter((Object)tmpRoots, (String)"tmpRoots");
        float y0 = points[1];
        float y1 = points[3];
        float y2 = points[5];
        if (BezierKt.isQuadraticMonotonic(y0, y1, y2)) {
            return BezierKt.monotonicQuadraticWinding(points, 0, x, y, tmpRoots);
        }
        int rootCount = BezierKt.quadraticToMonotonicQuadratics(points, tmpQuadratics);
        int winding = BezierKt.monotonicQuadraticWinding(tmpQuadratics, 0, x, y, tmpRoots);
        if (var0_1 > 0) {
            void var2_3;
            void var1_2;
            void var3_4;
            winding += BezierKt.monotonicQuadraticWinding((float[])var3_4, 4, (float)var1_2, (float)var2_3, tmpRoots);
        }
        return winding;
    }

    /*
     * WARNING - void declaration
     */
    private static final int monotonicQuadraticWinding(float[] points, int offset, float x, float y, float[] tmpRoots) {
        void var2_3;
        void var1_2;
        void var3_4;
        float[] fArray;
        float y0 = points[offset + 1];
        float y2 = points[offset + 5];
        int direction = 1;
        if (y0 > y2) {
            float swap = y2;
            y2 = y0;
            y0 = swap;
            direction = -1;
        }
        if (y < y0 || y >= y2) {
            return 0;
        }
        y0 = points[offset + 1];
        float y1 = points[offset + 3];
        y2 = points[offset + 5];
        float xt = (offset = BezierKt.findQuadraticRoots$default(y0 - y1 * 2.0f + y2, 2.0f * (y1 - y0), y0 - y, tmpRoots, 0, 16, null)) == 0 ? points[1 - direction << 1] : BezierKt.evaluateQuadratic(points[0], points[2], points[4], tmpRoots[0]);
        float f = xt;
        if (!(!(Math.abs(xt - x) < 8.34465E-7f) || x == fArray[4] && var3_4 == y2)) {
            return 0;
        }
        if (var1_2 < var2_3) {
            return direction;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final int quadraticToMonotonicQuadratics(float[] quadratic, float[] dst) {
        void var3_3;
        float[] fArray;
        float y0 = quadratic[1];
        float y1 = quadratic[3];
        float y2 = quadratic[5];
        if (!BezierKt.isQuadraticMonotonic(y0, y1, y2)) {
            float f;
            float t = BezierKt.unitDivide(y0 - y1, y0 - y1 - y1 + y2);
            if (!Float.isNaN(t)) {
                BezierKt.splitQuadraticAt(quadratic, dst, t);
                return 1;
            }
            y1 = Math.abs(y0 - y1) < Math.abs(y1 - y2) ? f : y2;
        }
        ArraysKt.copyInto((float[])fArray, (float[])dst, (int)0, (int)0, (int)6);
        var1_1[3] = var3_3;
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final void splitQuadraticAt(float[] src, float[] dst, float t) {
        void var0_1;
        void var3_4;
        void var2_3;
        float p0x = src[0];
        float p0y = src[1];
        float p1x = src[2];
        float p1y = src[3];
        float p2x = src[4];
        float p2y = src[5];
        float abx = MathHelpersKt.lerp((float)p0x, (float)p1x, (float)t);
        float aby = MathHelpersKt.lerp((float)p0y, (float)p1y, (float)t);
        dst[0] = p0x;
        dst[1] = p0y;
        dst[2] = abx;
        dst[3] = aby;
        float bcx = MathHelpersKt.lerp((float)p1x, (float)p2x, (float)t);
        float bcy = MathHelpersKt.lerp((float)p1y, (float)p2y, (float)t);
        float abcx = MathHelpersKt.lerp((float)abx, (float)bcx, (float)t);
        float abcy = MathHelpersKt.lerp((float)aby, (float)bcy, (float)t);
        dst[4] = abcx;
        dst[5] = var2_3;
        dst[6] = var3_4;
        dst[7] = bcy;
        dst[8] = p2x;
        var1_2[9] = var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private static final float unitDivide(float x, float y) {
        float f;
        void var1_1;
        void d;
        float n = x;
        if (n < 0.0f) {
            n = -n;
            d = -d;
        }
        if (d == 0.0f || n == 0.0f || n >= d) {
            return Float.NaN;
        }
        float r = n / var1_1;
        if (r == 0.0f) {
            return Float.NaN;
        }
        return f;
    }

    public static final int cubicWinding(float[] points, float x, float y, float[] tmpCubics, float[] tmpRoots) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)tmpCubics, (String)"tmpCubics");
        Intrinsics.checkNotNullParameter((Object)tmpRoots, (String)"tmpRoots");
        int splits = BezierKt.cubicToMonotonicCubics(points, tmpCubics, tmpRoots);
        int winding = 0;
        int i = 0;
        if (splits >= 0) {
            while (true) {
                winding += BezierKt.monotonicCubicWinding(tmpCubics, i * 3 << 1, x, y);
                if (i == splits) break;
                ++i;
            }
        }
        return winding;
    }

    /*
     * WARNING - void declaration
     */
    private static final int monotonicCubicWinding(float[] points, int offset, float x, float y) {
        void var2_4;
        void var0_1;
        void var3_5;
        float f;
        float xt;
        void var1_2;
        float y0 = points[offset + 1];
        float y3 = points[offset + 7];
        int direction = 1;
        if (y0 > y3) {
            float swap = y3;
            y3 = y0;
            y0 = swap;
            direction = -1;
        }
        if (y < y0 || y >= y3) {
            return 0;
        }
        float x0 = points[offset];
        float x1 = points[offset + 2];
        float x2 = points[offset + 4];
        float x3 = points[offset + 6];
        float min = Math.min(x0, Math.min(x1, Math.min(x2, x3)));
        if (x < min) {
            return 0;
        }
        float max = Math.max(x0, Math.max(x1, Math.max(x2, x3)));
        if (x > max) {
            return direction;
        }
        float f2 = points[offset + 1];
        float y1 = points[offset + 3];
        float y2 = points[offset + 5];
        y3 = points[var1_2 + 7];
        float root = BezierKt.findFirstCubicRoot(f2 - y, y1 - y, y2 - y, y3 - y);
        if (Float.isNaN(root)) {
            return 0;
        }
        float f3 = xt = BezierKt.evaluateCubic(x0, x1, x2, x3, root);
        if (!(!(Math.abs(f - x) < 8.34465E-7f) || x == x3 && var3_5 == y3)) {
            return 0;
        }
        if (var0_1 < var2_4) {
            return direction;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final int cubicToMonotonicCubics(float[] cubic, float[] dst, float[] tmpRoot) {
        void var3_3;
        int rootCount = BezierKt.findCubicExtremaY(cubic, tmpRoot);
        if (rootCount == 0) {
            ArraysKt.copyInto((float[])cubic, (float[])dst, (int)0, (int)0, (int)8);
        } else {
            float lastT = 0.0f;
            int dstOffset = 0;
            for (int i = 0; i < rootCount; ++i) {
                float[] src;
                float f;
                float f2 = tmpRoot[i];
                float $this$fastCoerceAtLeast$iv$iv = lastT = (f2 - lastT) / (1.0f - lastT);
                float $this$fastCoerceAtMost$iv$iv = f < 0.0f ? 0.0f : $this$fastCoerceAtLeast$iv$iv;
                float t = $this$fastCoerceAtMost$iv$iv > 1.0f ? 1.0f : $this$fastCoerceAtMost$iv$iv;
                float f3 = t;
                BezierKt.splitCubicAt(src, dstOffset, dst, dstOffset, t);
                src = dst;
                dstOffset += 6;
            }
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final int findCubicExtremaY(float[] cubic2, float[] dstRoots) {
        void var1_2;
        void var2_3;
        void var0_1;
        void var3_4;
        float a = cubic2[1];
        float b = cubic2[3];
        float c = cubic2[5];
        float cubic2 = cubic2[7];
        float A = cubic2 - a + 3.0f * (b - c);
        float B = 2.0f * (a - b - b - c);
        void C = var3_4 - a;
        return BezierKt.findQuadraticRoots((float)var0_1, B, (float)var2_3, (float[])var1_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void splitCubicAt(float[] src, int srcOffset, float[] dst, int dstOffset, float t) {
        void var0_1;
        void var1_3;
        if (t >= 1.0f) {
            ArraysKt.copyInto((float[])src, (float[])dst, (int)dstOffset, (int)srcOffset, (int)8);
            float x = src[srcOffset + 6];
            float y = src[srcOffset + 7];
            dst[dstOffset + 8] = x;
            dst[dstOffset + 9] = y;
            dst[dstOffset + 10] = x;
            dst[dstOffset + 11] = y;
            dst[dstOffset + 12] = x;
            dst[dstOffset + 13] = y;
            return;
        }
        float p0x = src[srcOffset];
        float p0y = src[srcOffset + 1];
        dst[dstOffset] = p0x;
        dst[dstOffset + 1] = p0y;
        float p1x = src[srcOffset + 2];
        float p1y = src[srcOffset + 3];
        float abx = MathHelpersKt.lerp((float)p0x, (float)p1x, (float)t);
        float aby = MathHelpersKt.lerp((float)p0y, (float)p1y, (float)t);
        dst[dstOffset + 2] = abx;
        dst[dstOffset + 3] = aby;
        float p2x = src[srcOffset + 4];
        float p2y = src[srcOffset + 5];
        float bcx = MathHelpersKt.lerp((float)p1x, (float)p2x, (float)t);
        float bcy = MathHelpersKt.lerp((float)p1y, (float)p2y, (float)t);
        float abcx = MathHelpersKt.lerp((float)abx, (float)bcx, (float)t);
        float abcy = MathHelpersKt.lerp((float)aby, (float)bcy, (float)t);
        dst[dstOffset + 4] = abcx;
        dst[dstOffset + 5] = abcy;
        float p3x = src[srcOffset + 6];
        float p3y = src[srcOffset + 7];
        float cdx = MathHelpersKt.lerp((float)p2x, (float)p3x, (float)t);
        float cdy = MathHelpersKt.lerp((float)p2y, (float)p3y, (float)t);
        float bcdx = MathHelpersKt.lerp((float)bcx, (float)cdx, (float)t);
        float bcdy = MathHelpersKt.lerp((float)bcy, (float)cdy, (float)t);
        float abcdx = MathHelpersKt.lerp((float)abcx, (float)bcdx, (float)t);
        float abcdy = MathHelpersKt.lerp((float)abcy, (float)bcdy, (float)t);
        dst[dstOffset + 6] = abcdx;
        dst[dstOffset + 7] = abcdy;
        dst[dstOffset + 8] = bcdx;
        dst[dstOffset + 9] = bcdy;
        dst[dstOffset + 10] = var1_3;
        dst[dstOffset + 11] = cdy;
        dst[dstOffset + 12] = p3x;
        var2_4[var3_5 + 13] = var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final float cubicArea(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        void var1_1;
        float f;
        void var2_2;
        void var3_3;
        return ((y3 - y0) * (x1 + x2) - (x3 - x0) * (y1 + y2) + var3_3 * (x0 - x2) - var2_2 * (y0 - y2) + y3 * (x2 + f / 3.0f) - x3 * (y2 + var1_1 / 3.0f)) * 3.0f / 20.0f;
    }

    private static final float getStartX(PathSegment $this$startX) {
        return $this$startX.getPoints()[0];
    }

    private static final float getEndX(PathSegment $this$endX) {
        int n;
        PathSegment pathSegment;
        float[] fArray = $this$endX.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 7: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fArray[n];
    }

    private static final float getStartY(PathSegment $this$startY) {
        return $this$startY.getPoints()[1];
    }

    private static final float getEndY(PathSegment $this$endY) {
        int n;
        PathSegment pathSegment;
        float[] fArray = $this$endY.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[pathSegment.getType().ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 7;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 7: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fArray[n];
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int access$writeValidRootInUnitRange(float r, float[] roots, int index) {
        void var2_2;
        void var1_1;
        return BezierKt.writeValidRootInUnitRange(r, (float[])var1_1, (int)var2_2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Close.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

