/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

@ConfiguratorRank(value=0)
public class DefaultJoranConfigurator
extends ContextAwareBase
implements Configurator {
    @Override
    public Configurator.ExecutionStatus configure(LoggerContext context) {
        URL url = this.performMultiStepConfigurationFileSearch(true);
        if (url != null) {
            JoranException joranException;
            try {
                this.configureByResource((URL)((Object)joranException));
            }
            catch (JoranException joranException2) {
                joranException = joranException2;
                joranException2.printStackTrace();
            }
            return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
        }
        return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
    }

    /*
     * WARNING - void declaration
     */
    private URL performMultiStepConfigurationFileSearch(boolean updateStatus) {
        void var1_1;
        void var2_2;
        ClassLoader myClassLoader = Loader.getClassLoaderOfObject((Object)this);
        URL url = this.findConfigFileURLFromSystemProperties(myClassLoader, updateStatus);
        if (url != null) {
            return url;
        }
        url = this.getResource("logback-test.xml", myClassLoader, updateStatus);
        if (url != null) {
            void var3_3;
            return var3_3;
        }
        return this.getResource("logback.xml", (ClassLoader)var2_2, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void configureByResource(URL url) throws JoranException {
        void var1_1;
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String string = url.toString();
        if (string.endsWith("xml")) {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(this.context);
            string.doConfigure(url);
            return;
        }
        throw new LogbackException("Unexpected filename extension of file [" + var1_1.toString() + "]. Should be .xml");
    }

    /*
     * WARNING - void declaration
     */
    public URL findURLOfDefaultConfigurationFile(boolean updateStatus) {
        void var1_1;
        return this.performMultiStepConfigurationFileSearch((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private URL findConfigFileURLFromSystemProperties(ClassLoader classLoader, boolean updateStatus) {
        String logbackConfigFile = OptionHelper.getSystemProperty((String)"logback.configurationFile");
        if (logbackConfigFile != null) {
            URL result = null;
            try {
                URL uRL = result = new URL(logbackConfigFile);
                if (updateStatus) {
                    this.statusOnResourceSearch(logbackConfigFile, classLoader, result);
                }
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                block14: {
                    block13: {
                        try {
                            result = Loader.getResource((String)logbackConfigFile, (ClassLoader)classLoader);
                            if (result == null) break block13;
                            URL uRL = result;
                            if (updateStatus) {
                                this.statusOnResourceSearch(logbackConfigFile, classLoader, result);
                            }
                            return uRL;
                        }
                        catch (Throwable throwable) {
                            void var2_2;
                            if (var2_2 != false) {
                                void var1_1;
                                void var3_3;
                                this.statusOnResourceSearch((String)var3_3, (ClassLoader)var1_1, result);
                            }
                            throw throwable;
                        }
                    }
                    File f = new File(logbackConfigFile);
                    if (!f.exists() || !f.isFile()) break block14;
                    try {
                        URL uRL = result = f.toURI().toURL();
                        if (updateStatus) {
                            this.statusOnResourceSearch(logbackConfigFile, classLoader, result);
                        }
                        return uRL;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
                if (updateStatus) {
                    this.statusOnResourceSearch(logbackConfigFile, classLoader, result);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private URL getResource(String filename, ClassLoader myClassLoader, boolean updateStatus) {
        void var3_3;
        URL url = Loader.getResource((String)filename, (ClassLoader)myClassLoader);
        if (var3_3 != false) {
            void var2_2;
            void var1_1;
            this.statusOnResourceSearch((String)var1_1, (ClassLoader)var2_2, url);
        }
        return url;
    }

    /*
     * WARNING - void declaration
     */
    private void statusOnResourceSearch(String resourceName, ClassLoader classLoader, URL url) {
        void var2_2;
        void var1_1;
        void var3_3;
        StatusManager sm = this.context.getStatusManager();
        if (url == null) {
            sm.add((Status)new InfoStatus("Could NOT find resource [" + resourceName + "]", (Object)this.context));
            return;
        }
        sm.add((Status)new InfoStatus("Found resource [" + resourceName + "] at [" + var3_3.toString() + "]", (Object)this.context));
        this.multiplicityWarning((String)var1_1, (ClassLoader)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void multiplicityWarning(String resourceName, ClassLoader classLoader) {
        Set urlSet = null;
        try {
            urlSet = Loader.getResources((String)resourceName, (ClassLoader)classLoader);
        }
        catch (IOException e) {
            void var2_3;
            this.addError("Failed to get url list for resource [" + resourceName + "]", (Throwable)var2_3);
        }
        if (urlSet != null && urlSet.size() > 1) {
            this.addWarn("Resource [" + resourceName + "] occurs multiple times on the classpath.");
            for (URL url : urlSet) {
                void var3_4;
                this.addWarn("Resource [" + resourceName + "] occurs at [" + var3_4.toString() + "]");
            }
        }
    }
}

