/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Marker;

public final class TurboFilterList
extends CopyOnWriteArrayList<TurboFilter> {
    private static final long serialVersionUID = 1L;

    public final FilterReply getTurboFilterChainDecision(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        int n = this.size();
        if (n == 1) {
            try {
                TurboFilter turboFilter = (TurboFilter)((Object)this.get(0));
                return turboFilter.decide(marker, logger, level, format, params, t);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return FilterReply.NEUTRAL;
            }
        }
        Object[] tfa = this.toArray();
        int len = tfa.length;
        for (int i = 0; i < len; ++i) {
            TurboFilter turboFilter = (TurboFilter)((Object)tfa[i]);
            FilterReply r = turboFilter.decide(marker, logger, level, format, params, t);
            if (r != FilterReply.DENY && r != FilterReply.ACCEPT) continue;
            return r;
        }
        return FilterReply.NEUTRAL;
    }
}

