/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.PackagingDataCalculator;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class ThrowableProxy
implements IThrowableProxy {
    static final StackTraceElementProxy[] EMPTY_STEP = new StackTraceElementProxy[0];
    private Throwable throwable;
    private String className;
    private String message;
    StackTraceElementProxy[] stackTraceElementProxyArray;
    int commonFrames;
    private ThrowableProxy cause;
    private ThrowableProxy[] suppressed = NO_SUPPRESSED;
    private transient PackagingDataCalculator packagingDataCalculator;
    private boolean calculatedPackageData = false;
    private boolean cyclic;
    private static final ThrowableProxy[] NO_SUPPRESSED = new ThrowableProxy[0];

    /*
     * WARNING - void declaration
     */
    public ThrowableProxy(Throwable throwable) {
        this((Throwable)var1_1, Collections.newSetFromMap(new IdentityHashMap()));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ThrowableProxy(Throwable circular, boolean isCyclic) {
        void var1_1;
        this.throwable = circular;
        this.className = circular.getClass().getName();
        this.message = var1_1.getMessage();
        this.stackTraceElementProxyArray = EMPTY_STEP;
        this.cyclic = true;
    }

    /*
     * WARNING - void declaration
     */
    public ThrowableProxy(Throwable throwable, Set<Throwable> alreadyProcessedSet) {
        Object[] throwableSuppressed;
        this.throwable = throwable;
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray(throwable.getStackTrace());
        this.cyclic = false;
        alreadyProcessedSet.add(throwable);
        Throwable nested = throwable.getCause();
        if (nested != null) {
            if (alreadyProcessedSet.contains(nested)) {
                this.cause = new ThrowableProxy(nested, true);
            } else {
                this.cause = new ThrowableProxy(nested, alreadyProcessedSet);
                this.cause.commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames(nested.getStackTrace(), this.stackTraceElementProxyArray);
            }
        }
        if (OptionHelper.isNotEmtpy((Object[])(throwableSuppressed = throwable.getSuppressed()))) {
            void var3_3;
            void var1_1;
            ArrayList<ThrowableProxy> suppressedList = new ArrayList<ThrowableProxy>(throwableSuppressed.length);
            for (void sup : var1_1) {
                ThrowableProxy throwableProxy;
                if (alreadyProcessedSet.contains(sup)) {
                    throwableProxy = new ThrowableProxy((Throwable)sup, true);
                    suppressedList.add(throwableProxy);
                    continue;
                }
                throwableProxy = new ThrowableProxy((Throwable)sup, alreadyProcessedSet);
                new ThrowableProxy((Throwable)sup, alreadyProcessedSet).commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames(sup.getStackTrace(), this.stackTraceElementProxyArray);
                suppressedList.add(throwableProxy);
            }
            void v0 = var3_3;
            this.suppressed = v0.toArray(new ThrowableProxy[v0.size()]);
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StackTraceElementProxy[] getStackTraceElementProxyArray() {
        return this.stackTraceElementProxyArray;
    }

    @Override
    public boolean isCyclic() {
        return this.cyclic;
    }

    @Override
    public int getCommonFrames() {
        return this.commonFrames;
    }

    @Override
    public IThrowableProxy getCause() {
        return this.cause;
    }

    @Override
    public IThrowableProxy[] getSuppressed() {
        return this.suppressed;
    }

    public PackagingDataCalculator getPackagingDataCalculator() {
        if (this.throwable != null && this.packagingDataCalculator == null) {
            this.packagingDataCalculator = new PackagingDataCalculator();
        }
        return this.packagingDataCalculator;
    }

    /*
     * WARNING - void declaration
     */
    public void calculatePackagingData() {
        if (this.calculatedPackageData) {
            return;
        }
        PackagingDataCalculator pdc = this.getPackagingDataCalculator();
        if (pdc != null) {
            void var1_1;
            this.calculatedPackageData = true;
            var1_1.calculate(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void fullDump() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        StackTraceElementProxy[] stackTraceElementProxyArray = this.stackTraceElementProxyArray;
        int n = this.stackTraceElementProxyArray.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElementProxy step = stackTraceElementProxyArray[i];
            String string = step.toString();
            builder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData(builder, step);
            builder.append(CoreConstants.LINE_SEPARATOR);
        }
        System.out.println(var1_1.toString());
    }
}

