/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.STEUtil;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;

public class PackagingDataCalculator {
    static final StackTraceElementProxy[] STEP_ARRAY_TEMPLATE = new StackTraceElementProxy[0];
    HashMap<String, ClassPackagingData> cache = new HashMap();
    private static boolean GET_CALLER_CLASS_METHOD_AVAILABLE = false;

    /*
     * WARNING - void declaration
     */
    public void calculate(IThrowableProxy tp) {
        while (tp != null) {
            this.populateFrames(tp.getStackTraceElementProxyArray());
            IThrowableProxy[] suppressed = tp.getSuppressed();
            if (suppressed != null) {
                void var2_2;
                for (void current : var2_2) {
                    this.populateFrames(current.getStackTraceElementProxyArray());
                }
            }
            tp = tp.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    void populateFrames(StackTraceElementProxy[] stepArray) {
        void var1_1;
        void var3_4;
        Throwable throwable = new Throwable("local stack reference");
        StackTraceElement[] localSTEArray = throwable.getStackTrace();
        int commonFrames = STEUtil.findNumberOfCommonFrames(localSTEArray, stepArray);
        int cfr_ignored_0 = localSTEArray.length;
        int stepFirstCommon = stepArray.length - commonFrames;
        for (int i = 0; i < commonFrames; ++i) {
            StackTraceElementProxy step = stepArray[stepFirstCommon + i];
            step.ste.getClassName();
            ClassPackagingData pi = this.computeBySTEP(step, null);
            step.setClassPackagingData(pi);
        }
        this.populateUncommonFrames((int)var3_4, (StackTraceElementProxy[])var1_1, null);
    }

    void populateUncommonFrames(int commonFrames, StackTraceElementProxy[] stepArray, ClassLoader firstExactClassLoader) {
        int uncommonFrames = stepArray.length - commonFrames;
        for (int i = 0; i < uncommonFrames; ++i) {
            StackTraceElementProxy step = stepArray[i];
            ClassPackagingData pi = this.computeBySTEP(step, firstExactClassLoader);
            step.setClassPackagingData(pi);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ClassPackagingData calculateByExactType(Class<?> type) {
        void var2_2;
        ClassPackagingData classPackagingData;
        void var1_1;
        String className = type.getName();
        ClassPackagingData cpd = this.cache.get(className);
        if (cpd != null) {
            return cpd;
        }
        String version = this.getImplementationVersion(type);
        String codeLocation = this.getCodeLocation(type);
        classPackagingData = new ClassPackagingData((String)var1_1, (String)((Object)classPackagingData));
        this.cache.put((String)var2_2, classPackagingData);
        return classPackagingData;
    }

    /*
     * WARNING - void declaration
     */
    private ClassPackagingData computeBySTEP(StackTraceElementProxy step, ClassLoader lastExactClassLoader) {
        void var1_1;
        ClassPackagingData classPackagingData;
        void var2_2;
        String className = step.ste.getClassName();
        ClassPackagingData cpd = this.cache.get(className);
        if (cpd != null) {
            return cpd;
        }
        Class<?> type = this.bestEffortLoadClass(lastExactClassLoader, className);
        String version = this.getImplementationVersion(type);
        String codeLocation = this.getCodeLocation(type);
        classPackagingData = new ClassPackagingData((String)var2_2, (String)((Object)classPackagingData), false);
        this.cache.put((String)var1_1, classPackagingData);
        return classPackagingData;
    }

    /*
     * WARNING - void declaration
     */
    String getImplementationVersion(Class<?> type) {
        if (type == null) {
            return "na";
        }
        Package aPackage = type.getPackage();
        if (aPackage != null) {
            void var1_1;
            String v = aPackage.getImplementationVersion();
            if (v == null) {
                return "na";
            }
            return var1_1;
        }
        return "na";
    }

    /*
     * WARNING - void declaration
     */
    String getCodeLocation(Class<?> type) {
        try {
            URL resource;
            CodeSource codeSource;
            if (type != null && (codeSource = type.getProtectionDomain().getCodeSource()) != null && (resource = codeSource.getLocation()) != null) {
                void var1_1;
                String locationStr = resource.toString();
                String result = this.getCodeLocation(locationStr, '/');
                if (result != null) {
                    void var2_2;
                    return var2_2;
                }
                return this.getCodeLocation((String)var1_1, '\\');
            }
        }
        catch (Exception exception) {}
        return "na";
    }

    /*
     * WARNING - void declaration
     */
    private String getCodeLocation(String locationStr, char separator) {
        int idx = locationStr.lastIndexOf(separator);
        if (this.isFolder(idx, locationStr)) {
            void var2_2;
            idx = locationStr.lastIndexOf((int)var2_2, idx - 1);
            return locationStr.substring(idx + 1);
        }
        if (idx > 0) {
            void var3_3;
            void var1_1;
            return var1_1.substring((int)(var3_3 + true));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFolder(int idx, String text) {
        void var2_2;
        void var1_1;
        return idx != -1 && var1_1 + true == var2_2.length();
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> loadClass(ClassLoader cl, String className) {
        Exception exception;
        if (cl == null) {
            return null;
        }
        try {
            void var2_2;
            return ((ClassLoader)((Object)exception)).loadClass((String)var2_2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> bestEffortLoadClass(ClassLoader lastGuaranteedClassLoader, String className) {
        Exception exception;
        Class<?> result = this.loadClass(lastGuaranteedClassLoader, className);
        if (result != null) {
            return result;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != exception) {
            result = this.loadClass(tccl, className);
        }
        if (result != null) {
            void var3_3;
            return var3_3;
        }
        try {
            void var2_2;
            return Class.forName((String)var2_2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return null;
        }
    }
}

