/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThrowableProxyConverter
extends ThrowableHandlingConverter {
    protected static final int BUILDER_CAPACITY = 2048;
    int lengthOption;
    List<EventEvaluator<ILoggingEvent>> evaluatorList = null;
    List<String> ignoredStackTraceLines = null;
    int errorCount = 0;

    public void start() {
        String lengthStr = this.getFirstOption();
        if (lengthStr == null) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("full".equals(lengthStr = lengthStr.toLowerCase())) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("short".equals(lengthStr)) {
            this.lengthOption = 1;
        } else {
            try {
                this.lengthOption = Integer.parseInt(lengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("Could not parse [" + lengthStr + "] as an integer");
                this.lengthOption = Integer.MAX_VALUE;
            }
        }
        List optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            int optionListSize = optionList.size();
            for (int i = 1; i < optionListSize; ++i) {
                String evaluatorOrIgnoredStackTraceLine = (String)optionList.get(i);
                Object object = this.getContext();
                EventEvaluator ee = (EventEvaluator)(object = (Map)object.getObject("EVALUATOR_MAP")).get(evaluatorOrIgnoredStackTraceLine);
                if (ee != null) {
                    this.addEvaluator((EventEvaluator<ILoggingEvent>)ee);
                    continue;
                }
                this.addIgnoreStackTraceLine(evaluatorOrIgnoredStackTraceLine);
            }
        }
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    private void addEvaluator(EventEvaluator<ILoggingEvent> ee) {
        void var1_1;
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<ILoggingEvent>>();
        }
        this.evaluatorList.add((EventEvaluator<ILoggingEvent>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addIgnoreStackTraceLine(String ignoredStackTraceLine) {
        void var1_1;
        if (this.ignoredStackTraceLines == null) {
            this.ignoredStackTraceLines = new ArrayList<String>();
        }
        this.ignoredStackTraceLines.add((String)var1_1);
    }

    public void stop() {
        this.evaluatorList = null;
        super.stop();
    }

    protected void extraData(StringBuilder builder, StackTraceElementProxy step) {
    }

    /*
     * WARNING - void declaration
     */
    public String convert(ILoggingEvent event) {
        void var2_2;
        IThrowableProxy tp = event.getThrowableProxy();
        if (tp == null) {
            return "";
        }
        if (this.evaluatorList != null) {
            void var3_3;
            boolean printStack = true;
            for (int i = 0; i < this.evaluatorList.size(); ++i) {
                EventEvaluator<ILoggingEvent> ee = this.evaluatorList.get(i);
                try {
                    if (!ee.evaluate((Object)event)) continue;
                    printStack = false;
                    break;
                }
                catch (EvaluationException eex) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + ee.getName() + "]", eex);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    ErrorStatus errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + ee.getName() + "].", (Object)this, (Throwable)eex);
                    errorStatus.add((Status)new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", (Object)this));
                    this.addStatus((Status)errorStatus);
                }
            }
            if (var3_3 == false) {
                return "";
            }
        }
        return this.throwableProxyToString((IThrowableProxy)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected String throwableProxyToString(IThrowableProxy tp) {
        void var2_2;
        void var1_1;
        StringBuilder sb = new StringBuilder(2048);
        this.recursiveAppend(sb, null, 1, (IThrowableProxy)var1_1);
        return var2_2.toString();
    }

    private void recursiveAppend(StringBuilder sb, String prefix, int indent, IThrowableProxy tp) {
        while (tp != null) {
            String string;
            this.subjoinFirstLine(sb, prefix, indent, tp);
            sb.append(CoreConstants.LINE_SEPARATOR);
            this.subjoinSTEPArray(sb, indent, tp);
            IThrowableProxy[] suppressed = tp.getSuppressed();
            if (suppressed != null) {
                for (String current : string) {
                    this.recursiveAppend(sb, "Suppressed: ", indent + 1, (IThrowableProxy)((Object)current));
                }
            }
            tp = tp.getCause();
            string = "Caused by: ";
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private void subjoinFirstLine(StringBuilder buf, String prefix, int indent, IThrowableProxy tp) {
        void var1_1;
        void var3_3;
        ThrowableProxyUtil.indent(buf, (int)(var3_3 - true));
        if (prefix != null) {
            void var2_2;
            buf.append((String)var2_2);
        }
        this.subjoinExceptionMessage((StringBuilder)var1_1, tp);
    }

    /*
     * WARNING - void declaration
     */
    private void subjoinExceptionMessage(StringBuilder buf, IThrowableProxy tp) {
        void var2_2;
        void var1_1;
        if (tp.isCyclic()) {
            buf.append("[CIRCULAR REFERENCE: ").append(tp.getClassName()).append(": ").append(tp.getMessage()).append(']');
            return;
        }
        var1_1.append(tp.getClassName()).append(": ").append(var2_2.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    protected void subjoinSTEPArray(StringBuilder buf, int indent, IThrowableProxy tp) {
        int maxIndex;
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        int commonFrames = tp.getCommonFrames();
        boolean unrestrictedPrinting = this.lengthOption > stepArray.length;
        int n = maxIndex = unrestrictedPrinting ? stepArray.length : this.lengthOption;
        if (commonFrames > 0 && unrestrictedPrinting) {
            maxIndex -= commonFrames;
        }
        int ignoredCount = 0;
        for (int i = 0; i < maxIndex; ++i) {
            StackTraceElementProxy element = stepArray[i];
            if (!this.isIgnoredStackTraceLine(element.toString())) {
                ThrowableProxyUtil.indent(buf, indent);
                this.printStackLine(buf, ignoredCount, element);
                ignoredCount = 0;
                buf.append(CoreConstants.LINE_SEPARATOR);
                continue;
            }
            ++ignoredCount;
            if (maxIndex >= stepArray.length) continue;
            ++maxIndex;
        }
        if (ignoredCount > 0) {
            this.printIgnoredCount(buf, ignoredCount);
            buf.append(CoreConstants.LINE_SEPARATOR);
        }
        if (commonFrames > 0 && unrestrictedPrinting) {
            void var3_3;
            void var1_1;
            void var2_2;
            ThrowableProxyUtil.indent(buf, (int)var2_2);
            var1_1.append("... ").append(var3_3.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printStackLine(StringBuilder buf, int ignoredCount, StackTraceElementProxy element) {
        void var3_3;
        buf.append(element);
        this.extraData(buf, (StackTraceElementProxy)var3_3);
        if (ignoredCount > 0) {
            void var2_2;
            void var1_1;
            this.printIgnoredCount((StringBuilder)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printIgnoredCount(StringBuilder buf, int ignoredCount) {
        void var2_2;
        buf.append(" [").append((int)var2_2).append(" skipped]");
    }

    /*
     * WARNING - void declaration
     */
    private boolean isIgnoredStackTraceLine(String line) {
        if (this.ignoredStackTraceLines != null) {
            for (String ignoredStackTraceLine : this.ignoredStackTraceLines) {
                void var3_3;
                if (!line.contains((CharSequence)var3_3)) continue;
                return true;
            }
        }
        return false;
    }
}

