/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;

public class TargetLengthBasedClassNameAbbreviator2
implements Abbreviator {
    final int targetLength;

    /*
     * WARNING - void declaration
     */
    public TargetLengthBasedClassNameAbbreviator2(int targetLength) {
        void var1_1;
        this.targetLength = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String abbreviate(String fqClassName) {
        void var2_2;
        StringBuilder buf = new StringBuilder(this.targetLength);
        if (fqClassName == null) {
            throw new IllegalArgumentException("Class name may not be null");
        }
        int n = fqClassName.length();
        if (n < this.targetLength) {
            return fqClassName;
        }
        int[] dotIndexesArray = new int[16];
        int[] lengthArray = new int[17];
        int dotCount = TargetLengthBasedClassNameAbbreviator2.computeDotIndexes(fqClassName, dotIndexesArray);
        if (dotCount == 0) {
            return fqClassName;
        }
        this.computeLengthArray(fqClassName, dotIndexesArray, lengthArray, dotCount);
        for (int i = 0; i <= dotCount; ++i) {
            if (i == 0) {
                buf.append(fqClassName.substring(0, lengthArray[i] - 1));
                continue;
            }
            buf.append(fqClassName.substring(dotIndexesArray[i - 1], dotIndexesArray[i - 1] + lengthArray[i]));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static int computeDotIndexes(String className, int[] dotArray) {
        void var2_2;
        int k = 0;
        for (int dotCount = 0; (k = className.indexOf(46, k)) != -1 && dotCount < 16; ++dotCount) {
            dotArray[dotCount] = k++;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    void computeLengthArray(String className, int[] dotArray, int[] lengthArray, int dotCount) {
        void var2_2;
        void var1_1;
        int toTrim = className.length() - this.targetLength;
        for (int i = 0; i < dotCount; ++i) {
            int previousDotPosition = i == 0 ? -1 : dotArray[i - 1];
            int charactersInSegment = dotArray[i] - previousDotPosition - 1;
            int len = toTrim > 0 ? (charactersInSegment <= 0 ? charactersInSegment : 1) : charactersInSegment;
            toTrim -= charactersInSegment - len;
            lengthArray[i] = len + 1;
        }
        int lastDotIndex = dotCount - 1;
        var3_3[dotCount] = var1_1.length() - var2_2[lastDotIndex];
    }

    static void printArray(String msg, int[] ia) {
        System.out.print(msg);
        for (int i = 0; i < ia.length; ++i) {
            if (i == 0) {
                System.out.print(ia[i]);
                continue;
            }
            System.out.print(", " + ia[i]);
        }
        System.out.println();
    }
}

