/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.net.SyslogAppenderBase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SyslogStartConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timesmapStr = null;
    SimpleDateFormat simpleMonthFormat;
    SimpleDateFormat simpleTimeFormat;
    private final Calendar calendar = Calendar.getInstance(Locale.US);
    String localHostName;
    int facility;

    /*
     * WARNING - void declaration
     */
    public void start() {
        void var1_1;
        int errorCount = 0;
        String facilityStr = this.getFirstOption();
        if (facilityStr == null) {
            this.addError("was expecting a facility string as an option");
            return;
        }
        this.facility = SyslogAppenderBase.facilityStringToint((String)facilityStr);
        this.localHostName = this.getLocalHostname();
        try {
            this.simpleMonthFormat = new SimpleDateFormat("MMM", Locale.US);
            this.simpleTimeFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            this.addError("Could not instantiate SimpleDateFormat", (Throwable)var2_3);
            ++errorCount;
        }
        if (var1_1 == false) {
            super.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String convert(ILoggingEvent event) {
        void var2_2;
        void var1_1;
        void var3_3;
        StringBuilder sb = new StringBuilder();
        int pri = this.facility + LevelToSyslogSeverity.convert(event);
        sb.append("<");
        sb.append((int)var3_3);
        sb.append(">");
        sb.append(this.computeTimeStampString(var1_1.getTimeStamp()));
        sb.append(' ');
        sb.append(this.localHostName);
        sb.append(' ');
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getLocalHostname() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException uhe) {
            void var1_2;
            this.addError("Could not determine local host name", (Throwable)var1_2);
            return "UNKNOWN_LOCALHOST";
        }
    }

    /*
     * WARNING - void declaration
     */
    String computeTimeStampString(long now) {
        SyslogStartConverter syslogStartConverter = this;
        synchronized (syslogStartConverter) {
            if (now / 1000L != this.lastTimestamp) {
                void var1_2;
                this.lastTimestamp = now / 1000L;
                Date nowDate = new Date(now);
                this.calendar.setTime(nowDate);
                this.timesmapStr = String.format("%s %2d %s", this.simpleMonthFormat.format(nowDate), this.calendar.get(5), this.simpleTimeFormat.format((Date)var1_2));
            }
            return this.timesmapStr;
        }
    }
}

