/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.ClassNameOnlyAbbreviator;
import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.OptionHelper;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class NamedConverter
extends ClassicConverter {
    private static final String DISABLE_CACHE_SYSTEM_PROPERTY = "logback.namedConverter.disableCache";
    private static final int INITIAL_CACHE_SIZE = 512;
    private static final double LOAD_FACTOR = 0.75;
    private static final int MAX_ALLOWED_REMOVAL_THRESHOLD = 1536;
    private static final double CACHE_MISSRATE_TRIGGER = 0.3;
    private static final int MIN_SAMPLE_SIZE = 1024;
    private static final double NEGATIVE = -1.0;
    private volatile boolean cacheEnabled = true;
    private final NameCache cache = new NameCache(512);
    private Abbreviator abbreviator = null;
    private volatile int cacheMisses = 0;
    private volatile int totalCalls = 0;

    protected abstract String getFullyQualifiedName(ILoggingEvent var1);

    /*
     * WARNING - void declaration
     */
    public void start() {
        String optStr;
        String string = OptionHelper.getSystemProperty((String)DISABLE_CACHE_SYSTEM_PROPERTY);
        boolean bl = OptionHelper.toBoolean((String)string, (boolean)false);
        if (bl) {
            this.addInfo("Disabling name cache via System.properties");
            this.cacheEnabled = false;
        }
        if ((optStr = this.getFirstOption()) != null) {
            try {
                int targetLen = Integer.parseInt(optStr);
                if (targetLen == 0) {
                    this.abbreviator = new ClassNameOnlyAbbreviator();
                } else if (targetLen > 0) {
                    this.abbreviator = new TargetLengthBasedClassNameAbbreviator(targetLen);
                }
            }
            catch (NumberFormatException nfe) {
                void var2_5;
                void var1_3;
                this.addError("failed to parse integer string [" + (String)var1_3 + "]", (Throwable)var2_5);
            }
        }
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    public String convert(ILoggingEvent event) {
        void var1_1;
        String fqn = this.getFullyQualifiedName(event);
        if (this.abbreviator == null) {
            return fqn;
        }
        if (this.cacheEnabled) {
            return this.viaCache(fqn);
        }
        return this.abbreviator.abbreviate((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized String viaCache(String fqn) {
        void var2_2;
        ++this.totalCalls;
        String abbreviated = (String)this.cache.get(fqn);
        if (abbreviated == null) {
            void var1_1;
            ++this.cacheMisses;
            abbreviated = this.abbreviator.abbreviate(fqn);
            this.cache.put(var1_1, abbreviated);
        }
        return var2_2;
    }

    private void disableCache() {
        if (!this.cacheEnabled) {
            return;
        }
        this.cacheEnabled = false;
        this.cache.clear();
        this.addInfo("Disabling cache at totalCalls=" + this.totalCalls);
    }

    public double getCacheMissRate() {
        return this.cache.cacheMissCalculator.getCacheMissRate();
    }

    public int getCacheMisses() {
        return this.cacheMisses;
    }

    private class NameCache
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 1050866539278406045L;
        int removalThreshold;
        CacheMissCalculator cacheMissCalculator;

        /*
         * WARNING - void declaration
         */
        NameCache(int initialCapacity) {
            void var2_2;
            super(initialCapacity);
            this.cacheMissCalculator = new CacheMissCalculator(NamedConverter.this);
            this.removalThreshold = (int)((double)var2_2 * 0.75);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> entry) {
            if (this.shouldDoubleRemovalThreshold()) {
                void var1_2;
                this.removalThreshold <<= 1;
                int missRate = (int)(this.cacheMissCalculator.getCacheMissRate() * 100.0);
                NamedConverter.this.addInfo("Doubling nameCache removalThreshold to " + this.removalThreshold + " previous cacheMissRate=" + (int)var1_2 + "%");
                this.cacheMissCalculator.updateMilestones();
            }
            return this.size() >= this.removalThreshold;
        }

        /*
         * WARNING - void declaration
         */
        private boolean shouldDoubleRemovalThreshold() {
            void var1_1;
            double d;
            double rate = this.cacheMissCalculator.getCacheMissRate();
            if (d < 0.0) {
                return false;
            }
            if (var1_1 < 0.3) {
                return false;
            }
            if (this.removalThreshold >= 1536) {
                NamedConverter.this.disableCache();
                return false;
            }
            return true;
        }
    }

    class CacheMissCalculator {
        int totalsMilestone = 0;
        int cacheMissesMilestone = 0;
        final /* synthetic */ NamedConverter this$0;

        /*
         * WARNING - void declaration
         */
        CacheMissCalculator(NamedConverter this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        void updateMilestones() {
            this.totalsMilestone = this.this$0.totalCalls;
            this.cacheMissesMilestone = this.this$0.cacheMisses;
        }

        /*
         * WARNING - void declaration
         */
        double getCacheMissRate() {
            void var1_1;
            void var2_2;
            int effectiveTotal = this.this$0.totalCalls - this.totalsMilestone;
            if (effectiveTotal < 1024) {
                return -1.0;
            }
            int effectiveCacheMisses = this.this$0.cacheMisses - this.cacheMissesMilestone;
            return 1.0 * (double)var2_2 / (double)var1_1;
        }
    }
}

