/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net.server;

import ch.qos.logback.classic.net.ReceiverBase;
import ch.qos.logback.classic.net.server.RemoteAppenderClient;
import ch.qos.logback.classic.net.server.RemoteAppenderServerListener;
import ch.qos.logback.classic.net.server.RemoteAppenderServerRunner;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.net.server.ServerRunner;
import ch.qos.logback.core.util.CloseUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import javax.net.ServerSocketFactory;

public class ServerSocketReceiver
extends ReceiverBase {
    public static final int DEFAULT_BACKLOG = 50;
    private int port = 4560;
    private int backlog = 50;
    private String address;
    private ServerSocket serverSocket;
    private ServerRunner runner;

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean shouldStart() {
        try {
            ServerSocket serverSocket = this.getServerSocketFactory().createServerSocket(this.getPort(), this.getBacklog(), this.getInetAddress());
            ServerListener<RemoteAppenderClient> listener = this.createServerListener(serverSocket);
            this.runner = this.createServerRunner(listener, this.getContext().getExecutorService());
            this.runner.setContext(this.getContext());
            return true;
        }
        catch (Exception ex) {
            void var1_2;
            this.addError("server startup error: " + ex, (Throwable)var1_2);
            CloseUtil.closeQuietly((ServerSocket)this.serverSocket);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ServerListener<RemoteAppenderClient> createServerListener(ServerSocket socket) {
        void var1_1;
        return new RemoteAppenderServerListener((ServerSocket)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ServerRunner createServerRunner(ServerListener<RemoteAppenderClient> listener, Executor executor) {
        void var2_2;
        void var1_1;
        return new RemoteAppenderServerRunner((ServerListener<RemoteAppenderClient>)var1_1, (Executor)var2_2);
    }

    @Override
    protected Runnable getRunnableTask() {
        return this.runner;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onStop() {
        try {
            if (this.runner == null) {
                return;
            }
            this.runner.stop();
            return;
        }
        catch (IOException ex) {
            void var1_1;
            this.addError("server shutdown error: " + ex, (Throwable)var1_1);
            return;
        }
    }

    protected ServerSocketFactory getServerSocketFactory() throws Exception {
        return ServerSocketFactory.getDefault();
    }

    protected InetAddress getInetAddress() throws UnknownHostException {
        if (this.getAddress() == null) {
            return null;
        }
        return InetAddress.getByName(this.getAddress());
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public void setPort(int port) {
        void var1_1;
        this.port = var1_1;
    }

    public int getBacklog() {
        return this.backlog;
    }

    /*
     * WARNING - void declaration
     */
    public void setBacklog(int backlog) {
        void var1_1;
        this.backlog = var1_1;
    }

    public String getAddress() {
        return this.address;
    }

    /*
     * WARNING - void declaration
     */
    public void setAddress(String address) {
        void var1_1;
        this.address = var1_1;
    }
}

