/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.ReceiverBase;
import ch.qos.logback.classic.net.server.HardenedLoggingEventInputStream;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.util.CloseUtil;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import javax.net.SocketFactory;

public class SocketReceiver
extends ReceiverBase
implements SocketConnector.ExceptionHandler,
Runnable {
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private String remoteHost;
    private InetAddress address;
    private int port;
    private int reconnectionDelay;
    private int acceptConnectionTimeout = 5000;
    private String receiverId;
    private volatile Socket socket;
    private Future<Socket> connectorTask;

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean shouldStart() {
        void var1_1;
        int errorCount = 0;
        if (this.port == 0) {
            ++errorCount;
            this.addError("No port was configured for receiver. For more information, please visit http://logback.qos.ch/codes.html#receiver_no_port");
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.addError("No host name or address was configured for receiver. For more information, please visit http://logback.qos.ch/codes.html#receiver_no_host");
        }
        if (this.reconnectionDelay == 0) {
            this.reconnectionDelay = 30000;
        }
        if (errorCount == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException) {
                this.addError("unknown host: " + this.remoteHost);
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            this.receiverId = "receiver " + this.remoteHost + ":" + this.port + ": ";
        }
        return var1_1 == false;
    }

    @Override
    protected void onStop() {
        if (this.socket != null) {
            CloseUtil.closeQuietly((Socket)this.socket);
        }
    }

    @Override
    protected Runnable getRunnableTask() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            LoggerContext lc = (LoggerContext)this.getContext();
            while (!Thread.currentThread().isInterrupted()) {
                void var2_2;
                SocketReceiver socketReceiver = this;
                SocketConnector connector = socketReceiver.createConnector(socketReceiver.address, this.port, 0, this.reconnectionDelay);
                this.connectorTask = this.activateConnector((SocketConnector)var2_2);
                if (this.connectorTask != null) {
                    this.socket = this.waitForConnectorToReturnASocket();
                    if (this.socket != null) {
                        this.dispatchEvents(lc);
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {}
        this.addInfo("shutting down");
    }

    /*
     * WARNING - void declaration
     */
    private SocketConnector createConnector(InetAddress address, int port, int initialDelay, int retryDelay) {
        void var1_1;
        void var3_3;
        void var2_2;
        SocketConnector connector = this.newConnector(address, (int)var2_2, (int)var3_3, retryDelay);
        connector.setExceptionHandler((SocketConnector.ExceptionHandler)this);
        connector.setSocketFactory(this.getSocketFactory());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Future<Socket> activateConnector(SocketConnector connector) {
        try {
            void var1_1;
            return this.getContext().getScheduledExecutorService().submit(var1_1);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Socket waitForConnectorToReturnASocket() throws InterruptedException {
        try {
            void var1_1;
            Socket s = this.connectorTask.get();
            this.connectorTask = null;
            return var1_1;
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private void dispatchEvents(LoggerContext lc) {
        HardenedLoggingEventInputStream ois = null;
        try {
            this.socket.setSoTimeout(this.acceptConnectionTimeout);
            ois = new HardenedLoggingEventInputStream(this.socket.getInputStream());
            this.socket.setSoTimeout(0);
            this.addInfo(this.receiverId + "connection established");
            while (true) {
                ILoggingEvent event;
                Logger remoteLogger;
                if (!(remoteLogger = lc.getLogger((event = (ILoggingEvent)((ObjectInputStream)((Object)ois)).readObject()).getLoggerName())).isEnabledFor(event.getLevel())) {
                    continue;
                }
                remoteLogger.callAppenders(event);
            }
        }
        catch (EOFException eOFException) {
            this.addInfo(this.receiverId + "end-of-stream detected");
            CloseUtil.closeQuietly((Closeable)((Object)ois));
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            this.addInfo(this.receiverId + "connection closed");
            return;
        }
        catch (IOException ex) {
            this.addInfo(this.receiverId + "connection failed: " + ex);
            CloseUtil.closeQuietly((Closeable)((Object)ois));
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            this.addInfo(this.receiverId + "connection closed");
            return;
        }
        catch (ClassNotFoundException ex) {
            void var3_6;
            this.addInfo(this.receiverId + "unknown event class: " + var3_6);
            {
                catch (Throwable throwable) {
                    void var2_3;
                    CloseUtil.closeQuietly((Closeable)var2_3);
                    CloseUtil.closeQuietly((Socket)this.socket);
                    this.socket = null;
                    this.addInfo(this.receiverId + "connection closed");
                    throw throwable;
                }
            }
            CloseUtil.closeQuietly((Closeable)((Object)ois));
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            this.addInfo(this.receiverId + "connection closed");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void connectionFailed(SocketConnector connector, Exception ex) {
        void var2_2;
        if (ex instanceof InterruptedException) {
            this.addInfo("connector interrupted");
            return;
        }
        if (ex instanceof ConnectException) {
            this.addInfo(this.receiverId + "connection refused");
            return;
        }
        this.addInfo(this.receiverId + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected SocketConnector newConnector(InetAddress address, int port, int initialDelay, int retryDelay) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultSocketConnector((InetAddress)var1_1, (int)var2_2, (long)var3_3, (long)retryDelay);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoteHost(String remoteHost) {
        void var1_1;
        this.remoteHost = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPort(int port) {
        void var1_1;
        this.port = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setReconnectionDelay(int reconnectionDelay) {
        void var1_1;
        this.reconnectionDelay = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        void var1_1;
        this.acceptConnectionTimeout = var1_1;
    }
}

