/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SimpleSocketServer;
import ch.qos.logback.classic.net.server.HardenedLoggingEventInputStream;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;

public class SocketNode
implements Runnable {
    Socket socket;
    LoggerContext context;
    HardenedLoggingEventInputStream hardenedLoggingEventInputStream;
    SocketAddress remoteSocketAddress;
    Logger logger;
    boolean closed = false;
    SimpleSocketServer socketServer;

    /*
     * WARNING - void declaration
     */
    public SocketNode(SimpleSocketServer socketServer, Socket socket, LoggerContext context) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.socketServer = var1_1;
        this.socket = socket;
        this.remoteSocketAddress = var2_2.getRemoteSocketAddress();
        this.context = context;
        this.logger = var3_3.getLogger(SocketNode.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            this.hardenedLoggingEventInputStream = new HardenedLoggingEventInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (Exception e) {
            this.logger.error("Could not open ObjectInputStream to " + this.socket, e);
            this.closed = true;
        }
        try {
            while (!this.closed) {
                void var2_5;
                ILoggingEvent event = (ILoggingEvent)this.hardenedLoggingEventInputStream.readObject();
                Logger remoteLogger = this.context.getLogger(event.getLoggerName());
                if (!remoteLogger.isEnabledFor(event.getLevel())) continue;
                var2_5.callAppenders(event);
            }
        }
        catch (EOFException eOFException) {
            this.logger.info("Caught java.io.EOFException closing connection.");
        }
        catch (SocketException socketException) {
            this.logger.info("Caught java.net.SocketException closing connection.");
        }
        catch (IOException e) {
            this.logger.info("Caught java.io.IOException: " + e);
            this.logger.info("Closing connection.");
        }
        catch (Exception e) {
            void var1_4;
            this.logger.error("Unexpected exception. Closing connection.", (Throwable)var1_4);
        }
        this.socketServer.socketNodeClosing(this);
        this.close();
    }

    /*
     * WARNING - void declaration
     */
    void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.hardenedLoggingEventInputStream != null) {
            try {
                this.hardenedLoggingEventInputStream.close();
                return;
            }
            catch (IOException e) {
                void var1_1;
                this.logger.warn("Could not close connection.", (Throwable)var1_1);
                return;
            }
            finally {
                this.hardenedLoggingEventInputStream = null;
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + this.remoteSocketAddress.toString();
    }
}

