/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SocketNode;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.net.ServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSocketServer
extends Thread {
    Logger logger = LoggerFactory.getLogger(SimpleSocketServer.class);
    private final int port;
    private final LoggerContext lc;
    private boolean closed = false;
    private ServerSocket serverSocket;
    private List<SocketNode> socketNodeList = new ArrayList<SocketNode>();
    private CountDownLatch latch;

    public static void main(String[] argv) throws Exception {
        String[] stringArray;
        SimpleSocketServer.doMain(SimpleSocketServer.class, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    protected static void doMain(Class<? extends SimpleSocketServer> serverClass, String[] argv) throws Exception {
        void var0_1;
        void var2_4;
        void var1_3;
        int port = -1;
        if (argv.length == 2) {
            port = SimpleSocketServer.parsePortNumber(argv[0]);
        } else {
            SimpleSocketServer.usage("Wrong number of arguments.");
        }
        String configFile = argv[1];
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        SimpleSocketServer.configureLC(lc, (String)var1_3);
        SimpleSocketServer simpleSocketServer = new SimpleSocketServer((LoggerContext)var2_4, (int)var0_1);
        simpleSocketServer.start();
    }

    /*
     * WARNING - void declaration
     */
    public SimpleSocketServer(LoggerContext lc, int port) {
        void var2_2;
        void var1_1;
        this.lc = var1_1;
        this.port = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        String oldThreadName = Thread.currentThread().getName();
        try {
            String newThreadName = this.getServerThreadName();
            Thread.currentThread().setName(newThreadName);
            this.logger.info("Listening on port " + this.port);
            this.serverSocket = this.getServerSocketFactory().createServerSocket(this.port);
            while (!this.closed) {
                void var3_6;
                this.logger.info("Waiting to accept a new client.");
                this.signalAlmostReadiness();
                Socket socket = this.serverSocket.accept();
                this.logger.info("Connected to client at " + socket.getInetAddress());
                this.logger.info("Starting new socket node.");
                SocketNode newSocketNode = new SocketNode(this, socket, this.lc);
                List<SocketNode> list = this.socketNodeList;
                synchronized (list) {
                    this.socketNodeList.add(newSocketNode);
                }
                String clientThreadName = this.getClientThreadName(socket);
                new Thread((Runnable)var3_6, clientThreadName).start();
            }
            Thread.currentThread().setName(oldThreadName);
            return;
        }
        catch (Exception e) {
            try {
                if (this.closed) {
                    this.logger.info("Exception in run method for a closed server. This is normal.");
                } else {
                    void var2_4;
                    this.logger.error("Unexpected failure in run method", (Throwable)var2_4);
                }
                Thread.currentThread().setName(oldThreadName);
                return;
            }
            catch (Throwable throwable) {
                void var1_1;
                Thread.currentThread().setName((String)var1_1);
                throw throwable;
            }
        }
    }

    protected String getServerThreadName() {
        return String.format("Logback %s (port %d)", this.getClass().getSimpleName(), this.port);
    }

    /*
     * WARNING - void declaration
     */
    protected String getClientThreadName(Socket socket) {
        void var1_1;
        return String.format("Logback SocketNode (client: %s)", var1_1.getRemoteSocketAddress());
    }

    protected ServerSocketFactory getServerSocketFactory() {
        return ServerSocketFactory.getDefault();
    }

    void signalAlmostReadiness() {
        if (this.latch != null && this.latch.getCount() != 0L) {
            this.latch.countDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    void setLatch(CountDownLatch latch) {
        void var1_1;
        this.latch = var1_1;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - void declaration
     */
    public void close() {
        this.closed = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                void var1_1;
                this.logger.error("Failed to close serverSocket", (Throwable)var1_1);
            }
            finally {
                this.serverSocket = null;
            }
        }
        this.logger.info("closing this server");
        List<SocketNode> list = this.socketNodeList;
        synchronized (list) {
            for (SocketNode socketNode : this.socketNodeList) {
                socketNode.close();
            }
        }
        if (this.socketNodeList.size() != 0) {
            this.logger.warn("Was expecting a 0-sized socketNodeList after server shutdown");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void socketNodeClosing(SocketNode sn) {
        this.logger.debug("Removing {}", (Object)sn);
        List<SocketNode> list = this.socketNodeList;
        synchronized (list) {
            void var1_1;
            this.socketNodeList.remove(var1_1);
            return;
        }
    }

    static void usage(String msg) {
        String string;
        System.err.println(string);
        System.err.println("Usage: java " + SimpleSocketServer.class.getName() + " port configFile");
        System.exit(1);
    }

    static int parsePortNumber(String portStr) {
        try {
            return Integer.parseInt(portStr);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            NumberFormatException numberFormatException2 = numberFormatException;
            numberFormatException.printStackTrace();
            SimpleSocketServer.usage("Could not interpret port number [" + string + "].");
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void configureLC(LoggerContext lc, String configFile) throws JoranException {
        void var1_1;
        void var2_2;
        LoggerContext loggerContext;
        JoranConfigurator configurator = new JoranConfigurator();
        lc.reset();
        configurator.setContext((Context)loggerContext);
        var2_2.doConfigure((String)var1_1);
    }
}

