/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.model.ReceiverModel;
import ch.qos.logback.classic.net.ReceiverBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;

public class ReceiverModelHandler
extends ModelHandlerBase {
    private ReceiverBase receiver;
    private boolean inError;

    /*
     * WARNING - void declaration
     */
    public ReceiverModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        Context context2;
        return new ReceiverModelHandler(context2);
    }

    protected Class<ReceiverModel> getSupportedModelClass() {
        return ReceiverModel.class;
    }

    /*
     * WARNING - void declaration
     */
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        String className = (model = (ReceiverModel)((Object)model)).getClassName();
        if (OptionHelper.isNullOrEmpty((String)className)) {
            this.addError("Missing class name for receiver. ");
            this.inError = true;
            return;
        }
        className = mic.getImport(className);
        try {
            this.addInfo("About to instantiate receiver of type [" + className + "]");
            this.receiver = (ReceiverBase)((Object)OptionHelper.instantiateByClassName((String)className, ReceiverBase.class, (Context)((ContextAwareBase)this).context));
            this.receiver.setContext(((ContextAwareBase)this).context);
            mic.pushObject((Object)this.receiver);
            return;
        }
        catch (Exception ex) {
            void var1_2;
            void var2_3;
            this.inError = true;
            this.addError("Could not create a receiver of type [" + (String)var2_3 + "].", ex);
            throw new ModelHandlerException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        void var1_1;
        if (this.inError) {
            return;
        }
        Object object = mic.peekObject();
        if (object != this.receiver) {
            this.addWarn("The object at the of the stack is not the receiver pushed earlier.");
            return;
        }
        mic.popObject();
        this.addInfo("Registering receiver with context.");
        var1_1.getContext().register((LifeCycle)this.receiver);
        this.receiver.start();
    }
}

