/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.joran.ReconfigureOnChangeTask;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.model.processor.ConfigurationModelHandler;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ConfigurationModelHandlerFull
extends ConfigurationModelHandler {
    /*
     * WARNING - void declaration
     */
    public ConfigurationModelHandlerFull(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance2(Context context, ModelInterpretationContext mic) {
        Context context2;
        return new ConfigurationModelHandlerFull(context2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processScanAttrib(ModelInterpretationContext mic, ConfigurationModel configurationModel) {
        String scanStr = mic.subst(configurationModel.getScanStr());
        if (!OptionHelper.isNullOrEmpty((String)scanStr) && !"false".equalsIgnoreCase(scanStr)) {
            void var1_1;
            void var3_3;
            void var2_2;
            ScheduledExecutorService scheduledExecutorService = ((ContextAwareBase)this).context.getScheduledExecutorService();
            URL mainURL = ConfigurationWatchListUtil.getMainWatchURL((Context)((ContextAwareBase)this).context);
            if (mainURL == null) {
                this.addWarn("Due to missing top level configuration file, reconfiguration on change (configuration file scanning) cannot be done.");
                return;
            }
            ReconfigureOnChangeTask rocTask = new ReconfigureOnChangeTask();
            rocTask.setContext(((ContextAwareBase)this).context);
            this.addInfo("Registering a new ReconfigureOnChangeTask " + rocTask);
            ((ContextAwareBase)this).context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectorRegisteredEvent((Object)rocTask));
            String scanPeriodStr = mic.subst(var2_2.getScanPeriodStr());
            Duration duration = this.getDurationOfScanPeriodAttribute(scanPeriodStr, SCAN_PERIOD_DEFAULT);
            this.addInfo("Will scan for changes in [" + mainURL + "] ");
            this.addInfo("Setting ReconfigureOnChangeTask scanning period to " + duration);
            ScheduledFuture<?> scheduledFuture = var3_3.scheduleAtFixedRate(rocTask, duration.getMilliseconds(), duration.getMilliseconds(), TimeUnit.MILLISECONDS);
            rocTask.setScheduredFuture(scheduledFuture);
            ((ContextAwareBase)this).context.addScheduledFuture((ScheduledFuture)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Duration getDurationOfScanPeriodAttribute(String scanPeriodAttrib, Duration defaultDuration) {
        void var3_3;
        Duration duration = null;
        if (!OptionHelper.isNullOrEmpty((String)scanPeriodAttrib)) {
            try {
                duration = Duration.valueOf((String)scanPeriodAttrib);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                void var1_1;
                this.addWarn("Failed to parse 'scanPeriod' attribute [" + (String)var1_1 + "]", e);
            }
        }
        if (duration == null) {
            void var2_2;
            this.addInfo("No 'scanPeriod' specified. Defaulting to " + defaultDuration.toString());
            duration = var2_2;
        }
        return var3_3;
    }
}

