/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jul;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.JULHelper;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.LogManager;

public class LevelChangePropagator
extends ContextAwareBase
implements LoggerContextListener,
LifeCycle {
    private Set<java.util.logging.Logger> julLoggerSet = new HashSet<java.util.logging.Logger>();
    boolean isStarted = false;
    boolean resetJUL = false;

    /*
     * WARNING - void declaration
     */
    public void setResetJUL(boolean resetJUL) {
        void var1_1;
        this.resetJUL = var1_1;
    }

    @Override
    public boolean isResetResistant() {
        return false;
    }

    @Override
    public void onStart(LoggerContext context) {
    }

    @Override
    public void onReset(LoggerContext context) {
    }

    @Override
    public void onStop(LoggerContext context) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onLevelChange(Logger logger, Level level) {
        void var2_2;
        void var1_1;
        this.propagate((Logger)var1_1, (Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void propagate(Logger logger, Level level) {
        void var2_2;
        void var1_1;
        this.addInfo("Propagating " + level + " level on " + logger + " onto the JUL framework");
        java.util.logging.Logger julLogger = JULHelper.asJULLogger(logger);
        this.julLoggerSet.add(julLogger);
        java.util.logging.Level julLevel = JULHelper.asJULLevel(level);
        var1_1.setLevel((java.util.logging.Level)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void resetJULLevels() {
        LogManager lm = LogManager.getLogManager();
        Enumeration<String> e = lm.getLoggerNames();
        while (e.hasMoreElements()) {
            void var3_3;
            String loggerName = e.nextElement();
            java.util.logging.Logger julLogger = lm.getLogger(loggerName);
            if (!JULHelper.isRegularNonRootLogger(julLogger) || julLogger.getLevel() == null) continue;
            this.addInfo("Setting level of jul logger [" + (String)var3_3 + "] to null");
            julLogger.setLevel(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void propagateExistingLoggerLevels() {
        Object object = (LoggerContext)this.context;
        object = ((LoggerContext)((Object)object)).getLoggerList();
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            Logger l = (Logger)object.next();
            if (l.getLevel() == null) continue;
            void v0 = var2_2;
            this.propagate((Logger)v0, v0.getLevel());
        }
    }

    public void start() {
        if (this.resetJUL) {
            this.resetJULLevels();
        }
        this.propagateExistingLoggerLevels();
        this.isStarted = true;
    }

    public void stop() {
        this.isStarted = false;
    }

    public boolean isStarted() {
        return this.isStarted;
    }
}

