/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.DefaultCssBuilder;
import ch.qos.logback.classic.html.DefaultThrowableRenderer;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.html.HTMLLayoutBase;
import ch.qos.logback.core.html.IThrowableRenderer;
import ch.qos.logback.core.pattern.Converter;
import java.util.Map;

public class HTMLLayout
extends HTMLLayoutBase<ILoggingEvent> {
    static final String DEFAULT_CONVERSION_PATTERN = "%date%thread%level%logger%mdc%msg";
    IThrowableRenderer<ILoggingEvent> throwableRenderer;

    public HTMLLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.throwableRenderer = new DefaultThrowableRenderer();
        this.cssBuilder = new DefaultCssBuilder();
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        void var1_1;
        int errorCount = 0;
        if (this.throwableRenderer == null) {
            this.addError("ThrowableRender cannot be null.");
            ++errorCount;
        }
        if (var1_1 == false) {
            super.start();
        }
    }

    protected Map<String, String> getDefaultConverterMap() {
        return PatternLayout.DEFAULT_CONVERTER_MAP;
    }

    /*
     * WARNING - void declaration
     */
    public String doLayout(ILoggingEvent event) {
        void var2_2;
        StringBuilder buf = new StringBuilder();
        this.startNewTableIfLimitReached(buf);
        boolean odd = true;
        if ((this.counter++ & 1L) == 0L) {
            odd = false;
        }
        String level = event.getLevel().toString().toLowerCase();
        buf.append(CoreConstants.LINE_SEPARATOR);
        buf.append("<tr class=\"");
        buf.append(level);
        if (odd) {
            buf.append(" odd\">");
        } else {
            buf.append(" even\">");
        }
        buf.append(CoreConstants.LINE_SEPARATOR);
        for (Converter c = this.head; c != null; c = c.getNext()) {
            this.appendEventToBuffer(buf, (Converter<ILoggingEvent>)c, event);
        }
        buf.append("</tr>");
        buf.append(CoreConstants.LINE_SEPARATOR);
        if (event.getThrowableProxy() != null) {
            void var1_1;
            this.throwableRenderer.render(buf, (Object)var1_1);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void appendEventToBuffer(StringBuilder buf, Converter<ILoggingEvent> c, ILoggingEvent event) {
        void var1_1;
        void var3_3;
        void var2_2;
        buf.append("<td class=\"");
        buf.append(this.computeConverterName(c));
        buf.append("\">");
        buf.append(Transform.escapeTags((String)var2_2.convert((Object)var3_3)));
        buf.append("</td>");
        var1_1.append(CoreConstants.LINE_SEPARATOR);
    }

    public IThrowableRenderer<ILoggingEvent> getThrowableRenderer() {
        return this.throwableRenderer;
    }

    /*
     * WARNING - void declaration
     */
    public void setThrowableRenderer(IThrowableRenderer<ILoggingEvent> throwableRenderer) {
        void var1_1;
        this.throwableRenderer = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected String computeConverterName(Converter<ILoggingEvent> c) {
        void var1_1;
        if (c instanceof MDCConverter) {
            String key = (c = (MDCConverter)((Object)c)).getFirstOption();
            if (key != null) {
                return var1_1;
            }
            return "MDC";
        }
        return super.computeConverterName((Converter)var1_1);
    }
}

