/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.html.IThrowableRenderer;

public class DefaultThrowableRenderer
implements IThrowableRenderer<ILoggingEvent> {
    static final String TRACE_PREFIX = "<br />&nbsp;&nbsp;&nbsp;&nbsp;";

    /*
     * WARNING - void declaration
     */
    public void render(StringBuilder sbuf, ILoggingEvent event) {
        void var1_1;
        sbuf.append("<tr><td class=\"Exception\" colspan=\"6\">");
        for (IThrowableProxy tp = event.getThrowableProxy(); tp != null; tp = tp.getCause()) {
            this.render(sbuf, tp);
        }
        var1_1.append("</td></tr>");
    }

    /*
     * WARNING - void declaration
     */
    void render(StringBuilder sbuf, IThrowableProxy tp) {
        this.printFirstLine(sbuf, tp);
        int commonFrames = tp.getCommonFrames();
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        for (int i = 0; i < stepArray.length - commonFrames; ++i) {
            StackTraceElementProxy step = stepArray[i];
            sbuf.append(TRACE_PREFIX);
            sbuf.append(Transform.escapeTags((String)step.toString()));
            sbuf.append(CoreConstants.LINE_SEPARATOR);
        }
        if (commonFrames > 0) {
            void var3_3;
            void var1_1;
            sbuf.append(TRACE_PREFIX);
            var1_1.append("\t... ").append((int)var3_3).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printFirstLine(StringBuilder sb, IThrowableProxy tp) {
        void var1_1;
        void var2_2;
        int n = tp.getCommonFrames();
        if (n > 0) {
            sb.append("<br />Caused by: ");
        }
        sb.append(tp.getClassName()).append(": ").append(Transform.escapeTags((String)var2_2.getMessage()));
        var1_1.append(CoreConstants.LINE_SEPARATOR);
    }
}

