/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.waiter;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import uk.co.caprica.vlcj.waiter.BeforeWaiterAbortedException;
import uk.co.caprica.vlcj.waiter.ResultStatus;
import uk.co.caprica.vlcj.waiter.UnexpectedWaiterErrorException;
import uk.co.caprica.vlcj.waiter.UnexpectedWaiterFinishedException;

public abstract class Waiter<C, R> {
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final AtomicReference<ResultStatus> resultStatus = new AtomicReference();
    private final AtomicReference<R> result = new AtomicReference();
    private final AtomicBoolean finished = new AtomicBoolean();
    protected final C component;

    /*
     * WARNING - void declaration
     */
    public Waiter(C component) {
        void var1_1;
        this.component = var1_1;
    }

    public final R await() throws InterruptedException, UnexpectedWaiterErrorException, UnexpectedWaiterFinishedException {
        Waiter waiter = this;
        waiter.startListening(waiter.component);
        Waiter waiter2 = this;
        if (waiter2.onBefore(waiter2.component)) {
            this.completionLatch.await();
            switch (this.resultStatus.get()) {
                case NORMAL: {
                    Waiter waiter3 = this;
                    waiter3.onAfter(waiter3.component, this.result.get());
                    return this.result.get();
                }
                case ERROR: {
                    throw new UnexpectedWaiterErrorException();
                }
                case FINISHED: {
                    throw new UnexpectedWaiterFinishedException();
                }
            }
            throw new IllegalStateException("Unexpected result status: " + (Object)((Object)this.resultStatus.get()));
        }
        throw new BeforeWaiterAbortedException();
    }

    protected final void ready() {
        this.ready(null);
    }

    /*
     * WARNING - void declaration
     */
    protected final void ready(R result) {
        if (!this.finished.getAndSet(true)) {
            void var1_1;
            this.result.set(var1_1);
            this.release(ResultStatus.NORMAL);
        }
    }

    protected final void error() {
        this.release(ResultStatus.ERROR);
    }

    protected final void finished() {
        this.release(ResultStatus.FINISHED);
    }

    protected boolean onBefore(C component) {
        return true;
    }

    protected void onAfter(C component, R result) {
    }

    protected abstract void startListening(C var1);

    protected abstract void stopListening(C var1);

    /*
     * WARNING - void declaration
     */
    private void release(ResultStatus resultStatus) {
        void var1_1;
        Waiter waiter = this;
        waiter.stopListening(waiter.component);
        this.resultStatus.set((ResultStatus)var1_1);
        this.completionLatch.countDown();
    }
}

