/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.support.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)[\\-_\\s]?(.*)");
    private final String version;
    private final int major;
    private final int minor;
    private final int revision;
    private final String extra;

    /*
     * WARNING - void declaration
     */
    public Version(String version) {
        void var1_1;
        this.version = version;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.revision = Integer.parseInt(matcher.group(3));
            if (matcher.groupCount() > 3) {
                void var2_2;
                this.extra = var2_2.group(4);
                return;
            }
            this.extra = null;
            return;
        }
        throw new IllegalArgumentException("Can't parse version from '" + (String)var1_1 + "'");
    }

    public final String version() {
        return this.version;
    }

    public final int major() {
        return this.major;
    }

    public final int minor() {
        return this.minor;
    }

    public final int revision() {
        return this.revision;
    }

    public final String extra() {
        return this.extra;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean atLeast(Version required) {
        void var1_1;
        return this.compareTo((Version)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Version o) {
        void var2_2;
        int delta = this.major - o.major;
        if (delta == 0 && (delta = this.minor - o.minor) == 0) {
            void var1_1;
            delta = this.revision - var1_1.revision;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder(20);
        sb.append(this.version);
        return var1_1.toString();
    }
}

