/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface.callback;

import java.util.Arrays;

public class BufferFormat {
    private final String chroma;
    private final int width;
    private final int height;
    private final int[] pitches;
    private final int[] lines;

    /*
     * WARNING - void declaration
     */
    public BufferFormat(String chroma, int width, int height, int[] pitches, int[] lines) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.validate(chroma, width, height, pitches, lines);
        this.chroma = var1_1;
        this.width = var2_2;
        this.height = var3_3;
        this.pitches = Arrays.copyOf(pitches, pitches.length);
        this.lines = Arrays.copyOf(lines, lines.length);
    }

    public final String getChroma() {
        return this.chroma;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int[] getPitches() {
        return this.pitches;
    }

    public final int[] getLines() {
        return this.lines;
    }

    public final int getPlaneCount() {
        return this.pitches.length;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("chroma=").append(this.chroma).append(',');
        sb.append("width=").append(this.width).append(',');
        sb.append("height=").append(this.height).append(',');
        sb.append("pitches=").append(Arrays.toString(this.pitches)).append(',');
        sb.append("lines=").append(Arrays.toString(this.lines)).append(']');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void validate(String chroma, int width, int height, int[] pitches, int[] lines) {
        void var3_4;
        void var2_3;
        if (chroma == null || chroma.length() != 4) {
            throw new IllegalArgumentException("chroma must be exactly 4 characters");
        }
        if (var2_3 <= 0) {
            throw new IllegalArgumentException("width must be greater than zero");
        }
        if (var3_4 <= 0) {
            throw new IllegalArgumentException("height must be greater than zero");
        }
        if (pitches == null || pitches.length == 0) {
            throw new IllegalArgumentException("pitches length must be greater than zero");
        }
        if (lines == null || lines.length == 0) {
            throw new IllegalArgumentException("lines length must be greater than zero");
        }
        if (pitches.length != lines.length) {
            throw new IllegalArgumentException("pitches and lines must have equal length");
        }
        for (int i = 0; i < pitches.length; ++i) {
            if (pitches[i] <= 0) {
                throw new IllegalArgumentException("pitch must be greater than zero");
            }
            if (lines[i] > 0) continue;
            throw new IllegalArgumentException("line must be greater than zero");
        }
    }
}

