/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import uk.co.caprica.vlcj.player.embedded.BaseApi;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.ComponentVideoSurface;

public final class OverlayApi
extends BaseApi {
    private final OverlayComponentAdapter overlayComponentAdapter = new OverlayComponentAdapter();
    private final OverlayWindowAdapter overlayWindowAdapter = new OverlayWindowAdapter();
    private final Rectangle bounds = new Rectangle();
    private Window overlay;
    private boolean requestedOverlay;
    private boolean restoreOverlay;

    /*
     * WARNING - void declaration
     */
    OverlayApi(EmbeddedMediaPlayer mediaPlayer) {
        super((EmbeddedMediaPlayer)var1_1);
        void var1_1;
    }

    public final Window get() {
        return this.overlay;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(Window overlay) {
        if (this.mediaPlayer.videoSurface().getVideoSurface() instanceof ComponentVideoSurface) {
            void var1_1;
            this.enable(false);
            this.removeOverlay();
            this.addOverlay((Window)var1_1);
            return;
        }
        throw new IllegalStateException("Overlay requires a ComponentVideoSurface");
    }

    public final void enable(boolean enable) {
        this.requestedOverlay = enable;
        if (this.overlay != null) {
            if (enable) {
                if (!this.overlay.isVisible()) {
                    Window window;
                    Component component = this.getComponent();
                    component.getBounds(this.bounds);
                    this.bounds.setLocation(component.getLocationOnScreen());
                    this.overlay.setBounds(this.bounds);
                    window = this.getAncestorWindow(window);
                    window.addComponentListener(this.overlayComponentAdapter);
                    this.overlay.setVisible(true);
                    return;
                }
            } else if (this.overlay.isVisible()) {
                this.overlay.setVisible(false);
                OverlayApi overlayApi = this;
                Window window = overlayApi.getAncestorWindow(overlayApi.getComponent());
                window.removeComponentListener(this.overlayComponentAdapter);
            }
        }
    }

    public final boolean enabled() {
        return this.overlay != null && this.overlay.isVisible();
    }

    /*
     * WARNING - void declaration
     */
    private void addOverlay(Window overlay) {
        if (overlay != null) {
            this.overlay = overlay;
            OverlayApi overlayApi = this;
            Window window = overlayApi.getAncestorWindow(overlayApi.getComponent());
            if (window != null) {
                void var1_1;
                var1_1.addWindowListener(this.overlayWindowAdapter);
            }
        }
    }

    private void removeOverlay() {
        if (this.overlay != null) {
            OverlayApi overlayApi = this;
            Window window = overlayApi.getAncestorWindow(overlayApi.getComponent());
            window.removeWindowListener(this.overlayWindowAdapter);
            this.overlay = null;
        }
    }

    private void showOverlay() {
        if (this.restoreOverlay) {
            this.enable(true);
        }
    }

    private void hideOverlay() {
        if (this.requestedOverlay) {
            this.restoreOverlay = true;
            this.enable(false);
            return;
        }
        this.restoreOverlay = false;
    }

    private Component getComponent() {
        return ((ComponentVideoSurface)this.mediaPlayer.videoSurface().getVideoSurface()).component();
    }

    /*
     * WARNING - void declaration
     */
    private Window getAncestorWindow(Component component) {
        void var1_1;
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)var1_1);
    }

    private final class OverlayWindowAdapter
    extends WindowAdapter {
        private OverlayWindowAdapter() {
        }

        @Override
        public final void windowIconified(WindowEvent e) {
        }

        @Override
        public final void windowDeiconified(WindowEvent e) {
            OverlayApi.this.showOverlay();
        }

        @Override
        public final void windowDeactivated(WindowEvent e) {
            OverlayApi.this.hideOverlay();
        }

        @Override
        public final void windowActivated(WindowEvent e) {
            OverlayApi.this.showOverlay();
        }
    }

    private final class OverlayComponentAdapter
    extends ComponentAdapter {
        private OverlayComponentAdapter() {
        }

        @Override
        public final void componentResized(ComponentEvent e) {
            OverlayApi.this.overlay.setSize(OverlayApi.this.getComponent().getSize());
        }

        @Override
        public final void componentMoved(ComponentEvent e) {
            OverlayApi.this.overlay.setLocation(OverlayApi.this.getComponent().getLocationOnScreen());
        }

        @Override
        public final void componentShown(ComponentEvent e) {
            OverlayApi.this.showOverlay();
        }

        @Override
        public final void componentHidden(ComponentEvent e) {
            OverlayApi.this.hideOverlay();
        }
    }
}

