/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import uk.co.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.component.EmbeddedMediaPlayerComponentBase;
import uk.co.caprica.vlcj.player.component.InputEvents;
import uk.co.caprica.vlcj.player.component.MediaPlayerComponent;
import uk.co.caprica.vlcj.player.component.MediaPlayerComponentDefaults;
import uk.co.caprica.vlcj.player.component.MediaPlayerSpecs;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;

public class EmbeddedMediaPlayerComponent
extends EmbeddedMediaPlayerComponentBase
implements MediaPlayerComponent {
    static final String[] DEFAULT_FACTORY_ARGUMENTS = MediaPlayerComponentDefaults.EMBEDDED_MEDIA_PLAYER_ARGS;
    private final boolean ownFactory;
    protected final MediaPlayerFactory mediaPlayerFactory;
    private final Component videoSurfaceComponent;
    private final EmbeddedMediaPlayer mediaPlayer;

    /*
     * WARNING - void declaration
     */
    public EmbeddedMediaPlayerComponent(MediaPlayerFactory mediaPlayerFactory, Component videoSurfaceComponent, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, Window overlay) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ownFactory = mediaPlayerFactory == null;
        this.mediaPlayerFactory = this.initMediaPlayerFactory((MediaPlayerFactory)var1_1);
        this.videoSurfaceComponent = this.initVideoSurfaceComponent((Component)var2_2);
        this.mediaPlayer = this.onCreateMediaPlayer();
        this.mediaPlayer.videoSurface().set(this.mediaPlayerFactory.videoSurfaces().newVideoSurface(this.videoSurfaceComponent));
        this.mediaPlayer.fullScreen().strategy((FullScreenStrategy)var3_3);
        this.mediaPlayer.overlay().set(overlay);
        this.mediaPlayer.events().addMediaPlayerEventListener(this);
        this.mediaPlayer.events().addMediaEventListener(this);
        this.setBackground(Color.black);
        this.setLayout(new BorderLayout());
        EmbeddedMediaPlayerComponent embeddedMediaPlayerComponent = this;
        embeddedMediaPlayerComponent.add(embeddedMediaPlayerComponent.videoSurfaceComponent, "Center");
        this.initInputEvents(inputEvents);
        this.onAfterConstruct();
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedMediaPlayerComponent(MediaPlayerSpecs.EmbeddedMediaPlayerSpec spec) {
        this(spec.factory, spec.videoSurfaceComponent, spec.fullScreenStrategy, spec.inputEvents, var1_1.overlay);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EmbeddedMediaPlayerComponent(String ... libvlcArgs) {
        this(new MediaPlayerFactory((String[])var1_1), null, null, null, null);
        void var1_1;
    }

    public EmbeddedMediaPlayerComponent() {
        this((MediaPlayerFactory)null, (Component)null, (FullScreenStrategy)null, (InputEvents)null, (Window)null);
    }

    /*
     * WARNING - void declaration
     */
    private MediaPlayerFactory initMediaPlayerFactory(MediaPlayerFactory mediaPlayerFactory) {
        void var1_1;
        if (mediaPlayerFactory == null) {
            mediaPlayerFactory = new MediaPlayerFactory(DEFAULT_FACTORY_ARGUMENTS);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Component initVideoSurfaceComponent(Component videoSurfaceComponent) {
        void var1_1;
        if (videoSurfaceComponent == null) {
            videoSurfaceComponent = new Canvas();
            videoSurfaceComponent.setBackground(Color.black);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void initInputEvents(InputEvents inputEvents) {
        void var1_1;
        if (inputEvents == null) {
            inputEvents = RuntimeUtil.isNix() || RuntimeUtil.isMac() ? InputEvents.DEFAULT : InputEvents.DISABLE_NATIVE;
        }
        switch (1.$SwitchMap$uk$co$caprica$vlcj$player$component$InputEvents[var1_1.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                this.mediaPlayer.input().enableKeyInputHandling(false);
                this.mediaPlayer.input().enableMouseInputHandling(false);
            }
            case 3: {
                this.videoSurfaceComponent.addMouseListener(this);
                this.videoSurfaceComponent.addMouseMotionListener(this);
                this.videoSurfaceComponent.addMouseWheelListener(this);
                this.videoSurfaceComponent.addKeyListener(this);
            }
        }
    }

    public final EmbeddedMediaPlayer mediaPlayer() {
        return this.mediaPlayer;
    }

    public final Component videoSurfaceComponent() {
        return this.videoSurfaceComponent;
    }

    public final void release() {
        this.onBeforeRelease();
        this.videoSurfaceComponent.removeMouseListener(this);
        this.videoSurfaceComponent.removeMouseMotionListener(this);
        this.videoSurfaceComponent.removeMouseWheelListener(this);
        this.videoSurfaceComponent.removeKeyListener(this);
        this.mediaPlayer.release();
        if (this.ownFactory) {
            this.mediaPlayerFactory.release();
        }
        this.onAfterRelease();
    }

    @Override
    public final MediaPlayerFactory mediaPlayerFactory() {
        return this.mediaPlayerFactory;
    }

    protected EmbeddedMediaPlayer onCreateMediaPlayer() {
        return this.mediaPlayerFactory.mediaPlayers().newEmbeddedMediaPlayer();
    }
}

