/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.player.base.LogoPosition;
import uk.co.caprica.vlcj.player.base.MediaPlayer;

public final class Logo {
    private Integer intOpacity;
    private Float floatOpacity;
    private Integer duration;
    private Integer x;
    private Integer y;
    private LogoPosition position;
    private Integer repeat;
    private List<String> files = new ArrayList<String>();
    private RenderedImage image;
    private boolean enable;

    public static Logo logo() {
        return new Logo();
    }

    private Logo() {
    }

    /*
     * WARNING - void declaration
     */
    public final Logo duration(int duration) {
        void var1_1;
        this.duration = (int)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Logo opacity(int opacity) {
        void var1_1;
        this.intOpacity = (int)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Logo opacity(float opacity) {
        void var1_1;
        this.floatOpacity = Float.valueOf((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Logo location(int x, int y) {
        void var2_2;
        void var1_1;
        this.x = (int)var1_1;
        this.y = (int)var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Logo position(LogoPosition position) {
        void var1_1;
        this.position = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Logo repeat(int repeat) {
        void var1_1;
        this.repeat = (int)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Logo file(String file) {
        void var1_1;
        return this.addFileSpec((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Logo file(String file, Integer duration, Integer opacity) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.addFileSpec(String.format("%s,%s,%s", var1_1, duration == null ? "" : var2_2, opacity == null ? "" : var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public final Logo file(File file) {
        void var1_1;
        return this.file(var1_1.getAbsolutePath());
    }

    /*
     * WARNING - void declaration
     */
    public final Logo file(File file, Integer duration, Integer opacity) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.file(var1_1.getAbsolutePath(), (Integer)var2_2, (Integer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final Logo image(RenderedImage image) {
        void var1_1;
        this.image = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Logo enable(boolean enable) {
        void var1_1;
        this.enable = var1_1;
        return this;
    }

    public final Logo enable() {
        this.enable = true;
        return this;
    }

    public final Logo disable() {
        this.enable = false;
        return this;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final Integer getIntegerOpacity() {
        return this.intOpacity;
    }

    public final Float getFloatOpacity() {
        return this.floatOpacity;
    }

    public final Integer getX() {
        return this.x;
    }

    public final Integer getY() {
        return this.y;
    }

    public final LogoPosition getPosition() {
        return this.position;
    }

    public final String getFile() {
        return this.convertFileSpecs();
    }

    public final RenderedImage getImage() {
        return this.image;
    }

    public final boolean getEnable() {
        return this.enable;
    }

    /*
     * WARNING - void declaration
     */
    public final void apply(MediaPlayer mediaPlayer) {
        if (this.duration != null) {
            mediaPlayer.logo().setDuration(this.duration);
        }
        if (this.intOpacity != null) {
            mediaPlayer.logo().setOpacity(this.intOpacity);
        }
        if (this.floatOpacity != null) {
            mediaPlayer.logo().setOpacity(this.floatOpacity.floatValue());
        }
        if (this.x != null && this.y != null && this.x >= 0 && this.y >= 0) {
            mediaPlayer.logo().setLocation(this.x, this.y);
        }
        if (this.position != null) {
            mediaPlayer.logo().setPosition(this.position);
        }
        if (this.repeat != null) {
            mediaPlayer.logo().setRepeat(this.repeat);
        }
        if (!this.files.isEmpty()) {
            mediaPlayer.logo().setFile(this.convertFileSpecs());
        }
        if (this.image != null) {
            mediaPlayer.logo().setImage(this.image);
        }
        if (this.enable) {
            void var1_1;
            var1_1.logo().enable(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Logo addFileSpec(String fileSpec) {
        void var1_1;
        this.files.add((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private String convertFileSpecs() {
        void var1_1;
        StringBuilder sb = new StringBuilder(this.files.size() * 40);
        for (String fileSpec : this.files) {
            void var3_3;
            sb.append((String)var3_3).append(";");
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder.charAt(stringBuilder.length() - 1) == ';') {
            StringBuilder stringBuilder2 = sb;
            stringBuilder2.setLength(stringBuilder2.length() - 1);
        }
        return var1_1.toString();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + '[' + "intOpacity=" + this.intOpacity + ',' + "floatOpacity=" + this.floatOpacity + ',' + "x=" + this.x + ',' + "y=" + this.y + ',' + "position=" + (Object)((Object)this.position) + ',' + "files=" + this.files + ',' + "image=" + this.image + ',' + "enable=" + this.enable + ']';
    }
}

